/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.shared.error.crypto;

import java.util.Collections;
import java.util.List;
import org.iqtig.packer.shared.error.crypto.CryptoError;
import org.iqtig.packer.shared.error.crypto.NamedError;
import org.iqtig.packer.shared.error.crypto.StringUtils;

public class CryptoException
extends Exception {
    private List<CryptoError> errors;

    public CryptoException(CryptoError error) {
        super("Operation konnte nicht durchgef\u00fchrt werden, da folgender Fehler aufgetreten ist: " + error.getText());
        this.errors = Collections.singletonList(error);
    }

    public CryptoException(List<CryptoError> errors) {
        super("Operation konnte nicht durchgef\u00fchrt werden, da folgende Fehler aufgetreten sind: " + StringUtils.join(errors, " , "));
        this.errors = Collections.unmodifiableList(errors);
    }

    public CryptoException(NamedError errorId, String ... params) {
        this(new CryptoError(errorId, params));
    }

    public List<CryptoError> getErrors() {
        return this.errors;
    }

    public boolean containsNamedError(NamedError namedError) {
        for (CryptoError error : this.getErrors()) {
            if (!error.getErrorId().equals(namedError)) continue;
            return true;
        }
        return false;
    }
}

