/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.config;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import org.iqtig.xpacker.Configuration;

public class ConfigurationImpl
implements Configuration {
    private final boolean encypt;
    private final boolean decypt;
    private final boolean genKey;
    private final boolean getModulus;
    private final boolean checkKey;
    private final boolean compress = true;
    private final List<String> tag;
    private final String xmlInFileName;
    private final String xmlOufFileName;
    private final List<String> keyNames;
    private final String encryptedKeyTag;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final String publicKeyId;

    public ConfigurationImpl(ConfigurationBuilder builder) {
        this.encypt = builder.encypt;
        this.decypt = builder.decypt;
        this.genKey = builder.genKey;
        this.getModulus = builder.getModulus;
        this.checkKey = builder.checkKey;
        this.xmlInFileName = builder.xmlInFileName;
        this.xmlOufFileName = builder.xmlOufFileName;
        this.keyNames = builder.keyNames;
        this.tag = builder.tag;
        this.encryptedKeyTag = builder.encryptedKeyTag == null ? "encryption" : builder.encryptedKeyTag;
        this.privateKey = builder.privateKey;
        this.publicKey = builder.publicKey;
        this.publicKeyId = builder.publicKeyId;
    }

    @Override
    public boolean isEncrypt() {
        return this.encypt;
    }

    @Override
    public boolean isDecrypt() {
        return this.decypt;
    }

    @Override
    public boolean isGenKey() {
        return this.genKey;
    }

    @Override
    public boolean isGetModulus() {
        return this.getModulus;
    }

    @Override
    public boolean isCheckKey() {
        return this.checkKey;
    }

    @Override
    public String getXmlInFileName() {
        return this.xmlInFileName;
    }

    @Override
    public String getXmlOutFilename() {
        return this.xmlOufFileName;
    }

    @Override
    public List<String> getTags() {
        return this.tag;
    }

    @Override
    public List<String> getKeyNames() {
        return this.keyNames != null && !this.keyNames.isEmpty() ? this.keyNames : Arrays.asList("key");
    }

    @Override
    public String getEncryptedKeyTag() {
        return this.encryptedKeyTag;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    @Override
    public boolean isCompress() {
        return true;
    }

    public static class ConfigurationBuilder {
        private boolean encypt;
        private boolean decypt;
        private boolean genKey;
        private boolean getModulus;
        private boolean checkKey;
        private List<String> tag;
        private String xmlInFileName;
        private String xmlOufFileName;
        private List<String> keyNames;
        private String encryptedKeyTag;
        private PrivateKey privateKey;
        private PublicKey publicKey;
        private String publicKeyId;

        public ConfigurationBuilder encypt(boolean encypt) {
            this.encypt = encypt;
            return this;
        }

        public ConfigurationBuilder decypt(boolean decypt) {
            this.decypt = decypt;
            return this;
        }

        public ConfigurationBuilder genKey(boolean genKey) {
            this.genKey = genKey;
            return this;
        }

        public ConfigurationBuilder getModulus(boolean getModulus) {
            this.getModulus = getModulus;
            return this;
        }

        public ConfigurationBuilder checkKey(boolean checkKey) {
            this.checkKey = checkKey;
            return this;
        }

        public ConfigurationBuilder tag(List<String> tag) {
            this.tag = tag;
            return this;
        }

        public ConfigurationBuilder xmlInFileName(String xmlInFileName) {
            this.xmlInFileName = xmlInFileName;
            return this;
        }

        public ConfigurationBuilder xmlOuFileName(String xmlOufFileName) {
            this.xmlOufFileName = xmlOufFileName;
            return this;
        }

        public ConfigurationBuilder keyNames(List<String> keyNames) {
            this.keyNames = keyNames;
            return this;
        }

        public ConfigurationBuilder encryptedKeyTag(String encryptedKeyTag) {
            this.encryptedKeyTag = encryptedKeyTag;
            return this;
        }

        public ConfigurationBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public ConfigurationBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public ConfigurationBuilder publicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this;
        }

        public ConfigurationBuilder stat(Stat stat) {
            this.encypt = stat.isEncrypt();
            this.decypt = stat.isDecrypt();
            this.genKey = stat.isGenKey();
            return this;
        }

        public Configuration build() {
            return new ConfigurationImpl(this);
        }
    }

    public static enum Stat {
        ENCRYPT(true, false, false),
        DECRYPT(false, true, false),
        GENKEY(false, false, true);

        private final boolean encrypt;
        private final boolean decrypt;
        private final boolean genKey;

        private Stat(boolean encrypt, boolean decrypt, boolean genKey) {
            this.encrypt = encrypt;
            this.decrypt = decrypt;
            this.genKey = genKey;
        }

        public boolean isEncrypt() {
            return this.encrypt;
        }

        public boolean isDecrypt() {
            return this.decrypt;
        }

        public boolean isGenKey() {
            return this.genKey;
        }
    }
}

