/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.bouncycastle.util.encoders.Base64;
import org.iqtig.crypto.key.impl.KeyGetterImpl;
import org.iqtig.crypto.key.impl.XMLCryptionAsymImplOneKey;
import org.iqtig.crypto.key.interfaces.MyPublicKey;
import org.iqtig.crypto.key.interfaces.XMLCryptionAsym;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.xpacker.Configuration;
import org.iqtig.xpacker.config.ConfigHelper;
import org.iqtig.xpacker.constants.Constants;
import org.iqtig.xpacker.error.IqtigError;
import org.iqtig.xpacker.impl.KeyModulusGetter;
import org.iqtig.xpacker.impl.ProgressEvaluator;
import org.iqtig.xpacker.impl.Status;
import org.iqtig.xpacker.impl.keyverifier.KeyChecker;
import org.iqtig.xpacker.impl.sax.CompressionSaxHandler;
import org.iqtig.xpacker.support.XmlSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPacker {
    private static final Logger LOGGER = LoggerFactory.getLogger(XPacker.class);
    private ProgressEvaluator evaluator;

    public XPacker() {
    }

    public XPacker(ProgressEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void running(Configuration configuration) throws Exception {
        ConfigHelper configHelper = new ConfigHelper(configuration);
        if (!configHelper.checkParameter()) {
            throw new IqtigError(Constants.getArgsError(), configHelper.getParameterErrors());
        }
        if (configuration.isGenKey() && this.exactlyOneFunctionIsChosen(configuration)) {
            for (String keyName : configuration.getKeyNames()) {
                KeyPair keyPair = new KeyGetterImpl().newAsymmetricKey();
                try (FileOutputStream filePublicKey = new FileOutputStream(keyName + ".pub");
                     FileOutputStream filePrivateKey = new FileOutputStream(keyName + ".pri");){
                    XPacker.saveKeys(keyPair, filePublicKey, filePrivateKey);
                }
            }
        } else if (configuration.isGetModulus() && this.exactlyOneFunctionIsChosen(configuration)) {
            KeyModulusGetter modulusGenerator = new KeyModulusGetter(configuration.getKeyNames());
            modulusGenerator.printOutModulus();
        } else if (configuration.isCheckKey() && this.exactlyOneFunctionIsChosen(configuration)) {
            KeyChecker keyChecker = new KeyChecker(configuration.getXmlInFileName(), configuration.getKeyNames(), configuration.getTags());
            keyChecker.printOutKeyHasBeenUsedForTagEncryption();
        } else if (configuration.isEncrypt() ^ configuration.isDecrypt() && this.exactlyOneFunctionIsChosen(configuration)) {
            Document document = XPacker.inputXML(configuration);
            this.setNewTimeStamp(document);
            List<String> tags = configuration.getTags();
            Status status = new Status(document, tags, this.evaluator);
            XMLCryptionAsymImplOneKey cryptionAsym = new XMLCryptionAsymImplOneKey(status);
            for (String tagname : tags) {
                tagname = tagname.trim();
                if (configuration.isEncrypt()) {
                    XPacker.encrypt(document, tagname, cryptionAsym, configuration);
                    continue;
                }
                if (!configuration.isDecrypt()) continue;
                document = XPacker.decrypt(document, tagname, cryptionAsym, configuration);
            }
            XPacker.outputXML(configuration, document);
        } else {
            throw new IqtigError(Constants.getArgsError());
        }
    }

    private void setNewTimeStamp(Document document) {
        NodeList modNodes = document.getElementsByTagName("modification_dttm");
        for (int i = 0; i < modNodes.getLength(); ++i) {
            Element modElement = (Element)modNodes.item(i);
            modElement.removeAttribute("V");
            modElement.setAttribute("V", this.getDateTime());
        }
    }

    private String getDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document inputXML(Configuration config) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        block22: {
            if (config.isEncrypt()) {
                File tmp = File.createTempFile("iqtig", "xpacker");
                tmp.deleteOnExit();
                try {
                    if (config.getXmlInFileName() != null) {
                        File input = new File(config.getXmlInFileName());
                        List<String> tags = config.getTags();
                        try (FileInputStream xmlIn = null;){
                            if (config.isCompress()) {
                                LOGGER.debug("CompressionSaxHandler.compress('{}', '{}', '{}' )", config.getXmlInFileName(), tmp.getName(), tags);
                                CompressionSaxHandler.compress(input, tmp, tags.toArray(new String[0]));
                                xmlIn = new FileInputStream(tmp);
                            } else {
                                xmlIn = new FileInputStream(input);
                            }
                            document = XmlSupport.createDocumentFromIs(xmlIn);
                            break block22;
                        }
                    }
                    LOGGER.error("Eingabe-Datei nicht angegeben!");
                    throw Errors.InputFileIsMissing.createInstance();
                }
                finally {
                    if (tmp.exists() && !tmp.delete()) {
                        LOGGER.error("Konnte tempor\u00e4re Datei '{}' (mit m\u00f6glicherweise sensiblen Daten) nicht l\u00f6schen!", (Object)tmp.getAbsolutePath());
                    }
                }
            }
            if (config.getXmlInFileName() != null) {
                try (FileInputStream xmlIn = new FileInputStream(config.getXmlInFileName());){
                    document = XmlSupport.createDocumentFromIs(xmlIn);
                    break block22;
                }
                catch (FileNotFoundException e) {
                    throw Errors.InputFileIsMissing.createInstance();
                }
            }
            LOGGER.error("Eingabe-Datei nicht angegeben!");
            throw Errors.InputFileIsMissing.createInstance();
        }
        return document;
    }

    private static void outputXML(Configuration config, Document document) throws TransformerException, TransformerFactoryConfigurationError, IOException, SAXException {
        block18: {
            if (config.isDecrypt()) {
                File outputTmp = File.createTempFile("iqtig", "xpacker");
                FileOutputStream outputStreamTmp = null;
                try {
                    outputStreamTmp = new FileOutputStream(outputTmp);
                    XPacker.xmlOut(document, outputStreamTmp);
                    if (config.getXmlOutFilename() != null) {
                        List<String> tags = config.getTags();
                        File outputFile = new File(config.getXmlOutFilename());
                        if (!(!outputFile.exists() || outputFile.isFile() && outputFile.canWrite())) {
                            throw Errors.OutputFileCreationFailed.createInstance();
                        }
                        LOGGER.debug("CompressionSaxHandler.decompress('{}', '{}', '{}' )", outputTmp.getName(), config.getXmlOutFilename(), tags);
                        CompressionSaxHandler.decompress(outputTmp, new File(config.getXmlOutFilename()), tags.toArray(new String[0]));
                        break block18;
                    }
                    LOGGER.error("Ausgabe-Datei nicht angegeben!");
                    throw Errors.OutputFileCreationFailed.createInstance();
                }
                catch (FileNotFoundException e) {
                    throw Errors.OutputFileCreationFailed.createInstance();
                }
                finally {
                    if (outputStreamTmp != null) {
                        ((OutputStream)outputStreamTmp).close();
                    }
                    if (!outputTmp.delete()) {
                        LOGGER.error("Konnte tempor\u00e4re Datei '{}' (mit m\u00f6glicherweise sensiblen Daten) nicht l\u00f6schen!", (Object)outputTmp.getAbsolutePath());
                    }
                }
            }
            if (config.getXmlOutFilename() != null) {
                try (FileOutputStream outputStream = new FileOutputStream(config.getXmlOutFilename());){
                    XPacker.xmlOut(document, outputStream);
                    break block18;
                }
                catch (FileNotFoundException e) {
                    throw Errors.OutputFileCreationFailed.createInstance();
                }
            }
            LOGGER.error("Ausgabe-Datei nicht angegeben!");
            throw Errors.OutputFileCreationFailed.createInstance();
        }
    }

    static Document decrypt(Document document, String tagname, XMLCryptionAsym cryptionAsym, Configuration config) throws Exception {
        ArrayList<PrivateKey> privateKeys = new ArrayList<PrivateKey>();
        PrivateKey explPrivateKey = config.getPrivateKey();
        if (explPrivateKey != null) {
            privateKeys.add(explPrivateKey);
        } else {
            for (String privateKey : config.getKeyNames()) {
                try (FileInputStream in = new FileInputStream(privateKey);){
                    privateKeys.add(new KeyGetterImpl().readRSAPrivateKey(in));
                }
                catch (FileNotFoundException e) {
                    throw Errors.KeyFileNotFound.createInstance();
                }
                catch (InvalidKeySpecException e) {
                    throw Errors.PrivateKeyFileIsErroneous.createInstance();
                }
            }
        }
        document = cryptionAsym.decryptXMLDoc(document, privateKeys, tagname);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void encrypt(Document document, String tagname, XMLCryptionAsym cryptionAsym, Configuration config) throws Exception {
        ArrayList<MyPublicKey> publicKeys = new ArrayList<MyPublicKey>();
        if (null == config.getPublicKey()) {
            for (String keyname : config.getKeyNames()) {
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(keyname);
                    }
                    catch (FileNotFoundException e1) {
                        throw Errors.KeyFileNotFound.createInstance();
                    }
                    try {
                        publicKeys.add(new MyPublicKey(new File(keyname).getName() + "-" + tagname + "-" + Constants.getString("project.version"), new KeyGetterImpl().readRSAPublicKey(in)));
                    }
                    catch (InvalidKeySpecException e) {
                        throw Errors.PublicKeyFileIsErroneous.createInstance();
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        } else {
            String suffix = "-" + tagname + "-" + Constants.getString("project.version");
            String praefix = config.getPublicKeyId() == null || config.getPublicKeyId().isBlank() ? "noKeyIdProvided" : config.getPublicKeyId();
            publicKeys.add(new MyPublicKey(praefix + suffix, config.getPublicKey()));
        }
        cryptionAsym.encryptedXMLDoc(document, publicKeys, tagname, config.getEncryptedKeyTag());
    }

    private static void saveKeys(KeyPair keyPair, FileOutputStream filePublicKey, FileOutputStream filePrivateKey) throws IOException {
        filePublicKey.write(Base64.encode(keyPair.getPublic().getEncoded()));
        filePrivateKey.write(Base64.encode(keyPair.getPrivate().getEncoded()));
    }

    private static void xmlOut(Document document, OutputStream outputStream) throws TransformerException, TransformerFactoryConfigurationError {
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(outputStream));
    }

    private boolean exactlyOneFunctionIsChosen(Configuration configuration) {
        int i = 0;
        if (configuration.isGenKey()) {
            ++i;
        }
        if (configuration.isEncrypt()) {
            ++i;
        }
        if (configuration.isDecrypt()) {
            ++i;
        }
        if (configuration.isGetModulus()) {
            ++i;
        }
        if (configuration.isCheckKey()) {
            ++i;
        }
        return i == 1;
    }
}

