/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl.sax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.iqtig.xpacker.impl.sax.ElementRecorder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class SaxHandler
extends DefaultHandler
implements LexicalHandler {
    private boolean tagClosed = true;
    private int indent = -1;
    private boolean chars = false;

    public void parse(File inputFile, File outputFile, String[] elementsToProcess) throws SAXException, IOException {
        ElementRecorder.setOutputFile(outputFile);
        ElementRecorder.setElementsToRecord(elementsToProcess);
        ElementRecorder.setHandler(this);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(this);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        reader.setErrorHandler(this);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.parse(new InputSource(new FileInputStream(inputFile)));
        ElementRecorder.closeOutputFile();
    }

    public abstract String processDocument(String var1, String var2) throws IOException;

    @Override
    public void startDocument() {
        ElementRecorder.writeToFile("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.chars = false;
        ++this.indent;
        if (!this.tagClosed) {
            ElementRecorder.writeToFile('>');
        }
        ElementRecorder.writeToFile('\n');
        for (int i = 0; i < this.indent; ++i) {
            ElementRecorder.writeToFile('\t');
        }
        for (String elementName : ElementRecorder.getElementsToRecord()) {
            if (!qName.equals(elementName)) continue;
            ElementRecorder.startRecording();
        }
        ElementRecorder.writeToFile("<" + qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            ElementRecorder.writeToFile(" " + attributes.getQName(i) + "=\"" + this.escapeEntity(attributes.getValue(i)) + "\"");
        }
        this.tagClosed = false;
    }

    private String escapeEntity(String entity) {
        return entity.replace("&", "&amp;").replace("\"", "&#34;").replace("<", "&lt;").replace(">", "&gt;");
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (!this.tagClosed) {
            ElementRecorder.writeToFile("/>");
        } else {
            if (!this.chars) {
                ElementRecorder.writeToFile('\n');
                for (int i = 0; i < this.indent; ++i) {
                    ElementRecorder.writeToFile('\t');
                }
            }
            ElementRecorder.writeToFile("</");
            ElementRecorder.writeToFile(qName);
            ElementRecorder.writeToFile(">");
        }
        for (String elementName : ElementRecorder.getElementsToRecord()) {
            if (!qName.equals(elementName)) continue;
            ElementRecorder.stopRecording(elementName);
        }
        --this.indent;
        this.tagClosed = true;
        this.chars = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        block6: for (int i = start; i < start + length; ++i) {
            if (this.chars) {
                ElementRecorder.writeToFile(ch[i]);
                continue;
            }
            switch (ch[i]) {
                case '\n': {
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case ' ': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    if (!this.tagClosed) {
                        ElementRecorder.writeToFile('>');
                        this.tagClosed = true;
                    }
                    ElementRecorder.writeToFile(ch[i]);
                    this.chars = true;
                }
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.tagClosed) {
            ElementRecorder.writeToFile('>');
            this.tagClosed = true;
        }
        ElementRecorder.writeToFile("<!--");
        for (int i = start; i < start + length; ++i) {
            ElementRecorder.writeToFile(ch[i]);
        }
        ElementRecorder.writeToFile("-->");
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }
}

