/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.error;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.iqtig.packer.shared.error.ValidationErrorException;

public class IqtigError
extends RuntimeException {
    private static final long serialVersionUID = 5276055458546597393L;
    private transient Collection<ValidationErrorException> errors;

    public IqtigError(String message) {
        super(message);
        this.errors = new ArrayList<ValidationErrorException>();
    }

    public IqtigError(String message, Collection<ValidationErrorException> errors) {
        this(message);
        this.errors = errors;
    }

    public IqtigError(Collection<ValidationErrorException> errors) {
        this.errors = errors;
    }

    public void addError(ValidationErrorException error) {
        this.errors.add(error);
    }

    public Collection<String> getErrors() {
        ArrayList<String> errors2 = new ArrayList<String>();
        DecimalFormat i = new DecimalFormat("0000000");
        String message = this.getMessage();
        if (message != null) {
            errors2.add(message);
        }
        for (ValidationErrorException error : this.errors) {
            errors2.add("IQ" + i.format(error.getId()) + "\t" + error.getErrorMessage());
        }
        return errors2;
    }
}

