/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.iqtig.crypto.key.impl.KeyUsageVerifierImpl;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.iqtig.xpacker.error.IqtigError;

public class KeyModulusGetter {
    private RSAPublicKey rsaPublicKey;

    public KeyModulusGetter(List<String> keynames) throws IqtigError, CryptoException {
        if (keynames == null || keynames.isEmpty()) {
            throw Errors.ExactlyOneKeyNeeded.createInstance();
        }
        if (keynames.size() > 1) {
            throw Errors.OnlyOneKeyAllowed.createInstance();
        }
        this.initialize(new File(keynames.get(0)));
    }

    public KeyModulusGetter(File keyFile) throws CryptoException {
        this.initialize(keyFile);
    }

    public String getModulus() {
        KeyUsageVerifierImpl keyUsageVerifier = new KeyUsageVerifierImpl();
        return keyUsageVerifier.getModulus(this.rsaPublicKey);
    }

    public void printOutModulus() {
        System.out.println(this.getModulus());
    }

    private void initialize(File keyFile) throws CryptoException {
        if (keyFile == null) {
            throw Errors.PublicKeyFileIsNotSpecifiedException.createInstance();
        }
        try (FileInputStream fis = new FileInputStream(keyFile);){
            CryptographySupportShared cryptoShared = new CryptographySupportShared();
            this.rsaPublicKey = (RSAPublicKey)cryptoShared.readPublicKeyFromPem((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            throw Errors.KeyFileNotFound.createInstance();
        }
        catch (IOException e) {
            throw Errors.InputFileIOException.createInstance();
        }
    }
}

