/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl.keyverifier;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.iqtig.crypto.key.impl.KeyUsageVerifierImpl;
import org.iqtig.crypto.key.interfaces.KeyUsageVerifier;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.iqtig.packer.shared.error.crypto.StringUtils;
import org.xml.sax.SAXException;

public class KeyChecker {
    private FileInputStream xmlFileInputStream;
    private RSAPublicKey rsaPublicKey;
    private KeyUsageVerifier keyUsageVerifier;
    private String tag;

    public KeyChecker(String xmlInputFileName, List<String> keynames, List<String> tagnames) throws CryptoException {
        if (xmlInputFileName == null) {
            throw Errors.InputFileIsNotSpecifiedException.createInstance();
        }
        File xmlFile = new File(xmlInputFileName);
        if (keynames == null || keynames.isEmpty()) {
            throw Errors.ExactlyOneKeyNeeded.createInstance();
        }
        if (keynames.size() > 1) {
            throw Errors.OnlyOneKeyAllowed.createInstance();
        }
        File keyFile = new File(keynames.get(0));
        if (tagnames == null || tagnames.isEmpty()) {
            throw Errors.ExactlyOneTagNeeded.createInstance();
        }
        if (tagnames.size() > 1) {
            throw Errors.OnlyOneTagAllowed.createInstance();
        }
        this.initialize(xmlFile, keyFile, tagnames.get(0));
    }

    public KeyChecker(File xmlFile, File keyFile, String tag) throws CryptoException {
        this.initialize(xmlFile, keyFile, tag);
    }

    public boolean keyHasBeenUsedForTagEncryption() throws XMLSecurityException, SAXException {
        return this.keyUsageVerifier.keyHasBeenUsedForTagEncryption(this.xmlFileInputStream, this.rsaPublicKey, this.tag);
    }

    public void printOutKeyHasBeenUsedForTagEncryption() throws XMLSecurityException, SAXException {
        if (this.keyHasBeenUsedForTagEncryption()) {
            System.out.println("TRUE (Schluessel wurde f\u00fcr die Verschluesselung von Tag '" + this.tag + "' verwendet.)");
        } else {
            System.out.println("FALSE (Schluessel wurde nicht f\u00fcr die Verschluesselung von Tag '" + this.tag + "' verwendet.)");
        }
    }

    private void initialize(File xmlFile, File keyFile, String tag) throws CryptoException {
        if (xmlFile == null) {
            throw Errors.InputFileIsNotSpecifiedException.createInstance();
        }
        if (keyFile == null) {
            throw Errors.PublicKeyFileIsNotSpecifiedException.createInstance();
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            throw Errors.TagIsNotSpecifiedException.createInstance();
        }
        try {
            this.xmlFileInputStream = new FileInputStream(xmlFile);
        }
        catch (FileNotFoundException e) {
            throw Errors.InputFileIsMissing.createInstance();
        }
        try (FileInputStream keyFileInputStreamLocal = new FileInputStream(keyFile);){
            CryptographySupportShared cryptoShared = new CryptographySupportShared();
            this.rsaPublicKey = (RSAPublicKey)cryptoShared.readPublicKeyFromPem((InputStream)keyFileInputStreamLocal);
        }
        catch (FileNotFoundException e) {
            throw Errors.KeyFileNotFound.createInstance();
        }
        catch (IOException e) {
            throw Errors.InputFileIOException.createInstance();
        }
        this.tag = tag;
        this.keyUsageVerifier = new KeyUsageVerifierImpl();
    }
}

