/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl.keyverifier;

import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import org.iqtig.packer.shared.crypto.RSAModulus;

public class RSAPublicKeyId {
    private final RSAModulus rsaModulus;

    public RSAPublicKeyId(RSAPublicKey rsaPublicKey) {
        Objects.requireNonNull(rsaPublicKey, "Public-Key bei Initialisierung der KeyId darf nicht null sein.");
        this.rsaModulus = new RSAModulus(rsaPublicKey);
    }

    public RSAPublicKeyId(RSAModulus rsaModulus) {
        Objects.requireNonNull(rsaModulus, "RSA-Modulus bei Initialisierung der KeyId darf nicht null sein.");
        this.rsaModulus = rsaModulus;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RSAPublicKeyId other = (RSAPublicKeyId)obj;
        return Objects.equals(this.rsaModulus, other.rsaModulus);
    }

    public int hashCode() {
        return Objects.hash(this.rsaModulus);
    }
}

