/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.core.impl.crypto;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.util.List;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.iqtig.tpacker.core.impl.io.FileInputStreamContainer;

public class HybridEncrypt {
    private static final String UNHANDLED_EXCEPTION_MESSAGE = "Unhandled exception occurred.";
    private static final String TMP_PREF = "tpacker_tmp";
    private static final String ENC_SUFF = ".aes";
    PublicKey pubKey;

    public HybridEncrypt(PublicKey pubKey) {
        this.pubKey = pubKey;
    }

    public void encrypt(List<FileInputStreamContainer> fileContainer) throws IOException {
        for (FileInputStreamContainer fileCont : fileContainer) {
            Path tempFile = Files.createTempFile(TMP_PREF, ENC_SUFF, new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile.toFile());){
                this.encrypt(fileCont.getInputStream(), out);
                fileCont.setInputStream(new FileInputStream(tempFile.toFile()));
            }
        }
    }

    private void encrypt(InputStream inputStream, OutputStream outputStream) {
        CryptographySupportShared cryptographySupport = new CryptographySupportShared();
        try (InputStream inputStream2 = inputStream;){
            cryptographySupport.encrypt(inputStream, outputStream, cryptographySupport.createRandomAESSessionKey(), secretKey -> {
                try {
                    return cryptographySupport.wrapSecretKey(secretKey, this.pubKey);
                }
                catch (CryptoException e) {
                    throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
        }
        catch (CryptoException e) {
            throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
        }
    }
}

