/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.packer.shared.error.crypto.CryptoError;
import org.iqtig.packer.shared.error.crypto.CryptoErrorId;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.iqtig.packer.shared.error.crypto.NamedError;
import org.iqtig.tpacker.cli.Configuration;

public class KeyProvider {
    private final Configuration config;

    public KeyProvider(Configuration config) {
        this.config = config;
    }

    public PublicKey providePublicKey() {
        PublicKey publicKey;
        block9: {
            CryptographySupportShared cryptoSupport = new CryptographySupportShared();
            InputStream keyStream = this.getFileInputStream();
            try {
                publicKey = cryptoSupport.readPublicKeyFromPem(keyStream);
                if (keyStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (keyStream != null) {
                        try {
                            keyStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CryptoException e) {
                    throw Errors.PublicKeyFileIsErroneous.createInstance();
                }
                catch (IOException e1) {
                    throw new RuntimeException("Beim Schlie\u00dfen der \u00f6ffentlichen Schl\u00fcsseldatei trat eine IOException auf.", e1);
                }
            }
            keyStream.close();
        }
        return publicKey;
    }

    public PrivateKey providePrivateKey() {
        if (this.config.getPKCS12file() != null) {
            return this.providePrivateKeyFromKeystore();
        }
        return this.providePrivateKeyFromKeyFile();
    }

    private PrivateKey providePrivateKeyFromKeyFile() {
        PrivateKey privateKey;
        block9: {
            CryptographySupportShared cryptoSupport = new CryptographySupportShared();
            InputStream keyFileInputStream = this.getFileInputStream();
            try {
                privateKey = cryptoSupport.readPrivateKeyFromPem(keyFileInputStream);
                if (keyFileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (keyFileInputStream != null) {
                        try {
                            keyFileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CryptoException e) {
                    throw Errors.PrivateKeyFileIsErroneous.createInstance();
                }
                catch (IOException e1) {
                    throw new RuntimeException("Beim Schlie\u00dfen der privaten Schl\u00fcsseldatei trat eine IOException auf.", e1);
                }
            }
            keyFileInputStream.close();
        }
        return privateKey;
    }

    private PrivateKey providePrivateKeyFromKeystore() {
        CryptographySupportShared cryptoSupport = new CryptographySupportShared();
        PrivateKey privateKey = null;
        try (InputStream keystoreFileInputStream = this.getKeystoreFileInputStream();){
            privateKey = cryptoSupport.readPrivateKeyFromKeyStore(keystoreFileInputStream, this.config.getKeystorePassword(), this.config.getKeyentryAlias(), this.config.getKeyentryPassword());
        }
        catch (IOException | CryptoException e) {
            throw new RuntimeException("Beim Auslesen der Keystoredatei trat ein Fehler auf.", e);
        }
        if (privateKey == null) {
            CryptoException cryptoException = new CryptoException(new CryptoError((NamedError)CryptoErrorId.KEY_OF_KEYSTORE_NOT_FOUND, new String[0]));
            throw new RuntimeException("Unter dem Alias '" + this.config.getKeyentryAlias() + "' wurde kein Schluessel gefunden.", cryptoException);
        }
        return privateKey;
    }

    private InputStream getKeystoreFileInputStream() {
        Path KeystoreFilePath = Paths.get(this.config.getPKCS12file(), new String[0]);
        try {
            return Files.newInputStream(KeystoreFilePath, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new RuntimeException("Beim Verarbeiten der Keystoredatei trat eine IOException auf.");
        }
    }

    private InputStream getFileInputStream() {
        Path keyFilePath = Paths.get(this.config.getKeyfile(), new String[0]);
        try {
            return Files.newInputStream(keyFilePath, StandardOpenOption.READ);
        }
        catch (IOException e1) {
            throw new RuntimeException("Beim Verarbeiten der Schl\u00fcsseldatei trat eine IOException auf.", e1);
        }
    }
}

