/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.shared.cli;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.iqtig.packer.shared.cli.CliParam;

public final class CliParamParser {
    private CliParamParser() {
    }

    public static boolean option(List<String> args, CliParam option) {
        Boolean optionOk = false;
        for (String arg : args) {
            if (!arg.equals(option.getShortParam()) && !arg.equals(option.getLongParam()) && (!arg.startsWith("-") || arg.startsWith("--") || !arg.contains(option.getShortParam().substring(1, 2)))) continue;
            optionOk = true;
        }
        return optionOk;
    }

    public static String optionWithParam(List<String> args, CliParam option, Function<CliParam, RuntimeException> missingArgsExceptionProvider) {
        String opt = null;
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!arg.equals(option.getShortParam()) && !arg.equals(option.getLongParam())) continue;
            if (++i >= args.size() || args.get(i).startsWith("-")) {
                throw missingArgsExceptionProvider.apply(option);
            }
            opt = args.get(i);
        }
        return opt;
    }

    public static List<String> optionWithParams(List<String> arg, CliParam option, Function<CliParam, RuntimeException> missingArgsExceptionProvider) {
        String args = CliParamParser.optionWithParam(arg, option, missingArgsExceptionProvider);
        if (args != null) {
            return Arrays.asList(args.replace(";", ",").split(","));
        }
        return null;
    }

    public static Charset parseCharset(String charsetStringValue, Function<String, RuntimeException> exceptionSupplier) {
        if (charsetStringValue == null || charsetStringValue.length() <= 0) {
            return null;
        }
        if (!Charset.isSupported(charsetStringValue)) {
            throw exceptionSupplier.apply(charsetStringValue);
        }
        return Charset.forName(charsetStringValue);
    }
}

