/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.iqtig.packer.gui.GPackerActionValues;
import org.iqtig.packer.gui.GPackerConsolePrinter;
import org.iqtig.packer.gui.GPackerConsolePrinterImpl;
import org.iqtig.packer.gui.GPackerInputValidator;
import org.iqtig.packer.gui.GPackerKModeInputValues;
import org.iqtig.packer.gui.GPackerModel;
import org.iqtig.packer.gui.GPackerRtWrapper;
import org.iqtig.packer.gui.GPackerView;
import org.iqtig.packer.gui.GPackerViewCallback;
import org.iqtig.packer.gui.comp.Controller;
import org.iqtig.packer.gui.comp.MessageMode;
import org.iqtig.packer.gui.comp.ModelReferences;
import org.iqtig.packer.gui.comp.ProgressIndicationFeedback;
import org.iqtig.packer.gui.comp.View;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.GPackerConstants;
import org.iqtig.packer.gui.constants.InputFiletype;
import org.iqtig.packer.gui.constants.KeyfileType;
import org.iqtig.packer.gui.constants.KeystoreState;
import org.iqtig.packer.gui.constants.Keytype;
import org.iqtig.packer.gui.constants.ProcessingMode;
import org.iqtig.packer.gui.constants.Profile;
import org.iqtig.packer.gui.constants.Tag;
import org.iqtig.packer.gui.exception.AbstractGPackerExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrefGetValueExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrefInitExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrefPutValueExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreDeleteKeyExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreInitExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreStoreKeyExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPubKeystoreDeleteKeyExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPubKeystoreInitExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPubKeystoreLoadKeysExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPubKeystoreStoreKeyExceptionProcessor;
import org.iqtig.packer.gui.job.CryptoJob;
import org.iqtig.packer.gui.job.CryptoJobQueueBuilder;
import org.iqtig.packer.gui.job.CryptoJobSupport;
import org.iqtig.packer.gui.keymanagement.KeyAddResult;
import org.iqtig.packer.gui.keymanagement.KeyBoxEntry;
import org.iqtig.packer.gui.keymanagement.KeyContainer;
import org.iqtig.packer.gui.keymanagement.KeyList;
import org.iqtig.packer.gui.keymanagement.PrivateKeyContainer;
import org.iqtig.packer.gui.keymanagement.PublicKeyContainer;
import org.iqtig.packer.gui.keymanagement.keystore.KeystoreInitData;
import org.iqtig.packer.gui.keymanagement.keystore.PrivateKeystore;
import org.iqtig.packer.gui.keymanagement.keystore.PublicKeystore;
import org.iqtig.packer.gui.keymanagement.keystore.factory.KeystoreFactory;
import org.iqtig.packer.gui.keymanagement.keystore.output.DefaultResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.InitResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeystoreOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.PersistentUniInitResult;
import org.iqtig.packer.gui.utils.FileUtils;
import org.iqtig.packer.shared.keyio.output.KeyloadOutput;
import org.iqtig.packer.shared.keyio.output.KeyloadResult;

public class GPackerController
implements Controller,
GPackerViewCallback {
    private static final int EFFORT_UNZIP_TX = 2;
    private final DateTimeFormatter dateFormatConsole = DateTimeFormatter.ofPattern("[yyyy-MM-dd HH:mm:ss]");
    private final DateTimeFormatter dateFormatTimestampFolder = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private final DateTimeFormatter dateFormatTimestampTxEncrptionFileName = DateTimeFormatter.ofPattern("yyyy_MM_dd_HHmmss");
    private final GPackerModel model;
    private final GPackerView view;
    private final Consumer<Void> shutdownParentCallback;
    private final CryptoJobSupport cryptoJobSupport = new CryptoJobSupport();
    private final GPackerInputValidator validator = new GPackerInputValidator();
    private final Preferences appPreferences;
    private final Map<Tag, ModelReferences<Boolean>> tagModelReferencesSelection;
    private final PublicKeystore publicKeystore = KeystoreFactory.getPublicKeystore();
    private final PrivateKeystore privateKeystore = KeystoreFactory.getPrivateKeystore();
    private final GPackerConsolePrinter consolePrinter;

    public GPackerController(Consumer<Void> shutdownParentCallback) {
        this.model = new GPackerModel();
        this.consolePrinter = new GPackerConsolePrinterImpl(this.dateFormatConsole, this.model);
        this.appPreferences = this.initAppPreferences();
        this.shutdownParentCallback = shutdownParentCallback;
        this.tagModelReferencesSelection = this.initTagModelReferencesSelection(this.model);
        this.registerModelListeners(this.model);
        this.initPrivateKeystore(this.privateKeystore);
        this.view = new GPackerView().setPrivateKeystore(this.privateKeystore).setConsolePrinter(this.consolePrinter).init().bindStateAndData(this.model).bindActions(this, this.model);
        this.model.setInputFileSelectedLastPMode(this.getFileFromPreferences("lastInputFolderSelection", x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
        this.model.setInputFileSelectedLastKMode(this.getFileFromPreferences("lastInputFolderSelection", x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
        this.model.setOutputFolderPMode(this.getFileFromPreferences("lastOutputFolderSelection", x$0 -> Files.isDirectory(x$0, new LinkOption[0])));
        this.model.setOutputFolderKMode(this.getFileFromPreferences("lastOutputFolderSelection", x$0 -> Files.isDirectory(x$0, new LinkOption[0])));
        this.model.setRegistrationNumberPMode(this.getSafeFromPreferences("lastRegNoPMode", null));
        this.model.setActualSelectedKeyfileLast(this.getFileFromPreferences("lastActualKeyfileSelection", x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
        this.initPublicKeystore(this.publicKeystore, this.model);
        this.consolePrinter.printlnInEdt(String.format("JVM-encoding=%s", System.getProperty("file.encoding")));
    }

    public Preferences initAppPreferences() {
        Preferences result = null;
        try {
            result = Preferences.userNodeForPackage(this.getClass());
        }
        catch (Exception e) {
            GPackerPrefInitExceptionProcessor exceptionProcessor = new GPackerPrefInitExceptionProcessor(e, this.consolePrinter::printErrln);
            ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
        }
        return result;
    }

    public void putSafeToPreferences(String key, String value) {
        try {
            if (this.appPreferences != null) {
                this.appPreferences.put(key, value);
            }
        }
        catch (Exception e) {
            GPackerPrefPutValueExceptionProcessor exceptionProcessor = new GPackerPrefPutValueExceptionProcessor(e, this.consolePrinter::printErrln);
            ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
        }
    }

    public String getSafeFromPreferences(String key, String def) {
        String result = null;
        try {
            if (this.appPreferences != null) {
                result = this.appPreferences.get(key, def);
            }
        }
        catch (Exception e) {
            GPackerPrefGetValueExceptionProcessor exceptionProcessor = new GPackerPrefGetValueExceptionProcessor(e, this.consolePrinter::printErrln);
            ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
        }
        return result;
    }

    public void initPrivateKeystore(PrivateKeystore privateKeystore) {
        PersistentUniInitResult result = privateKeystore.initPersistenceUnit(new KeystoreInitData(this.appPreferences, "privateKeys"));
        GPackerPrivKeystoreInitExceptionProcessor exceptionProcessor = new GPackerPrivKeystoreInitExceptionProcessor(result, this.consolePrinter::printErrln);
        ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
    }

    public void initPublicKeystore(PublicKeystore publicKeystore, GPackerModel model) {
        PersistentUniInitResult publicKeystoreOutput = publicKeystore.initPersistenceUnit(new KeystoreInitData(this.appPreferences, "publicKeys"));
        if (InitResult.SUCCESS.equals((Object)publicKeystoreOutput.getResult())) {
            KeylistOutput loadKeyOutput = publicKeystore.loadKeyContainer();
            if (KeylistResult.SUCCESS.equals((Object)loadKeyOutput.getResult())) {
                model.setPublicKeylist(loadKeyOutput.getKeyList());
            } else if (KeylistResult.ERROR.equals((Object)loadKeyOutput.getResult())) {
                GPackerPubKeystoreLoadKeysExceptionProcessor exceptionProcessor = new GPackerPubKeystoreLoadKeysExceptionProcessor(loadKeyOutput, this.consolePrinter::printErrln);
                ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
                this.deactivatePublicKeystore();
            }
        } else if (InitResult.ERROR.equals((Object)publicKeystoreOutput.getResult()) || InitResult.PREF_ERROR.equals((Object)publicKeystoreOutput.getResult())) {
            GPackerPubKeystoreInitExceptionProcessor exceptionProcessor = new GPackerPubKeystoreInitExceptionProcessor(publicKeystoreOutput, this.consolePrinter::printErrln);
            ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
            this.deactivatePublicKeystore();
        }
    }

    public void deactivatePublicKeystore() {
        this.publicKeystore.clearPersistenceUnit();
        this.publicKeystore.deactivate();
    }

    @Override
    public void doShutDown() {
        this.shutdownParentCallback.accept(null);
    }

    @Override
    public void openReferringDirectory(File fileOrFolder) {
        this.openReferringDirectoryInExplorer(fileOrFolder);
    }

    @Override
    public void clearPreferences() {
        try {
            this.appPreferences.clear();
            this.consolePrinter.println("Gespeicherte Einstellungen wurden gel\u00f6scht.");
        }
        catch (BackingStoreException e) {
            this.consolePrinter.printErrln("Die Anwendungseinstellungen konnten nicht gel\u00f6scht werden.");
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void addKey(GPackerView.AddKeyViewProcessor addKeyViewProcessor) {
        KeyfileType keyfileType = this.model.getKeyfileType();
        File keyFileOrContainerFile = this.model.getActualSelectedKeyfile();
        String nameOfNewKey = this.model.getKeyName();
        String keystorePassword = this.model.getPasswordKeystore();
        String keyentryAlias = this.model.getAliasKeyentry();
        String keyentryPassword = this.model.getPasswordKeyentry();
        if (addKeyViewProcessor.checkIfKeynameIsInvalidOrAlreadyAssignedOrKeyfileNotSpecified(this.model, nameOfNewKey)) {
            AbstractGPackerExceptionProcessor exceptionProcessor;
            KeyloadOutput output;
            KeyAddResult keyAddResult = null;
            if (this.model.getPrivateKeysSelected() && addKeyViewProcessor.checkIfPrivateKeystoreIsUnlocked(this.model)) {
                KeyList<PrivateKeyContainer> privateKeylist = this.model.getPrivateKeylist();
                PrivateKeyContainer newPrivateKey = null;
                if (KeyfileType.KEYFILE.equals(keyfileType)) {
                    newPrivateKey = new PrivateKeyContainer(nameOfNewKey, keyFileOrContainerFile);
                } else if (KeyfileType.KEYSTORE.equals(keyfileType)) {
                    newPrivateKey = new PrivateKeyContainer(nameOfNewKey, keyFileOrContainerFile, keystorePassword, keyentryAlias, keyentryPassword);
                }
                KeyloadOutput keyloadOutput = output = newPrivateKey != null ? newPrivateKey.loadKey() : null;
                if (output == null) {
                    throw new RuntimeException("Neuer Schl\u00fcssel konnte nicht erstellt werden. Wahrscheinlich ist im Modell kein Keyfiletype hinterlegt.");
                }
                if (KeyloadResult.OK.equals((Object)output.getResult())) {
                    KeystoreOutput privKeystoreOutput;
                    keyAddResult = privateKeylist.addKey(newPrivateKey);
                    if (KeyAddResult.OK.equals((Object)keyAddResult) && this.privateKeystore.isActive() && DefaultResult.ERROR.equals((Object)(privKeystoreOutput = this.privateKeystore.storeKeyContainer(newPrivateKey)).getResult())) {
                        exceptionProcessor = new GPackerPrivKeystoreStoreKeyExceptionProcessor(privKeystoreOutput, this.consolePrinter::printErrln);
                        exceptionProcessor.process();
                        this.privateKeystore.resetPrivateKeyStore();
                        this.privateKeystore.deactivate();
                        this.model.setPrivateKeystoreState(KeystoreState.INACTIVE);
                    }
                    addKeyViewProcessor.createMsgForAddingKey(this.model, keyAddResult, newPrivateKey, Keytype.PRIVATE);
                    this.model.setPrivateKeylist(KeyList.of(privateKeylist));
                    addKeyViewProcessor.updateComponents(this.model, keyAddResult, nameOfNewKey);
                } else {
                    this.handleKeyloadErrors(output);
                }
            }
            if (this.model.getPublicKeysSelected()) {
                KeyList<PublicKeyContainer> publicKeylist = this.model.getPublicKeylist();
                PublicKeyContainer newPublicKey = null;
                if (KeyfileType.KEYFILE.equals(keyfileType)) {
                    newPublicKey = new PublicKeyContainer(nameOfNewKey, keyFileOrContainerFile);
                } else if (KeyfileType.KEYSTORE.equals(keyfileType)) {
                    newPublicKey = new PublicKeyContainer(nameOfNewKey, keyFileOrContainerFile, keystorePassword, keyentryAlias);
                }
                KeyloadOutput keyloadOutput = output = newPublicKey != null ? newPublicKey.loadKey() : null;
                if (output == null) {
                    throw new RuntimeException("Neuer Schl\u00fcssel konnte nicht erstellt werden. Wahrscheinlich ist im Modell kein Keyfiletype hinterlegt.");
                }
                if (KeyloadResult.OK.equals((Object)output.getResult())) {
                    KeystoreOutput storeOutput;
                    keyAddResult = publicKeylist.addKey(newPublicKey);
                    if (KeyAddResult.OK.equals((Object)keyAddResult) && this.publicKeystore.isActive() && DefaultResult.ERROR.equals((Object)(storeOutput = this.publicKeystore.storeKeyContainer(newPublicKey)).getResult())) {
                        exceptionProcessor = new GPackerPubKeystoreStoreKeyExceptionProcessor(storeOutput, this.consolePrinter::printErrln);
                        exceptionProcessor.process();
                        this.deactivatePublicKeystore();
                    }
                    addKeyViewProcessor.createMsgForAddingKey(this.model, keyAddResult, newPublicKey, Keytype.PUBLIC);
                    this.model.setPublicKeylist(KeyList.of(publicKeylist));
                    addKeyViewProcessor.updateComponents(this.model, keyAddResult, nameOfNewKey);
                } else {
                    this.handleKeyloadErrors(output);
                }
            }
        }
    }

    @Override
    public void deleteKey(GPackerView.DeleteKeyViewProcessor deleteKeyViewProcessor) {
        AbstractGPackerExceptionProcessor exceptionProcessor;
        String selectedKeyName;
        String string = selectedKeyName = this.model.getSelectedKeyname() != null ? this.model.getSelectedKeyname().getLabel() : null;
        if (this.model.getPrivateKeysSelected()) {
            KeystoreOutput privKeystoreOutput;
            KeyList<PrivateKeyContainer> privateKeylist = this.model.getPrivateKeylist();
            privateKeylist.deleteKeyByName(selectedKeyName);
            if (this.privateKeystore.isActive() && DefaultResult.ERROR.equals((Object)(privKeystoreOutput = this.privateKeystore.deleteKeyContainer(selectedKeyName)).getResult())) {
                exceptionProcessor = new GPackerPrivKeystoreDeleteKeyExceptionProcessor(privKeystoreOutput, this.consolePrinter::printErrln);
                exceptionProcessor.process();
                this.privateKeystore.resetPrivateKeyStore();
                this.privateKeystore.deactivate();
                this.model.setPrivateKeystoreState(KeystoreState.INACTIVE);
            }
            this.model.setPrivateKeylist(KeyList.of(privateKeylist));
        }
        if (this.model.getPublicKeysSelected()) {
            KeystoreOutput deleteOutput;
            KeyList<PublicKeyContainer> publicKeylist = this.model.getPublicKeylist();
            publicKeylist.deleteKeyByName(selectedKeyName);
            if (this.publicKeystore.isActive() && DefaultResult.ERROR.equals((Object)(deleteOutput = this.publicKeystore.deleteKeyContainer(selectedKeyName)).getResult())) {
                exceptionProcessor = new GPackerPubKeystoreDeleteKeyExceptionProcessor(deleteOutput, this.consolePrinter::printErrln);
                exceptionProcessor.process();
                this.deactivatePublicKeystore();
            }
            this.model.setPublicKeylist(KeyList.of(publicKeylist));
        }
        deleteKeyViewProcessor.updateComponents(this.model);
    }

    @Override
    public void doExecute(final ProgressIndicationFeedback progressIndicationCallback, final Consumer<Void> postExecutionAction) {
        final GPackerActionValues actionValues = this.getActionValuesFromModel(this.model);
        String validationErrorMsg = this.validator.validate(actionValues);
        if (StringUtils.isNotBlank(validationErrorMsg)) {
            postExecutionAction.accept(null);
            this.showAndPrintMessage(validationErrorMsg, MessageMode.WARNING);
            return;
        }
        new SwingWorker<Path, Void>(){

            @Override
            protected Path doInBackground() {
                return GPackerController.this.runInBackground(actionValues, progressIndicationCallback);
            }

            @Override
            protected void done() {
                Path createdExecutionFolderPath = null;
                try {
                    createdExecutionFolderPath = (Path)this.get();
                }
                catch (InterruptedException e) {
                    GPackerController.this.consolePrinter.printErrln("Die Ausf\u00fchrung wurde abgebrochen");
                }
                catch (ExecutionException e) {
                    GPackerController.this.printDifferentiatedExceptionMessages(e);
                }
                boolean success = createdExecutionFolderPath != null;
                String consoleMsg = success ? "Ausf\u00fchrung erfolgreich abgeschlossen." : "Ausf\u00fchrung wurde abgebrochen.";
                GPackerController.this.consolePrinter.println(consoleMsg);
                postExecutionAction.accept(null);
                if (success) {
                    Path createdExecutionFolderPathFinal = createdExecutionFolderPath;
                    GPackerController.this.view.showConfirmationPopup("Ausf\u00fchrung erfolgreich abgeschlossen.", "Ergebnisordner \u00f6ffnen?", i -> GPackerController.this.openReferringDirectoryInExplorer(createdExecutionFolderPathFinal.toFile()));
                }
            }
        }.execute();
    }

    private Map<Tag, ModelReferences<Boolean>> initTagModelReferencesSelection(GPackerModel model) {
        EnumMap<Tag, ModelReferences<Boolean>> tagModelReferencesSelectionLocal = new EnumMap<Tag, ModelReferences<Boolean>>(Tag.class);
        tagModelReferencesSelectionLocal.put(Tag.CARE_PROVIDER, new ModelReferences<Boolean>("selectedTagCareProvider", model::setSelectedTagCareProvider, model::isSelectedTagCareProvider));
        tagModelReferencesSelectionLocal.put(Tag.QS_DATA, new ModelReferences<Boolean>("selectedTagQsData", model::setSelectedTagQsData, model::isSelectedTagQsData));
        tagModelReferencesSelectionLocal.put(Tag.PATIENT, new ModelReferences<Boolean>("selectedTagPatient", model::setSelectedTagPatient, model::isSelectedTagPatient));
        tagModelReferencesSelectionLocal.put(Tag.PATIENT_TX, new ModelReferences<Boolean>("selectedTagPatientTx", model::setSelectedTagPatientTx, model::isSelectedTagPatientTx));
        return tagModelReferencesSelectionLocal;
    }

    private void registerModelListeners(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            File outputFolder;
            if ("outputFolder".equals(e.getPropertyName()) && (outputFolder = model.getOutputFolderPMode()) != null) {
                this.putSafeToPreferences("lastOutputFolderSelection", outputFolder.getPath());
                model.setOutputFolderSelectedLastGlobal(outputFolder);
            }
        });
        model.addPropertyChangeListener(e -> {
            File inputFile;
            if ("inputFile".equals(e.getPropertyName()) && (inputFile = model.getInputFilePMode()) != null) {
                this.putSafeToPreferences("lastInputFolderSelection", inputFile.getPath());
                model.setInputFileSelectedLastGlobal(inputFile);
            }
        });
        model.addPropertyChangeListener(e -> {
            String registrationNumber;
            if ("registrationNumberPMode".equals(e.getPropertyName()) && StringUtils.isNotBlank(registrationNumber = model.getRegistrationNumberPMode())) {
                this.putSafeToPreferences("lastRegNoPMode", registrationNumber);
            }
        });
        model.addPropertyChangeListener(e -> {
            File inputFile;
            if ("inputFileKMode".equals(e.getPropertyName()) && (inputFile = model.getInputFileKMode()) != null) {
                this.putSafeToPreferences("lastInputFolderSelection", inputFile.getPath());
                model.setInputFileSelectedLastGlobal(inputFile);
            }
        });
        model.addPropertyChangeListener(e -> {
            File outputFolder;
            if ("outputFolderKMode".equals(e.getPropertyName()) && (outputFolder = model.getOutputFolderKMode()) != null) {
                this.putSafeToPreferences("lastOutputFolderSelection", outputFolder.getPath());
                model.setOutputFolderSelectedLastGlobal(outputFolder);
            }
        });
        model.addPropertyChangeListener(e -> {
            File selectedKeyfile;
            if ("actualSelectedKeyfile".equals(e.getPropertyName()) && (selectedKeyfile = model.getActualSelectedKeyfile()) != null) {
                this.putSafeToPreferences("lastActualKeyfileSelection", selectedKeyfile.getPath());
                model.setActualSelectedKeyfileLast(selectedKeyfile);
            }
        });
    }

    private File getFileFromPreferences(String prefKey, Predicate<Path> predicate) {
        Path path;
        File result = null;
        String pathString = this.getSafeFromPreferences(prefKey, null);
        if (pathString != null && Files.exists(path = Paths.get(pathString, new String[0]), new LinkOption[0]) && predicate.test(path)) {
            result = path.toFile();
        }
        return result;
    }

    private void handleKeyloadErrors(KeyloadOutput keyloadOutput) {
        KeyloadResult keyloadResult = keyloadOutput.getResult();
        switch (keyloadResult) {
            case IO_ERROR: {
                this.showAndPrintMessage("Beim Laden des Schl\u00fcssels trat ein Eingabe-/Ausgabefehler auf.", MessageMode.ERROR);
                break;
            }
            case INVALID_KEY: {
                this.showAndPrintMessage("Der Schl\u00fcssel ist ung\u00fcltig. Fehlerhafte oder falsche Schl\u00fcsseldatei.", MessageMode.ERROR);
                break;
            }
            case INVALID_KEYSTORE: {
                this.showAndPrintMessage("Beim Laden des Schl\u00fcssels ist ein Fehler aufgetreten. Evtl. handelt es sich nicht um eine Keystore-Datei.", MessageMode.ERROR);
                break;
            }
            case KEYSTORE_PASSWORD_WRONG: {
                this.showAndPrintMessage("Das Keystore-Passwort ist falsch.", MessageMode.ERROR);
                break;
            }
            case KEYENTRY_NOT_FOUND: {
                this.showAndPrintMessage("Unter dem Alias wurde kein Schl\u00fcsseleintrag gefunden.", MessageMode.ERROR);
                break;
            }
            case ALIAS_OR_EMPTY_KEYSTORE_PW_WRONG: {
                this.showAndPrintMessage("Alias oder leeres Passwort falsch.", MessageMode.ERROR);
                break;
            }
            case KEYENTRY_PASSWORD_WRONG: {
                this.showAndPrintMessage("Das Keyentry-Passwort ist falsch.", MessageMode.ERROR);
                break;
            }
            case ERROR: {
                this.showAndPrintMessage("Beim Laden des Schl\u00fcssels ist ein Fehler aufgetreten.", MessageMode.ERROR);
                break;
            }
        }
    }

    private void printDifferentiatedExceptionMessages(ExecutionException e) {
        GPackerExceptionProcessor exceptionProcessor = new GPackerExceptionProcessor(e, this.consolePrinter::printErrln);
        exceptionProcessor.process();
    }

    private void showAndPrintMessage(String msg, MessageMode mode) {
        this.consolePrinter.println("***" + mode.getHeading() + ": " + msg);
        this.view.showMsgPopup(msg, mode);
    }

    private GPackerActionValues getActionValuesFromModel(GPackerModel model) {
        Map<Tag, KeyContainer> keysByTag = this.getKeysByTagFromModel(model);
        PrivateKey privateKeyKMode = this.getPrivateKeyKMode(model);
        PublicKey publicKeyKMode = this.getPublicKeyKMode(model);
        return new GPackerActionValues.GPackerActionValuesBuilder().action(model.getAction()).profile(model.getProfile()).inputFilePMode(model.getInputFilePMode()).inputFileTypePMode(model.getInputFileTypePMode()).inputFileTypeKMode(model.getInputFileTypeKMode()).outputFolderPMode(model.getOutputFolderPMode()).keysByTag(keysByTag).privateKeyKMode(privateKeyKMode).publicKeyKMode(publicKeyKMode).selectedOptionTxEncryption(model.isSelectedOptionTxEncryption()).password(model.getTxEncryptionPassword()).regnumber(model.getProcessingMode().equals((Object)ProcessingMode.PMODE) ? model.getRegistrationNumberPMode() : "").passwordKeystore(model.getPasswordKeystore()).aliasKeyentry(model.getAliasKeyentry()).passwordKeyentry(model.getPasswordKeyentry()).processingMode(model.getProcessingMode()).keyfileType(model.getKeyfileType()).inputFileKMode(model.getInputFileKMode()).outputFolderKMode(model.getOutputFolderKMode()).actionKMode(model.getActionKMode()).build();
    }

    private Map<Tag, KeyContainer> getKeysByTagFromModel(GPackerModel model) {
        KeyList<KeyContainer> keys;
        EnumMap<Tag, KeyContainer> result = new EnumMap<Tag, KeyContainer>(Tag.class);
        KeyList<KeyContainer> keyList = keys = model.getAction() == Action.DECRYPT ? model.getPrivateKeylist() : model.getPublicKeylist();
        if (keys != null) {
            if (model.isSelectedTagCareProvider()) {
                result.put(Tag.CARE_PROVIDER, model.getKeyTagCareProvider() != null ? keys.getKeyByName(model.getKeyTagCareProvider().getLabel()) : null);
            }
            if (model.isSelectedTagQsData()) {
                result.put(Tag.QS_DATA, model.getKeyTagQsData() != null ? keys.getKeyByName(model.getKeyTagQsData().getLabel()) : null);
            }
            if (model.isSelectedTagPatient()) {
                result.put(Tag.PATIENT, model.getKeyTagPatient() != null ? keys.getKeyByName(model.getKeyTagPatient().getLabel()) : null);
            }
            if (model.isSelectedTagPatientTx()) {
                result.put(Tag.PATIENT_TX, model.getKeyTagPatientTx() != null ? keys.getKeyByName(model.getKeyTagPatientTx().getLabel()) : null);
            }
        }
        return result;
    }

    public PublicKey getPublicKeyKMode(GPackerModel model) {
        PublicKey result = null;
        KeyBoxEntry keyEntry = model.getSelectedKeynameKMode();
        KeyList<PublicKeyContainer> keyList = model.getPublicKeylist();
        if (keyEntry != null) {
            PublicKeyContainer keyCont = keyList.getKeyByName(keyEntry.getLabel());
            result = keyCont != null ? (PublicKey)((KeyContainer)keyCont).getKey() : null;
        }
        return result;
    }

    public PrivateKey getPrivateKeyKMode(GPackerModel model) {
        PrivateKey result = null;
        KeyBoxEntry keyEntry = model.getSelectedKeynameKMode();
        KeyList<PrivateKeyContainer> keyList = model.getPrivateKeylist();
        if (keyEntry != null) {
            PrivateKeyContainer keyCont = keyList.getKeyByName(keyEntry.getLabel());
            result = keyCont != null ? (PrivateKey)((KeyContainer)keyCont).getKey() : null;
        }
        return result;
    }

    private Path runInBackground(GPackerActionValues actionValues, ProgressIndicationFeedback progressIndicationCallback) {
        Path packerRunFolderPath;
        ProcessingMode processingMode = actionValues.processingMode;
        boolean pmode = actionValues.processingMode == ProcessingMode.PMODE;
        boolean kmode = actionValues.processingMode == ProcessingMode.KMODE;
        Action actionPMode = actionValues.actionPMode;
        boolean handleTransportEncryption = actionValues.selectedOptionTxEncryption && pmode || kmode;
        File inputFile = pmode ? actionValues.inputFilePMode : actionValues.inputFileKMode;
        File outputFolder = pmode ? actionValues.outputFolderPMode : actionValues.outputFolderKMode;
        Map<Tag, KeyContainer> keysByTag = actionValues.keysByTag;
        String transportEncryptionPassword = actionValues.password;
        GPackerKModeInputValues kModeInput = actionValues.getKModeInputValues();
        TemporaryFileWastebin wastebin = new TemporaryFileWastebin();
        HashMap<File, List<CryptoJob>> jobQueuesWithStartValue = new HashMap<File, List<CryptoJob>>(1);
        LocalDateTime execTimeStamp = LocalDateTime.now();
        try {
            boolean kModeTransportDecryption;
            packerRunFolderPath = outputFolder.toPath().resolve(execTimeStamp.format(this.dateFormatTimestampFolder));
            Files.createDirectories(packerRunFolderPath, new FileAttribute[0]);
            this.consolePrinter.println("Ausf\u00fchrungsordner erzeugt: " + packerRunFolderPath);
            boolean pModeTransportDecryption = ProcessingMode.PMODE == processingMode && Action.DECRYPT == actionPMode && handleTransportEncryption;
            boolean bl = kModeTransportDecryption = ProcessingMode.KMODE == processingMode && Action.DECRYPT == kModeInput.actionKMode;
            if (pModeTransportDecryption || kModeTransportDecryption) {
                progressIndicationCallback.defineInitialProgressMax(2);
                this.consolePrinter.println(String.format("[BGN] %s: Transportverschl\u00fcsselung", Action.DECRYPT.getLabel()));
                Path tempUnzippedFolderPath = this.cryptoJobSupport.tUnzipAusAeFileToFolder(processingMode, kModeInput, inputFile.toPath(), transportEncryptionPassword);
                wastebin.addTempFolder(tempUnzippedFolderPath);
                List<Path> allUnzippedTempFiles = this.getAllFileInFolderAsPaths(tempUnzippedFolderPath);
                for (Path unzippedTempFile : allUnzippedTempFiles) {
                    this.consolePrinter.println("      Entpackte Datei: " + unzippedTempFile.getFileName().toString());
                }
                for (Path oneUnzippedTempFile : allUnzippedTempFiles) {
                    Path targetFilePath = packerRunFolderPath.resolve(oneUnzippedTempFile.getFileName().toString());
                    if (keysByTag.isEmpty() || kModeTransportDecryption) {
                        Files.copy(oneUnzippedTempFile, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    CryptoJobQueueBuilder builder = new CryptoJobQueueBuilder(processingMode, actionPMode, targetFilePath, progressIndicationCallback::burnDownProgress, this.consolePrinter::println).withTags(keysByTag);
                    jobQueuesWithStartValue.put(oneUnzippedTempFile.toFile(), builder.build());
                }
                this.consolePrinter.println(String.format("[END] %s: Transportverschl\u00fcsselung", Action.DECRYPT.getLabel()));
                progressIndicationCallback.burnDownProgress(2);
            } else {
                progressIndicationCallback.defineInitialProgressMax(0);
                Path targetFilePathXPacker = packerRunFolderPath.resolve(inputFile.toPath().getFileName().toString());
                CryptoJobQueueBuilder builder = new CryptoJobQueueBuilder(processingMode, actionPMode, targetFilePathXPacker, progressIndicationCallback::burnDownProgress, this.consolePrinter::println).withTags(keysByTag);
                if (handleTransportEncryption) {
                    String fileName = this.composeFilename(actionValues, execTimeStamp);
                    Path targetFilePathTPacker = packerRunFolderPath.resolve(fileName);
                    builder.withTransportEncryption(transportEncryptionPassword, targetFilePathTPacker, kModeInput);
                }
                jobQueuesWithStartValue.put(inputFile, builder.build());
            }
            int jobWeight = this.cryptoJobSupport.getWeight(jobQueuesWithStartValue.values());
            progressIndicationCallback.increaseMax(jobWeight);
            for (Map.Entry jobQueueWithStartValue : jobQueuesWithStartValue.entrySet()) {
                List<File> tempFiles = this.cryptoJobSupport.executeJobQueue((Collection)jobQueueWithStartValue.getValue(), (File)jobQueueWithStartValue.getKey());
                wastebin.addTempFiles(tempFiles);
            }
        }
        catch (IOException e) {
            throw new GPackerRtWrapper(e);
        }
        finally {
            wastebin.emtpy();
        }
        return packerRunFolderPath;
    }

    private String composeFilename(GPackerActionValues actionValues, LocalDateTime execTimeStamp) {
        String regNumber;
        String string = regNumber = actionValues.regNumber == null ? "" : actionValues.regNumber;
        if (InputFiletype.CERTIFICATE.equals((Object)actionValues.inputFileTypePMode) && actionValues.processingMode == ProcessingMode.PMODE || InputFiletype.CERTIFICATE.equals((Object)actionValues.inputFileTypeKMode) && actionValues.processingMode == ProcessingMode.KMODE) {
            return GPackerConstants.FILE_NAME_PATTERN_CERT_ZIP_AES.replace("<Zeitstempel>", execTimeStamp.format(this.dateFormatTimestampTxEncrptionFileName));
        }
        if (actionValues.processingMode == ProcessingMode.KMODE) {
            return GPackerConstants.FILE_NAME_PATTERN_KMODE_ZIP_AES.replace("<Zeitstempel>", execTimeStamp.format(this.dateFormatTimestampTxEncrptionFileName));
        }
        if (Profile.P_DATENFLUSSPROTOKOLL_STRUKTURABFRAGEN.equals(actionValues.profile)) {
            return GPackerConstants.FILE_NAME_PATTERN_PMODE_NO_REG_NO_ZIP_AES.replace("<Zeitstempel>", execTimeStamp.format(this.dateFormatTimestampTxEncrptionFileName));
        }
        return GPackerConstants.FILE_NAME_PATTERN_ZIP_AES.replace("<Zeitstempel>", execTimeStamp.format(this.dateFormatTimestampTxEncrptionFileName)).replace("<Registriernummer>", regNumber);
    }

    private void openReferringDirectoryInExplorer(File fileOrDirectory) {
        File existingFileOrDirectory;
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException("Programmierfehler: Statebinding nicht korrekt.");
        }
        if (!fileOrDirectory.exists()) {
            this.consolePrinter.println("Datei oder Verzeichnis existiert nicht mehr. \u00d6ffne \u00fcbergeordnetes Verzeichnis...", MessageMode.WARNING);
        }
        File directory = (existingFileOrDirectory = FileUtils.getExistingInHierarchy(fileOrDirectory)).isFile() ? existingFileOrDirectory.getParentFile() : existingFileOrDirectory;
        try {
            Desktop.getDesktop().open(directory);
        }
        catch (IOException e) {
            this.consolePrinter.println("Datei oder Verzeichnis lie\u00df sich nicht \u00f6ffnen: " + directory.getName() + ".", MessageMode.WARNING);
        }
    }

    private List<Path> getAllFileInFolderAsPaths(Path folderPath) throws IOException {
        List<Path> filesInTempFolder;
        try (Stream<Path> walk = Files.walk(folderPath, new FileVisitOption[0]);){
            filesInTempFolder = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        return filesInTempFolder;
    }

    private final class TemporaryFileWastebin {
        private final Collection<Path> temporaryFolders = new ArrayList<Path>(1);
        private final Collection<File> temporaryFiles = new ArrayList<File>(1);

        private TemporaryFileWastebin() {
        }

        public void addTempFolder(Path tempUnzippedFolderPath) {
            this.temporaryFolders.add(tempUnzippedFolderPath);
        }

        public void addTempFiles(Collection<File> tempFiles) {
            this.temporaryFiles.addAll(tempFiles);
        }

        public void emtpy() {
            try {
                for (File temporaryFile : this.temporaryFiles) {
                    Files.deleteIfExists(temporaryFile.toPath());
                }
                for (Path temporaryFolder : this.temporaryFolders) {
                    List<Path> filesInTempFolder = GPackerController.this.getAllFileInFolderAsPaths(temporaryFolder);
                    for (Path path : filesInTempFolder) {
                        Files.deleteIfExists(path);
                    }
                }
            }
            catch (IOException e) {
                GPackerController.this.consolePrinter.println("Tempor\u00e4re Arbeitsdateien konnten nicht gel\u00f6scht werden: " + e.getMessage(), MessageMode.WARNING);
            }
        }
    }
}

