/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.iqtig.packer.gui.Constants;
import org.iqtig.packer.gui.GPackerController;
import org.iqtig.packer.gui.comp.Controller;

public class GPackerMain {
    private final Controller controllerReference;
    private final JFrame frameReference;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Font font = GPackerMain.loadFontRegular();
            Font derivedFont = font.deriveFont(0, 12.0f);
            GPackerMain.setFont(new FontUIResource(derivedFont));
        }
        catch (Exception exception) {
            // empty catch block
        }
        new GPackerMain();
    }

    public GPackerMain() {
        GPackerController gPackerController = new GPackerController(i -> this.shutDown());
        JPanel mainPanel = gPackerController.getView().getPane();
        URL image = this.getClass().getClassLoader().getResource("logo/IQTIG_Logo_Favicon.png");
        JFrame frame = new JFrame(Constants.getString("project.name") + " v" + Constants.getString("project.version") + "          " + Constants.getString("copyright"));
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage(image));
        frame.setLayout(new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1));
        frame.add((Component)mainPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        frame.pack();
        this.controllerReference = gPackerController;
        this.frameReference = frame;
    }

    public JFrame getFrameReference() {
        return this.frameReference;
    }

    private static void setFont(FontUIResource font) {
        UIManager.put("Button.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("OptionPane.messageFont", font);
        UIManager.put("OptionPane.buttonFont", font);
        UIManager.put("Panel.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("Tree.font", font);
    }

    private static Font loadFontRegular() throws IOException, FontFormatException {
        InputStream inputStream = GPackerMain.class.getResourceAsStream("/fonts/Barlow-Regular.ttf");
        return Font.createFont(0, inputStream);
    }

    private void shutDown() {
        this.controllerReference.shutdown();
        this.frameReference.dispose();
        System.exit(0);
    }
}

