/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.constants;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.Labeled;

public enum KeyfileType implements Labeled
{
    KEYFILE(EnumSet.of(Action.DECRYPT, Action.ENCRYPT), "Schl\u00fcsseldatei"),
    KEYSTORE(EnumSet.of(Action.DECRYPT), "Schl\u00fcsselcontainer (PKCS12)");

    private final Set<Action> actions;
    private final String label;

    private KeyfileType(Set<Action> actions, String label) {
        this.actions = actions;
        this.label = label;
    }

    public static List<KeyfileType> valuesByAction(Action action) {
        if (action == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(KeyfileType.values()).filter(i -> i.actions.contains(action)).collect(Collectors.toList());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public static KeyfileType getKeyfileTypeWithLongestLabel() {
        KeyfileType result = null;
        for (KeyfileType value : KeyfileType.values()) {
            if (result != null && value.getLabel().length() <= result.getLabel().length()) continue;
            result = value;
        }
        return result;
    }
}

