/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.job;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.function.Consumer;
import org.iqtig.packer.gui.GPackerRtWrapper;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.Tag;
import org.iqtig.packer.gui.job.CryptoJob;
import org.iqtig.xpacker.Api;

public class XPackerCryptoJob
implements CryptoJob {
    private final File keyFile;
    private final Key key;
    private final String keyId;
    private final Tag tag;
    private final Action action;
    private final Path targetFilePath;
    private final Consumer<Integer> progressConsumer;
    private final Consumer<String> msgConsumer;

    public XPackerCryptoJob(File keyFile, Key key, String keyId, Tag tag, Action action, Consumer<Integer> progressConsumer, Consumer<String> msgConsumer) {
        this(keyFile, key, keyId, tag, action, progressConsumer, msgConsumer, null);
    }

    public XPackerCryptoJob(File keyFile, Key key, String keyId, Tag tag, Action action, Consumer<Integer> progressConsumer, Consumer<String> msgConsumer, Path targetFilePath) {
        this.keyFile = keyFile;
        this.key = key;
        this.keyId = keyId;
        this.tag = tag;
        this.action = action;
        this.progressConsumer = progressConsumer;
        this.msgConsumer = msgConsumer;
        this.targetFilePath = targetFilePath;
    }

    @Override
    public File apply(File file) {
        File tempResultFile;
        long startTimeMillis = System.currentTimeMillis();
        this.msgConsumer.accept(String.format("[BGN] %s: %s", this.action.label, this.tag.tagValue));
        try {
            tempResultFile = File.createTempFile("iqtig", "xpacker");
            if (Action.ENCRYPT == this.action) {
                PublicKey publicKey = (PublicKey)this.key;
                Api.encrypt(file, tempResultFile, publicKey, this.keyId, Arrays.asList(this.tag.tagValue));
            } else if (Action.DECRYPT == this.action) {
                PrivateKey privateKey = (PrivateKey)this.key;
                Api.decrypt(file, tempResultFile, privateKey, Arrays.asList(this.tag.tagValue));
            } else {
                throw new IllegalArgumentException("Programmierfehler");
            }
            if (this.targetFilePath != null) {
                Files.copy(tempResultFile.toPath(), this.targetFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            throw new GPackerRtWrapper(e);
        }
        this.msgConsumer.accept(String.format("[END] %s: %s (Dauer=%s sec)", this.action.label, this.tag.tagValue, this.getDuration(startTimeMillis)));
        try {
            if (this.targetFilePath != null) {
                Files.copy(tempResultFile.toPath(), this.targetFilePath, StandardCopyOption.REPLACE_EXISTING);
                this.msgConsumer.accept("Ausgabedatei erzeugt: " + this.targetFilePath.getFileName().toString());
            }
        }
        catch (IOException e) {
            throw new GPackerRtWrapper(e);
        }
        this.progressConsumer.accept(this.getWeight());
        return tempResultFile;
    }

    @Override
    public int getWeight() {
        return this.calculateWeight(this.tag, this.targetFilePath);
    }
}

