/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.keymanagement;

import java.io.File;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.iqtig.packer.gui.constants.KeyfileType;
import org.iqtig.packer.gui.utils.HexUtil;
import org.iqtig.packer.shared.keyio.output.KeyloadOutput;

public abstract class KeyContainer {
    Key key;
    File keyfile;
    String keystorePassword;
    String keyentryAlias;
    String keyentryPassword;
    String keyName;
    KeyfileType keyFileType;
    String keyHash;

    public abstract KeyloadOutput loadKey();

    public abstract Key getKey();

    public String getName() {
        return this.keyName;
    }

    public File getKeyfile() {
        return this.keyfile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeyentryAlias() {
        return this.keyentryAlias;
    }

    public String getKeyentryPassword() {
        return this.keyentryPassword;
    }

    public KeyfileType getKeyFileType() {
        return this.keyFileType;
    }

    public String getKeyId() {
        if (this.keyentryAlias != null) {
            return this.keyentryAlias;
        }
        if (this.keyfile != null) {
            return this.keyfile.getName();
        }
        return null;
    }

    public String getHash() {
        return this.keyHash;
    }

    void init() {
        this.calcHash();
    }

    void calcHash() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(this.key.getEncoded());
            this.keyHash = HexUtil.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

