/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.keymanagement.keystore.impl;

import java.io.File;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.crypto.AEADBadTagException;
import javax.crypto.SecretKey;
import org.iqtig.packer.gui.constants.KeyfileType;
import org.iqtig.packer.gui.constants.KeystoreState;
import org.iqtig.packer.gui.keymanagement.KeyContainer;
import org.iqtig.packer.gui.keymanagement.KeyList;
import org.iqtig.packer.gui.keymanagement.PrivateKeyContainer;
import org.iqtig.packer.gui.keymanagement.keystore.KeystoreInitData;
import org.iqtig.packer.gui.keymanagement.keystore.PrivateKeystore;
import org.iqtig.packer.gui.keymanagement.keystore.impl.PrivateKeystoreException;
import org.iqtig.packer.gui.keymanagement.keystore.impl.PrivateKeystoreImplHelper;
import org.iqtig.packer.gui.keymanagement.keystore.output.DefaultResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.InitResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeystoreOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.PersistentUniInitResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.UnlockOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.UnlockResult;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;

public class PrivateKeystoreImpl
implements PrivateKeystore {
    String password;
    Preferences nodeForPrivateKeys;
    Preferences nodeForMasterKey;
    Preferences nodeForPrivateKeyEntries;
    private SecretKey secretKey;
    private boolean locked;
    private boolean active = true;

    @Override
    public KeystoreOutput storeKeyContainer(KeyContainer keyContainer) {
        KeystoreOutput result = new KeystoreOutput();
        try {
            String keyName = keyContainer.getName();
            if (this.getKeynames().contains(keyName)) {
                result.setResult(DefaultResult.FALSE);
                return result;
            }
            Preferences keyNode = this.nodeForPrivateKeyEntries.node(keyName);
            keyNode.putByteArray("keyBytes", PrivateKeystoreImplHelper.encodeAndEncryptPrivateKey(keyContainer, this.secretKey));
            if (keyContainer.getKeyfile() != null) {
                keyNode.put("keyfilePath", keyContainer.getKeyfile().getPath());
            }
            if (keyContainer.getKeyentryAlias() != null) {
                keyNode.put("keyAlias", keyContainer.getKeyentryAlias());
            }
            if (keyContainer.getKeyFileType() != null) {
                keyNode.put("keyfileType", keyContainer.getKeyFileType().toString());
            }
            result.setResult(DefaultResult.TRUE);
        }
        catch (Exception e) {
            result.setException(e);
            result.setResult(DefaultResult.ERROR);
        }
        return result;
    }

    @Override
    public KeystoreOutput deleteKeyContainer(KeyContainer keyContainer) {
        return this.deleteKeyContainer(keyContainer.getName());
    }

    @Override
    public KeystoreOutput deleteKeyContainer(String name) {
        KeystoreOutput result = new KeystoreOutput();
        try {
            this.nodeForPrivateKeyEntries.node(name).removeNode();
            result.setResult(DefaultResult.TRUE);
        }
        catch (Exception e) {
            result.setResult(DefaultResult.ERROR);
            result.setException(e);
        }
        return result;
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    @Override
    public KeylistOutput loadKeyContainer() {
        KeylistOutput result = new KeylistOutput();
        KeyList<PrivateKeyContainer> resultList = new KeyList<PrivateKeyContainer>();
        result.setKeyList(resultList);
        try {
            List<String> keyNames = this.getKeynames();
            for (String keyName : keyNames) {
                Preferences keyNode = this.nodeForPrivateKeyEntries.node(keyName);
                String keyFilePath = keyNode.get("keyfilePath", null);
                String keyAlias = keyNode.get("keyAlias", null);
                byte[] keyBytes = keyNode.getByteArray("keyBytes", null);
                PrivateKey privateKey = PrivateKeystoreImplHelper.decryptAndDecodePrivateKey(keyBytes, this.secretKey);
                File keyFile = keyFilePath != null ? new File(keyFilePath) : null;
                String fileType = keyNode.get("keyfileType", null);
                KeyfileType keyfileType = null;
                if (fileType != null) {
                    keyfileType = Enum.valueOf(KeyfileType.class, fileType);
                }
                if (privateKey != null) {
                    PrivateKeyContainer keyContainer = new PrivateKeyContainer.PrivateKeyContainerBuilder().privateKey(privateKey).keyfile(keyFile).keyentryAlias(keyAlias).keyName(keyName).keyfileType(keyfileType).build();
                    resultList.addKey(keyContainer);
                    continue;
                }
                keyNode.removeNode();
            }
            result.setResult(KeylistResult.SUCCESS);
        }
        catch (Exception e) {
            result.setResult(KeylistResult.ERROR);
            result.setThrowable(e);
        }
        return result;
    }

    @Override
    public PersistentUniInitResult initPersistenceUnit(KeystoreInitData initData) {
        PersistentUniInitResult result = new PersistentUniInitResult();
        Preferences prefs = initData.getRootNode();
        if (prefs == null) {
            result.setResult(InitResult.PREF_ERROR);
            this.active = false;
            return result;
        }
        try {
            this.nodeForPrivateKeys = initData.getRootNode().node(initData.getSubnodeName());
        }
        catch (Exception e) {
            result.setFatalException(e);
            result.setResult(InitResult.ERROR);
            this.active = false;
            return result;
        }
        boolean consistent = false;
        boolean empty = true;
        try {
            consistent = this.privateKeystoreIsInConsistentState();
            empty = this.isEmpty();
        }
        catch (Exception e) {
            result.setNonFatalException(PrivateKeystoreImplHelper.extractException(e));
        }
        try {
            if (!consistent || empty) {
                this.resetPrivateKeyStore();
                this.locked = false;
            } else {
                this.locked = true;
                this.createBaseNodes();
            }
        }
        catch (Exception e) {
            result.setFatalException(PrivateKeystoreImplHelper.extractException(e));
            result.setResult(InitResult.ERROR);
            this.active = false;
            return result;
        }
        result.setResult(InitResult.SUCCESS);
        return result;
    }

    @Override
    public boolean clearPersistenceUnit() {
        try {
            this.nodeForPrivateKeys.removeNode();
            return true;
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    @Override
    public UnlockOutput unlockKeystore(String password) {
        try {
            this.secretKey = PrivateKeystoreImplHelper.decryptSecretKey(this.nodeForMasterKey.getByteArray("masterKeyBytes", null), password);
            this.password = password;
            this.locked = false;
        }
        catch (RuntimeException e) {
            return new UnlockOutput(this.extractUnlockResult(e), e);
        }
        catch (Exception e) {
            return new UnlockOutput(UnlockResult.ERROR, e);
        }
        return new UnlockOutput(UnlockResult.OK, null);
    }

    @Override
    public KeystoreOutput lockKeystore() {
        KeystoreOutput result = new KeystoreOutput();
        if (!this.isPasswordResettet()) {
            try {
                this.nodeForMasterKey.node("passwordsetFlag");
            }
            catch (Exception e) {
                result.setException(e);
                result.setResult(DefaultResult.ERROR);
                return result;
            }
            this.secretKey = null;
            this.password = null;
            this.locked = true;
            result.setResult(DefaultResult.TRUE);
        } else {
            result.setResult(DefaultResult.FALSE);
        }
        return result;
    }

    @Override
    public KeystoreOutput lockKeystore(String password) {
        KeystoreOutput result = new KeystoreOutput();
        try {
            this.nodeForMasterKey.putByteArray("masterKeyBytes", PrivateKeystoreImplHelper.encryptSecretKey(this.secretKey, password));
        }
        catch (Exception e) {
            result.setResult(DefaultResult.ERROR);
            result.setException(e);
            return result;
        }
        this.password = password;
        result = this.lockKeystore();
        return result;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public KeystoreOutput resetPassword() {
        KeystoreOutput result = new KeystoreOutput();
        try {
            this.nodeForMasterKey.node("passwordsetFlag").removeNode();
            this.password = null;
            result.setResult(DefaultResult.TRUE);
        }
        catch (Exception e) {
            result.setResult(DefaultResult.ERROR);
            result.setException(e);
        }
        return result;
    }

    @Override
    public boolean isPasswordResettet() {
        return !this.locked && this.password == null;
    }

    @Override
    public KeystoreState getState() {
        if (!this.active) {
            return KeystoreState.INACTIVE;
        }
        if (!this.locked && this.password == null) {
            return KeystoreState.UNLOCKED_PASSWORD_UNSET;
        }
        if (!this.locked && this.password != null) {
            return KeystoreState.UNLOCKED_PASSWORD_SET;
        }
        return KeystoreState.LOCKED;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private boolean privateKeystoreIsInConsistentState() {
        try {
            boolean privateKeyEntryCategoryExists = this.nodeForPrivateKeys.nodeExists("privateKeyEntries");
            boolean masterKeyExists = this.nodeForPrivateKeys.nodeExists("masterKey") && this.nodeForPrivateKeys.node("masterKey").getByteArray("masterKeyBytes", null) != null;
            boolean passwordSetFlagExists = this.nodeForPrivateKeys.nodeExists("masterKey") && this.nodeForPrivateKeys.node("masterKey").nodeExists("passwordsetFlag");
            return (!privateKeyEntryCategoryExists || masterKeyExists) && passwordSetFlagExists;
        }
        catch (BackingStoreException e) {
            throw new PrivateKeystoreException(e);
        }
    }

    @Override
    public KeystoreOutput resetPrivateKeyStore() {
        KeystoreOutput privKeystoreOutput = new KeystoreOutput();
        try {
            this.nodeForPrivateKeys.node("masterKey").removeNode();
            this.nodeForPrivateKeys.node("privateKeyEntries").removeNode();
            this.createBaseNodes();
            CryptographySupportShared cryptoSupport = new CryptographySupportShared();
            this.secretKey = cryptoSupport.createRandomAESSessionKey256Bit();
            this.password = null;
            privKeystoreOutput.setResult(DefaultResult.TRUE);
        }
        catch (Exception e) {
            privKeystoreOutput.setResult(DefaultResult.ERROR);
            privKeystoreOutput.setException(e);
        }
        return privKeystoreOutput;
    }

    private List<String> getKeynames() {
        try {
            return Arrays.asList(this.nodeForPrivateKeyEntries.childrenNames());
        }
        catch (BackingStoreException e) {
            throw new PrivateKeystoreException(e);
        }
    }

    private boolean isEmpty() {
        try {
            return !this.nodeForPrivateKeys.nodeExists("privateKeyEntries") || this.nodeForPrivateKeys.node("privateKeyEntries").childrenNames().length == 0;
        }
        catch (BackingStoreException e) {
            throw new PrivateKeystoreException(e);
        }
    }

    private void createBaseNodes() {
        this.nodeForMasterKey = this.nodeForPrivateKeys.node("masterKey");
        this.nodeForPrivateKeyEntries = this.nodeForPrivateKeys.node("privateKeyEntries");
    }

    private UnlockResult extractUnlockResult(RuntimeException e) {
        Throwable cause2;
        Throwable cause1 = e.getCause();
        if (cause1 != null && cause1 instanceof IOException && (cause2 = cause1.getCause()) != null && cause2 instanceof AEADBadTagException) {
            return UnlockResult.INVALID_PASSWORD;
        }
        return UnlockResult.ERROR;
    }
}

