/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.keymanagement.keystore.impl;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.SecretKey;
import org.iqtig.packer.gui.keymanagement.KeyContainer;
import org.iqtig.packer.gui.keymanagement.keystore.impl.PrivateKeystoreException;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;

public class PrivateKeystoreImplHelper {
    public static PrivateKey decryptAndDecodePrivateKey(byte[] keyEntryBytes, SecretKey secKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        CryptographySupportShared cryptoSupport = new CryptographySupportShared();
        byte[] keyentryBytesDecrypted = cryptoSupport.decrypt(keyEntryBytes, secKey);
        return PrivateKeystoreImplHelper.decodeKeyBytes(keyentryBytesDecrypted);
    }

    public static byte[] encodeAndEncryptPrivateKey(KeyContainer keyContainer, SecretKey secKey) {
        byte[] encodeKeyBytes = PrivateKeystoreImplHelper.encodeKeyBytes(keyContainer);
        CryptographySupportShared cryptoSupport = new CryptographySupportShared();
        return cryptoSupport.encrypt(encodeKeyBytes, secKey);
    }

    static SecretKey decryptSecretKey(byte[] encryptedKeyBytes, String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        CryptographySupportShared cryptoSupport = new CryptographySupportShared();
        byte[] secretKeyBytesDecrypted = cryptoSupport.decryptWithPassword(encryptedKeyBytes, password);
        return cryptoSupport.getKeyFromBytesForAES(secretKeyBytesDecrypted);
    }

    static byte[] encryptSecretKey(SecretKey secretKey, String password) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        CryptographySupportShared cryptoSupport = new CryptographySupportShared();
        return cryptoSupport.encryptWithPassword(secretKey.getEncoded(), password);
    }

    private static byte[] encodeKeyBytes(KeyContainer keyContainer) {
        PrivateKey privateKey = (PrivateKey)keyContainer.getKey();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return keySpec.getEncoded();
    }

    private static PrivateKey decodeKeyBytes(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        return keyFactory.generatePrivate(keySpec);
    }

    static Throwable extractException(Exception exception) {
        if (exception instanceof PrivateKeystoreException) {
            return exception.getCause();
        }
        return exception;
    }
}

