/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.swing;

import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import org.iqtig.packer.gui.comp.ObservableModel;

public class BiDirectionalEnumComboboxBinder<T> {
    private final ObservableModel model;
    private final JComboBox<T> component;
    private final ItemListener widgetListener;
    private final PropertyChangeListener modelListener;

    public BiDirectionalEnumComboboxBinder(String modelPropertyName, Consumer<T> modelSetter, ObservableModel model, JComboBox component) {
        this.model = model;
        this.component = component;
        this.widgetListener = e -> {
            this.deactivateModelListener();
            modelSetter.accept(((JComboBox)e.getSource()).getModel().getSelectedItem());
            this.activateModelListener();
        };
        this.modelListener = e -> {
            if (modelPropertyName.equals(e.getPropertyName())) {
                this.deactivateWidgetListener();
                component.setSelectedItem(e.getNewValue());
                this.activateWidgetListener();
            }
        };
        this.activateModelListener();
        this.activateWidgetListener();
    }

    private void deactivateModelListener() {
        this.model.removePropertyChangeListener(this.modelListener);
    }

    private void activateModelListener() {
        this.model.addPropertyChangeListener(this.modelListener);
    }

    private void deactivateWidgetListener() {
        this.component.removeItemListener(this.widgetListener);
    }

    private void activateWidgetListener() {
        this.component.addItemListener(this.widgetListener);
    }
}

