/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.iqtig.tpacker.cli.Configuration;
import org.iqtig.tpacker.cli.impl.ConfigHelper;
import org.iqtig.tpacker.cli.impl.TPackerUtil;
import org.iqtig.tpacker.core.impl.io.FileInputStreamContainer;

public class ToFileWriter {
    private final Configuration config;
    private final List<FileInputStreamContainer> fileContainer;

    public ToFileWriter(Configuration config, List<FileInputStreamContainer> fileContainer) {
        this.config = config;
        this.fileContainer = fileContainer;
    }

    public void writeToFiles() throws IOException {
        for (FileInputStreamContainer fileCont : this.fileContainer) {
            Path pathOutputFile = this.determineOutputPath(fileCont);
            pathOutputFile.toFile().createNewFile();
            OutputStream out = Files.newOutputStream(pathOutputFile, StandardOpenOption.WRITE);
            try {
                TPackerUtil.writeDatas(fileCont, out);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private Path determineOutputPath(FileInputStreamContainer fileContainer) {
        return TPackerUtil.getOutputDir(this.config).resolve(Paths.get(this.getOutputFileName(fileContainer) + new ConfigHelper(this.config).generateFileSufix(), new String[0]));
    }

    private String getOutputFileName(FileInputStreamContainer fileInputStreamContainer) {
        File outputFile = new File(this.config.getOut());
        if (!(!this.config.isZip() && this.config.getInFiles().size() != 1 || outputFile.isDirectory() || this.config.getOut() == null || this.config.getOut().isBlank())) {
            return Paths.get(this.config.getOut(), new String[0]).getFileName().toString();
        }
        return Paths.get(fileInputStreamContainer.getName(), new String[0]).getFileName().toString();
    }
}

