/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl.sax;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.iqtig.xpacker.impl.sax.SaxHandler;
import org.xml.sax.SAXException;

public class CompressionSaxHandler
extends SaxHandler {
    private static final String VERSION_COMMENT = "<!-- Komprimiert mit XPacker >= v0.4 -->";
    private static final String COMMENT_REGEX = "<!--[\\s\\S]*?-->";
    private final boolean compress;

    public CompressionSaxHandler(boolean compress) {
        this.compress = compress;
    }

    public static void compress(File inputFile, File outputFile, String[] elementsToCompress) throws SAXException, IOException {
        new CompressionSaxHandler(true).parse(inputFile, outputFile, elementsToCompress);
    }

    public static void decompress(File inputFile, File outputFile, String[] elementsToCompress) throws SAXException, IOException {
        new CompressionSaxHandler(false).parse(inputFile, outputFile, elementsToCompress);
    }

    public static void compress(File inputFile, File outputFile) throws SAXException, IOException {
        CompressionSaxHandler.compress(inputFile, outputFile, new String[]{"patient", "qs_data"});
    }

    public static void decompress(File inputFile, File outputFile) throws SAXException, IOException {
        CompressionSaxHandler.decompress(inputFile, outputFile, new String[]{"patient", "qs_data"});
    }

    private static byte[] compressString(String s) {
        byte[] result = null;
        try {
            byte[] bytesUTF8 = s.getBytes(StandardCharsets.UTF_8);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream zipOut = new GZIPOutputStream(out);
            zipOut.write(bytesUTF8);
            zipOut.close();
            result = out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String decompressByteArray(byte[] compressedBytes) throws IOException {
        int bytesRead;
        String result = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream zipIn = new GZIPInputStream(new ByteArrayInputStream(compressedBytes));
        byte[] buffer = new byte[1024];
        while ((bytesRead = zipIn.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        result = out.toString(StandardCharsets.UTF_8);
        return result;
    }

    private String compressDocument(String doc) throws IOException {
        if (doc.matches("^<[^>]+\\/>$")) {
            return doc;
        }
        String startTag = doc.substring(0, doc.indexOf(62) + 1);
        Object content = doc.substring(doc.indexOf(62) + 1, doc.lastIndexOf(60));
        String endTag = doc.substring(doc.lastIndexOf(60));
        if (this.compress) {
            byte[] contentByteArray = CompressionSaxHandler.compressString((String)content);
            content = VERSION_COMMENT + Base64.encodeBase64String(contentByteArray);
        } else if (((String)(content = ((String)content).replaceAll(COMMENT_REGEX, "").trim())).indexOf(60) == -1) {
            byte[] contentByteArray = Base64.decodeBase64((String)content);
            content = CompressionSaxHandler.decompressByteArray(contentByteArray);
        } else {
            return doc;
        }
        return startTag + (String)content + endTag;
    }

    @Override
    public String processDocument(String docString, String elementName) throws IOException {
        docString = this.compressDocument(docString);
        return docString;
    }
}

