/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.shared.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.iqtig.packer.shared.crypto.AESBitSize;
import org.iqtig.packer.shared.crypto.CryptoConstant;
import org.iqtig.packer.shared.error.crypto.CryptoError;
import org.iqtig.packer.shared.error.crypto.CryptoErrorId;
import org.iqtig.packer.shared.error.crypto.CryptoException;

public class CryptographySupportShared {
    static final int SALT_LENGTH = 16;
    private static final String AES_GCM_OPERATION_MODE = "AES/GCM/NoPadding";
    private static final int ITERATION_COUNT = 600000;
    private static final int KEY_LENGTH = 256;
    public static final String FILE_TYPE_IDENTIFIER_OLD = "RPACKERv1";
    public static final String FILE_TYPE_IDENTIFIER_NEW = "KMODEv001";
    public static final int FILE_TYPE_IDENTIFIER_LENGTH = 9;
    public static final String FILE_TYPE_IDENTIFIER_CHARSET = "UTF-8";
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String CIPHER_TRANSFORMATION = "RSA/ECB/OAEPwithSHA1andMGF1Padding";

    public SecretKey createRandomAESSessionKey() throws CryptoException {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(CryptoConstant.AES.getValue());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, CryptoConstant.AES.getValue(), e.getMessage()));
        }
        try {
            keyGenerator.init(AESBitSize.AES_128.getBitsize(), SecureRandom.getInstance("SHA1PRNG", "SUN"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, "SHA1PRNG", e.getMessage()));
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_PROVIDER_ERROR, "SUN", e.getMessage()));
        }
        return keyGenerator.generateKey();
    }

    public SecretKey createRandomAESSessionKey256Bit() throws CryptoException {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(CryptoConstant.AES.getValue());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, CryptoConstant.AES.getValue(), e.getMessage()));
        }
        try {
            keyGenerator.init(AESBitSize.AES_256.getBitsize(), SecureRandom.getInstance("SHA1PRNG", "SUN"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, "SHA1PRNG", e.getMessage()));
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_PROVIDER_ERROR, "SUN", e.getMessage()));
        }
        return keyGenerator.generateKey();
    }

    public SecretKey getKeyFromBytesForAES(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, 0, keyBytes.length, CryptoConstant.AES.getValue());
    }

    public PrivateKey readPrivateKeyFromPem(InputStream inputStream) throws CryptoException {
        try {
            int amountOfBytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((amountOfBytesRead = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, amountOfBytesRead);
            }
            String key = baos.toString(StandardCharsets.UTF_8);
            String privateKeyPEM = key.replace("-----BEGIN PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "").replace("\r", "").replace("\n", "").replace("-----END PRIVATE KEY-----", "");
            byte[] encoded = Base64.getDecoder().decode(privateKeyPEM);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (IOException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.IO_ERROR, new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, "RSA", e.getMessage()));
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.READ_PRIVATE_KEY_ERROR, new String[0]));
        }
    }

    public PrivateKey readPrivateKeyFromKeyStore(InputStream keyStoreStream, String keystorePassword, String keyAlias, String keyentryPassword) throws CryptoException {
        char[] keystorePw = keystorePassword == null ? null : keystorePassword.toCharArray();
        char[] keyentryPw = keyentryPassword == null ? null : keyentryPassword.toCharArray();
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(keyStoreStream, keystorePw);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_TYPE_NOT_SUPPORTED, KEYSTORE_TYPE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_ALGORITHM_NOT_SUPPORTED, new String[0]));
        }
        catch (CertificateException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.CERTIFICATE_OF_KEYSTORE_COULD_NOT_BE_LOADED, new String[0]));
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException) {
                throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_PASSWORD_WRONG, new String[0]));
            }
            throw new CryptoException(new CryptoError(CryptoErrorId.IO_READ_KEYSTORE, new String[0]));
        }
        try {
            return (PrivateKey)keyStore.getKey(keyAlias, keyentryPw);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_NOT_LOADED, new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_KEY_ALGORITHM_NOT_FOUND, keyAlias));
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_KEY_PASSWORD_WRONG, keyAlias));
        }
    }

    public PublicKey readPublicKeyFromKeyStore(InputStream keyStoreStream, String keystorePassword, String keyAlias) throws CryptoException {
        char[] keystorePw = keystorePassword == null ? null : keystorePassword.toCharArray();
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(keyStoreStream, keystorePw);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_TYPE_NOT_SUPPORTED, KEYSTORE_TYPE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_ALGORITHM_NOT_SUPPORTED, new String[0]));
        }
        catch (CertificateException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.CERTIFICATE_OF_KEYSTORE_COULD_NOT_BE_LOADED, new String[0]));
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException) {
                throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_PASSWORD_WRONG, new String[0]));
            }
            throw new CryptoException(new CryptoError(CryptoErrorId.IO_READ_KEYSTORE, new String[0]));
        }
        try {
            Certificate certificate = keyStore.getCertificate(keyAlias);
            PublicKey publicKey = certificate != null ? certificate.getPublicKey() : null;
            return publicKey;
        }
        catch (KeyStoreException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.KEYSTORE_NOT_LOADED, new String[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicKey readPublicKeyFromPem(InputStream inputStream) throws CryptoException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            inputStream.transferTo(baos);
            String key = baos.toString(StandardCharsets.UTF_8);
            if (key.contains("-----BEGIN CERTIFICATE-----")) {
                PublicKey publicKey = this.readX509Certificate(new ByteArrayInputStream(baos.toByteArray())).getPublicKey();
                return publicKey;
            }
            String publicKeyPEM = key.replace("-----BEGIN PUBLIC KEY-----", "").replaceAll(System.lineSeparator(), "").replace("\r", "").replace("\n", "").replace("-----END PUBLIC KEY-----", "");
            byte[] encoded = Base64.getDecoder().decode(publicKeyPEM);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(encoded);
            PublicKey publicKey = keyFactory.generatePublic(keySpecX509);
            return publicKey;
        }
        catch (IOException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.IO_ERROR, new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, "RSA", e.getMessage()));
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.READ_PUBLIC_KEY_ERROR, new String[0]));
        }
    }

    public X509Certificate readX509Certificate(InputStream certificateInputStream) throws CryptoException {
        try {
            CertificateFactory instance = CertificateFactory.getInstance("X509");
            return (X509Certificate)instance.generateCertificate(certificateInputStream);
        }
        catch (CertificateException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.CERTIFICATE_ERROR, new String[0]));
        }
    }

    public byte[] wrapSecretKey(SecretKey secretKey, PublicKey publicKey) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(3, publicKey);
            return cipher.wrap(secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, CIPHER_TRANSFORMATION, e.getMessage()));
        }
        catch (InvalidKeyException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.CRYPTO_ERROR, new String[0]));
        }
    }

    public SecretKey unwrapSecretKey(byte[] wrappedSecretKey, PrivateKey privateKey) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(4, privateKey);
            return (SecretKey)cipher.unwrap(wrappedSecretKey, CryptoConstant.AES.getValue(), 3);
        }
        catch (InvalidKeyException | NoSuchPaddingException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.INVALID_PRIVATE_KEY_ERROR, new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, CIPHER_TRANSFORMATION, e.getMessage()));
        }
    }

    public byte[] encryptWithPassword(byte[] payload, String password) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CryptoConstant.PBKDF2_HMAC_SHA256.getValue());
        RandomSalt randomSalt = new RandomSalt();
        randomSalt.calcRandomSalt();
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), randomSalt.getSalt(), 600000, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), CryptoConstant.AES.getValue());
        byte[] encResult = this.encrypt(payload, secretKey);
        return new SaltOperator().addSalt(randomSalt, encResult);
    }

    public byte[] decryptWithPassword(byte[] payload, String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] saltBytes = new SaltOperator().removePayload(payload);
        byte[] encedBytes = new SaltOperator().removeSalt(payload);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(CryptoConstant.PBKDF2_HMAC_SHA256.getValue());
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), saltBytes, 600000, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), CryptoConstant.AES.getValue());
        return this.decrypt(encedBytes, secretKey);
    }

    public byte[] encrypt(byte[] payload, SecretKey secretKey) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            this.encrypt(new ByteArrayInputStream(payload), result, secretKey);
        }
        catch (CryptoException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    public byte[] decrypt(byte[] payload, SecretKey secretKey) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            this.decrypt((InputStream)new ByteArrayInputStream(payload), (OutputStream)result, secretKey);
        }
        catch (CryptoException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    public void encrypt(InputStream inputstream, OutputStream outputStream, SecretKey secretKey) throws CryptoException {
        this.encrypt(inputstream, outputStream, secretKey, key -> new byte[0]);
    }

    public void decrypt(InputStream inputStream, OutputStream outputStream, SecretKey secretKey) throws CryptoException {
        this.decrypt(inputStream, outputStream, (byte[] byteArray) -> secretKey);
    }

    public void encrypt(InputStream inputStream, OutputStream outputStream, SecretKey secretKey, Function<SecretKey, byte[]> secredKeyWrapper) throws CryptoException {
        try {
            IvParameterSpec ivParameterSpec = this.createRandomIV();
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, ivParameterSpec.getIV());
            Cipher cipher = Cipher.getInstance(AES_GCM_OPERATION_MODE);
            cipher.init(1, (Key)secretKey, gcmParameterSpec);
            try (CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);){
                outputStream.write(FILE_TYPE_IDENTIFIER_NEW.getBytes(StandardCharsets.UTF_8));
                byte[] wrappedSecretKey = secredKeyWrapper.apply(secretKey);
                int lengthOfWrappedSecretKey = wrappedSecretKey.length;
                outputStream.write(lengthOfWrappedSecretKey >>> 24 & 0xFF);
                outputStream.write(lengthOfWrappedSecretKey >>> 16 & 0xFF);
                outputStream.write(lengthOfWrappedSecretKey >>> 8 & 0xFF);
                outputStream.write(lengthOfWrappedSecretKey >>> 0 & 0xFF);
                outputStream.write(wrappedSecretKey);
                outputStream.write(ivParameterSpec.getIV());
                this.transferTo(inputStream, cipherOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Unhandled exception occurred.", e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, AES_GCM_OPERATION_MODE, e.getMessage()));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchPaddingException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.CRYPTO_ERROR, new String[0]));
        }
    }

    public void decrypt(InputStream inputStream, OutputStream outputStream, Function<byte[], SecretKey> secretKeyUnwrapper) throws CryptoException {
        byte[] ivBytes = new byte[12];
        try {
            int ch4;
            int ch3;
            int ch2;
            if (!EncryptionType.KMODE.equals((Object)this.checkEncryptionType(inputStream))) {
                throw new CryptoException(new CryptoError(CryptoErrorId.WRONG_FILE_TYPE, new String[0]));
            }
            int ch1 = inputStream.read();
            if ((ch1 | (ch2 = inputStream.read()) | (ch3 = inputStream.read()) | (ch4 = inputStream.read())) < 0) {
                throw new EOFException();
            }
            int lengthOfSecretKeyBytes = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
            byte[] secretKeyBytes = new byte[lengthOfSecretKeyBytes];
            inputStream.read(secretKeyBytes);
            inputStream.read(ivBytes);
            SecretKey secretKey = secretKeyUnwrapper.apply(secretKeyBytes);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, ivBytes);
            Cipher cipher = Cipher.getInstance(AES_GCM_OPERATION_MODE);
            cipher.init(2, (Key)secretKey, gcmParameterSpec);
            try (CipherInputStream cipherInputStream = new CipherInputStream(inputStream, cipher);){
                this.transferTo(cipherInputStream, outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Unhandled exception occurred.", e);
            }
        }
        catch (IOException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.IO_ERROR, new String[0]));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchPaddingException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.CRYPTO_ERROR, new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, AES_GCM_OPERATION_MODE, e.getMessage()));
        }
    }

    public IvParameterSpec createRandomIV() throws CryptoException {
        SecureRandom secureRandom;
        byte[] nonce = new byte[12];
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_SUCH_ALGORITHM_ERROR, "SHA1PRNG", e.getMessage()));
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(new CryptoError(CryptoErrorId.NO_PROVIDER_ERROR, "SUN", e.getMessage()));
        }
        secureRandom.nextBytes(nonce);
        return new IvParameterSpec(nonce);
    }

    public EncryptionType checkEncryptionType(InputStream inputStream) {
        try {
            byte[] magicBytesConstant = FILE_TYPE_IDENTIFIER_NEW.getBytes(FILE_TYPE_IDENTIFIER_CHARSET);
            byte[] magicBytesFile = new byte[magicBytesConstant.length];
            inputStream.read(magicBytesFile);
            String readString = new String(magicBytesFile, FILE_TYPE_IDENTIFIER_CHARSET);
            boolean rpackerMatch = readString.matches("RPACKERv\\d{1}");
            boolean kmodeMatch = readString.matches("KMODEv\\d{3}");
            if (rpackerMatch || kmodeMatch) {
                return EncryptionType.KMODE;
            }
            return EncryptionType.NONKMODE;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Die interne(!) Zeichenkodierung 'UTF-8' f\u00fcr die MagicBytes ist ung\u00fcltig.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Beim Einlesen der Magic-Bytes der zu entschl\u00fcsselnden Datei trat ein IO-Fehler auf.", e);
        }
    }

    private long transferTo(InputStream is, OutputStream out) throws IOException {
        int read;
        int DEFAULT_BUFFER_SIZE = 8192;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = is.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    static class SaltOperator {
        SaltOperator() {
        }

        byte[] addSalt(RandomSalt randomSalt, byte[] payload) {
            byte[] result = null;
            if (payload != null) {
                result = new byte[16 + payload.length];
                System.arraycopy(randomSalt.getSalt(), 0, result, 0, 16);
                System.arraycopy(payload, 0, result, 16, payload.length);
            }
            return result;
        }

        byte[] removeSalt(byte[] srcBytes) {
            byte[] result = null;
            if (srcBytes != null) {
                if (srcBytes.length < 16) {
                    throw new RuntimeException("Die L\u00e4nge des Eingangs-byte-Arrays(" + srcBytes.length + ") ist k\u00fcrzer als die L\u00e4nge des Salts (16).");
                }
                result = new byte[srcBytes.length - 16];
                System.arraycopy(srcBytes, 16, result, 0, srcBytes.length - 16);
            }
            return result;
        }

        byte[] removePayload(byte[] srcBytes) {
            byte[] result = null;
            if (srcBytes != null) {
                if (srcBytes.length < 16) {
                    throw new RuntimeException("Die L\u00e4nge des Eingangs-byte-Arrays(" + srcBytes.length + ") ist k\u00fcrzer als die L\u00e4nge des Salts (16).");
                }
                result = new byte[16];
                System.arraycopy(srcBytes, 0, result, 0, 16);
            }
            return result;
        }
    }

    static class RandomSalt {
        private byte[] salt = null;

        RandomSalt() {
        }

        protected void calcRandomSalt() throws NoSuchAlgorithmException, NoSuchProviderException {
            this.salt = new byte[16];
            SecureRandom rnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
            rnd.nextBytes(this.salt);
        }

        protected byte[] getSalt() {
            if (this.salt != null) {
                byte[] result = new byte[this.salt.length];
                System.arraycopy(this.salt, 0, result, 0, this.salt.length);
                return result;
            }
            return new byte[0];
        }
    }

    public static enum EncryptionType {
        KMODE,
        NONKMODE;

    }
}

