/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.shared.error;

import org.iqtig.packer.shared.error.ValidationErrorException;

public final class Errors {
    private Errors() {
    }

    public static class XMLParserConfigurationException
    extends ValidationErrorException {
        private XMLParserConfigurationException() {
            super(1020061, "Bei der internen XML-Parser-Konfiguration ist ein Fehler aufgetreten!");
        }

        public static XMLParserConfigurationException createInstance() {
            return new XMLParserConfigurationException();
        }
    }

    public static class TagIsNotSpecifiedException
    extends ValidationErrorException {
        private TagIsNotSpecifiedException() {
            super(1020060, "Bei der Schl\u00fcsselpr\u00fcfung muss ein tag angegeben werden!");
        }

        public static TagIsNotSpecifiedException createInstance() {
            return new TagIsNotSpecifiedException();
        }
    }

    public static class PublicKeyFileIsNotSpecifiedException
    extends ValidationErrorException {
        private PublicKeyFileIsNotSpecifiedException() {
            super(1020059, "Bei der Schl\u00fcsselpr\u00fcfung muss ein Public-Key-File angegeben werden!");
        }

        public static PublicKeyFileIsNotSpecifiedException createInstance() {
            return new PublicKeyFileIsNotSpecifiedException();
        }
    }

    public static class InputFileIOException
    extends ValidationErrorException {
        private InputFileIOException() {
            super(1020058, "Beim Lesen des XML-Input-Files ist eine IO-Exception aufgetreten!");
        }

        public static InputFileIOException createInstance() {
            return new InputFileIOException();
        }
    }

    public static class OnlyOneTagAllowed
    extends ValidationErrorException {
        private OnlyOneTagAllowed() {
            super(1020057, "Es ist nur ein tag erlaubt!");
        }

        public static OnlyOneTagAllowed createInstance() {
            return new OnlyOneTagAllowed();
        }
    }

    public static class ExactlyOneTagNeeded
    extends ValidationErrorException {
        private ExactlyOneTagNeeded() {
            super(1020056, "Es muss genau ein tag f\u00fcr die Schl\u00fcsselpr\u00fcfung angegeben werden!");
        }

        public static ExactlyOneTagNeeded createInstance() {
            return new ExactlyOneTagNeeded();
        }
    }

    public static class InputFileIsNotSpecifiedException
    extends ValidationErrorException {
        private InputFileIsNotSpecifiedException() {
            super(1020055, "Bei der Schl\u00fcsselpr\u00fcfung muss ein XML-Input-File angegeben werden!");
        }

        public static InputFileIsNotSpecifiedException createInstance() {
            return new InputFileIsNotSpecifiedException();
        }
    }

    public static class KeyIOException
    extends ValidationErrorException {
        private KeyIOException() {
            super(1020054, "Beim Lesen des Schl\u00fcssels ist eine IO-Exception aufgetreten!");
        }

        public static KeyIOException createInstance() {
            return new KeyIOException();
        }
    }

    public static class ExactlyOneKeyNeeded
    extends ValidationErrorException {
        private ExactlyOneKeyNeeded() {
            super(1020053, "Es wird genau ein \u00f6ffentlicher Schl\u00fcssel ben\u00f6tigt!");
        }

        public static ExactlyOneKeyNeeded createInstance() {
            return new ExactlyOneKeyNeeded();
        }
    }

    public static class InputFileIsDirectory
    extends ValidationErrorException {
        private InputFileIsDirectory() {
            super(1020052, "Eingabedatei ist keine Datei, sondern ein Verzeichnis!");
        }

        public static InputFileIsDirectory createInstance() {
            return new InputFileIsDirectory();
        }
    }

    public static class KeystoreFileNotFound
    extends ValidationErrorException {
        private KeystoreFileNotFound() {
            super(1020051, "Keystore-Datei nicht gefunden!");
        }

        public static KeystoreFileNotFound createInstance() {
            return new KeystoreFileNotFound();
        }
    }

    public static class OutputDirectoryDoesNotExist
    extends ValidationErrorException {
        private OutputDirectoryDoesNotExist() {
            super(1020050, "Das Ausgabeverzeichnis existiert nicht!");
        }

        public static OutputDirectoryDoesNotExist createInstance() {
            return new OutputDirectoryDoesNotExist();
        }
    }

    public static class DataToEncryptAreCorrupt
    extends ValidationErrorException {
        private DataToEncryptAreCorrupt(String tagName) {
            super(1020049, "Entweder der zum Entschl\u00fcsseln verwendete Schl\u00fcssel oder die zu entschl\u00fcsselnden Daten (" + tagName + ") sind fehlerhaft.");
        }

        public static DataToEncryptAreCorrupt createInstance(String tagName) {
            return new DataToEncryptAreCorrupt(tagName);
        }
    }

    public static class DecryptionPasswordCouldBeInvalid
    extends ValidationErrorException {
        private DecryptionPasswordCouldBeInvalid() {
            super(1020048, "Eine unerwartete Ausnahme wurde ausgel\u00f6st. M\u00f6glicherweise wurde ein falsches Passwort zur Entschl\u00fcsselung in der Exportdatei angegeben. Falls Sie mit dieser Information das Problem nicht l\u00f6sen k\u00f6nnen, kontaktieren Sie bitte den Hersteller.");
        }

        public static DecryptionPasswordCouldBeInvalid createInstance() {
            return new DecryptionPasswordCouldBeInvalid();
        }
    }

    public static class DecryptionPasswordIsInvalid
    extends ValidationErrorException {
        private DecryptionPasswordIsInvalid() {
            super(1020046, "Es wurde ein falsches Passwort zur Entschluesselung der Exportdatei angegeben. Gegebenenfalls befinden sich Sonderzeichen im Passwort und die Quelldatei wurde mit einer alten TPacker-Version verschluesselt (Zur Loesung siehe Parameter '-c').");
        }

        public static DecryptionPasswordIsInvalid createInstance() {
            return new DecryptionPasswordIsInvalid();
        }
    }

    public static class TPackerFileValidationFailed
    extends ValidationErrorException {
        private TPackerFileValidationFailed() {
            super(1020044, "Die mit Transportverschl\u00fcsselung zu versehende Datei konnte nicht validiert werden.");
        }

        public static TPackerFileValidationFailed createInstance() {
            return new TPackerFileValidationFailed();
        }
    }

    public static class TPackerFileNotValid
    extends ValidationErrorException {
        private TPackerFileNotValid() {
            super(1020043, "Das Dokument enth\u00e4lt unverschl\u00fcsselte PID-Daten.");
        }

        public static TPackerFileNotValid createInstance() {
            return new TPackerFileNotValid();
        }
    }

    public static class KeyFileNotFound
    extends ValidationErrorException {
        private KeyFileNotFound() {
            super(1020037, "Schl\u00fcsseldatei nicht gefunden!");
        }

        public static KeyFileNotFound createInstance() {
            return new KeyFileNotFound();
        }
    }

    public static class OutputFileCreationFailed
    extends ValidationErrorException {
        private OutputFileCreationFailed() {
            super(1020034, "Ausgabedatei konnte nicht erzeugt werden!");
        }

        public static OutputFileCreationFailed createInstance() {
            return new OutputFileCreationFailed();
        }
    }

    public static class PrivateKeyFileIsErroneous
    extends ValidationErrorException {
        private PrivateKeyFileIsErroneous() {
            super(1020031, "Die private Schl\u00fcsseldatei ist fehlerhaft!");
        }

        public static PrivateKeyFileIsErroneous createInstance() {
            return new PrivateKeyFileIsErroneous();
        }
    }

    public static class PublicKeyFileIsErroneous
    extends ValidationErrorException {
        private PublicKeyFileIsErroneous() {
            super(1020030, "Die \u00f6ffentliche Schl\u00fcsseldatei ist fehlerhaft!");
        }

        public static PublicKeyFileIsErroneous createInstance() {
            return new PublicKeyFileIsErroneous();
        }
    }

    public static class InputFileIsMissing
    extends ValidationErrorException {
        private InputFileIsMissing() {
            super(1020024, "Die Eingabedatei existiert nicht.");
        }

        public static InputFileIsMissing createInstance() {
            return new InputFileIsMissing();
        }
    }

    public static class InputFileIsEmpty
    extends ValidationErrorException {
        private InputFileIsEmpty() {
            super(1020015, "Die Eingabedatei ist leer.");
        }

        public static InputFileIsEmpty createInstance() {
            return new InputFileIsEmpty();
        }
    }

    public static class ZipAndUnzipIsProhibited
    extends ValidationErrorException {
        private ZipAndUnzipIsProhibited() {
            super(1020013, "Das zeitgleiche Ver-/Entpacken ist nicht m\u00f6glich.");
        }

        public static ZipAndUnzipIsProhibited createInstance() {
            return new ZipAndUnzipIsProhibited();
        }
    }

    public static class EncryptionPasswordIsInsufficient
    extends ValidationErrorException {
        private EncryptionPasswordIsInsufficient(String zeichenVorrat, int mindestLaenge) {
            super(1020014, String.format("Die Anforderungen an das Passwort zur Verschluesselung sind nicht erfuellt: Zeichenvorrat=%s Mindestlaenge=%s.", zeichenVorrat, mindestLaenge));
        }

        public static EncryptionPasswordIsInsufficient createInstance(String zeichenVorrat, int mindestLaenge) {
            return new EncryptionPasswordIsInsufficient(zeichenVorrat, mindestLaenge);
        }
    }

    public static class CryptoPasswordIsMissing
    extends ValidationErrorException {
        private CryptoPasswordIsMissing() {
            super(1020012, "F\u00fcr das Ver- oder Entschl\u00fcsseln wird ein Passwort ben\u00f6tigt.");
        }

        public static CryptoPasswordIsMissing createInstance() {
            return new CryptoPasswordIsMissing();
        }
    }

    public static class ChooseCryptionOrZipOption
    extends ValidationErrorException {
        private ChooseCryptionOrZipOption() {
            super(1020011, "Eine Option (Ver-/Entschl\u00fcsselung und/oder Ver-/Entpacken) w\u00e4hlen.");
        }

        public static ChooseCryptionOrZipOption createInstance() {
            return new ChooseCryptionOrZipOption();
        }
    }

    public static class InputFilesAreMissing
    extends ValidationErrorException {
        private InputFilesAreMissing() {
            super(1020010, "Eine oder mehrere Eingabedateien werden ben\u00f6tigt.");
        }

        public static InputFilesAreMissing createInstance() {
            return new InputFilesAreMissing();
        }
    }

    public static class EncryptAndUnzipIsProhibited
    extends ValidationErrorException {
        private EncryptAndUnzipIsProhibited() {
            super(1020009, "Verschl\u00fcsseln und Entpacken nicht m\u00f6glich.");
        }

        public static EncryptAndUnzipIsProhibited createInstance() {
            return new EncryptAndUnzipIsProhibited();
        }
    }

    public static class DecryptAndZipIsProhibited
    extends ValidationErrorException {
        private DecryptAndZipIsProhibited() {
            super(1020008, "Entschl\u00fcsseln und Verpacken nicht m\u00f6glich.");
        }

        public static DecryptAndZipIsProhibited createInstance() {
            return new DecryptAndZipIsProhibited();
        }
    }

    public static class DecryptAndEncrpytIsProhibited
    extends ValidationErrorException {
        private DecryptAndEncrpytIsProhibited() {
            super(1020007, "Das zeitgleiche Ver-/Entschl\u00fcsseln ist nicht m\u00f6glich.");
        }

        public static DecryptAndEncrpytIsProhibited createInstance() {
            return new DecryptAndEncrpytIsProhibited();
        }
    }

    public static class InternalErrorOccured
    extends ValidationErrorException {
        private InternalErrorOccured() {
            super(1020006, "Es ist ein interner Fehler aufgetreten. Der Vorgang wurde abgebrochen.  Bitte wenden Sie sich an Ihren Systembetreuer.");
        }

        public static InternalErrorOccured createInstance() {
            return new InternalErrorOccured();
        }
    }

    public static class OnlyOneKeyAllowed
    extends ValidationErrorException {
        private OnlyOneKeyAllowed() {
            super(1020005, "Es ist nur ein Schl\u00fcssel erlaubt!");
        }

        public static OnlyOneKeyAllowed createInstance() {
            return new OnlyOneKeyAllowed();
        }
    }

    public static class EncryptTagOrDecrpytTagIsMissing
    extends ValidationErrorException {
        private EncryptTagOrDecrpytTagIsMissing() {
            super(1020004, "Beim Ver-/Entschl\u00fcsseln muss ein <tag> angegeben werden (-t)!");
        }

        public static EncryptTagOrDecrpytTagIsMissing createInstance() {
            return new EncryptTagOrDecrpytTagIsMissing();
        }
    }

    public static class KeyTagIsMissing
    extends ValidationErrorException {
        private KeyTagIsMissing(String tag) {
            super(1020003, "F\u00fcr diesen Vorgang wird ein " + tag + " f\u00fcr den chiffrierten Schl\u00fcssel benoetigt!");
        }

        public static KeyTagIsMissing createInstance(String tag) {
            return new KeyTagIsMissing(tag);
        }
    }

    public static class GenKeyAndEncryptAndDecryptAndGetModulusAndCheckKeyParamMissing
    extends ValidationErrorException {
        private GenKeyAndEncryptAndDecryptAndGetModulusAndCheckKeyParamMissing() {
            super(1020002, "Es muss ein Parameter -g (genkey) -e (encrypt) -d (decrypt) -m (getmodulus) -y (checkkey) gew\u00e4hlt werden!");
        }

        public static GenKeyAndEncryptAndDecryptAndGetModulusAndCheckKeyParamMissing createInstance() {
            return new GenKeyAndEncryptAndDecryptAndGetModulusAndCheckKeyParamMissing();
        }
    }

    public static class DecryptionFailed
    extends ValidationErrorException {
        private DecryptionFailed(String tag, String details) {
            super(1003003, "Die Entschluesselung von " + tag + " ist fehlgeschlagen: " + details);
        }

        public static DecryptionFailed createInstance(String tag, String details) {
            return new DecryptionFailed(tag, details);
        }
    }
}

