/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.shared.keyio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;
import org.iqtig.packer.shared.error.crypto.CryptoErrorId;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.iqtig.packer.shared.keyio.KeyLoader;
import org.iqtig.packer.shared.keyio.output.KeyloadOutput;
import org.iqtig.packer.shared.keyio.output.KeyloadResult;

class KeyLoaderImpl
implements KeyLoader {
    KeyLoaderImpl() {
    }

    @Override
    public KeyloadOutput loadPrivateKeyFromKeyFile(Path keyFilePath) {
        KeyloadOutput keyloadOutput;
        block11: {
            InputStream keyFileInputStream = Files.newInputStream(keyFilePath, new OpenOption[0]);
            try {
                PrivateKey key = new CryptographySupportShared().readPrivateKeyFromPem(keyFileInputStream);
                keyloadOutput = new KeyloadOutput(KeyloadResult.OK, key);
                if (keyFileInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (keyFileInputStream != null) {
                        try {
                            keyFileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CryptoException e) {
                    if (e.containsNamedError(CryptoErrorId.READ_PRIVATE_KEY_ERROR)) {
                        return new KeyloadOutput(KeyloadResult.INVALID_KEY, e);
                    }
                    if (e.containsNamedError(CryptoErrorId.IO_ERROR)) {
                        return new KeyloadOutput(KeyloadResult.IO_ERROR, e);
                    }
                    return new KeyloadOutput(KeyloadResult.ERROR, e);
                }
                catch (IOException e1) {
                    return new KeyloadOutput(KeyloadResult.IO_ERROR, e1);
                }
            }
            keyFileInputStream.close();
        }
        return keyloadOutput;
    }

    @Override
    public KeyloadOutput loadPrivateKeyFromKeystore(Path keystorePath, String keystorePassword, String keyEntryAlias, String keyEntryPassword) {
        CryptographySupportShared cryptoSupport = new CryptographySupportShared();
        PrivateKey privateKey = null;
        try (InputStream keystoreFileInputStream = Files.newInputStream(keystorePath, new OpenOption[0]);){
            privateKey = cryptoSupport.readPrivateKeyFromKeyStore(keystoreFileInputStream, keystorePassword, keyEntryAlias, keyEntryPassword);
        }
        catch (CryptoException e) {
            if (e.containsNamedError(CryptoErrorId.KEYSTORE_PASSWORD_WRONG)) {
                return new KeyloadOutput(KeyloadResult.KEYSTORE_PASSWORD_WRONG, e);
            }
            if (e.containsNamedError(CryptoErrorId.KEYSTORE_KEY_PASSWORD_WRONG)) {
                return new KeyloadOutput(KeyloadResult.KEYENTRY_PASSWORD_WRONG, e);
            }
            if (e.containsNamedError(CryptoErrorId.IO_READ_KEYSTORE)) {
                return new KeyloadOutput(KeyloadResult.INVALID_KEYSTORE, e);
            }
            return new KeyloadOutput(KeyloadResult.ERROR, e);
        }
        catch (IOException e) {
            return new KeyloadOutput(KeyloadResult.IO_ERROR, e);
        }
        if (privateKey == null) {
            return new KeyloadOutput(KeyloadResult.KEYENTRY_NOT_FOUND, (Exception)null);
        }
        return new KeyloadOutput(KeyloadResult.OK, privateKey);
    }

    @Override
    public KeyloadOutput loadPublicKeyFromKeyfile(Path keyfilePath) {
        KeyloadOutput keyloadOutput;
        block12: {
            CryptographySupportShared cryptoSupport = new CryptographySupportShared();
            InputStream keyfileInputStream = Files.newInputStream(keyfilePath, new OpenOption[0]);
            try {
                keyloadOutput = new KeyloadOutput(KeyloadResult.OK, cryptoSupport.readPublicKeyFromPem(keyfileInputStream));
                if (keyfileInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (keyfileInputStream != null) {
                        try {
                            keyfileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CryptoException e) {
                    if (e.containsNamedError(CryptoErrorId.IO_ERROR)) {
                        return new KeyloadOutput(KeyloadResult.IO_ERROR, e);
                    }
                    if (e.containsNamedError(CryptoErrorId.READ_PUBLIC_KEY_ERROR)) {
                        return new KeyloadOutput(KeyloadResult.INVALID_KEY, e);
                    }
                    return new KeyloadOutput(KeyloadResult.ERROR, e);
                }
                catch (IOException e1) {
                    return new KeyloadOutput(KeyloadResult.IO_ERROR, e1);
                }
                catch (Exception e) {
                    return new KeyloadOutput(KeyloadResult.ERROR, e);
                }
            }
            keyfileInputStream.close();
        }
        return keyloadOutput;
    }

    @Override
    public KeyloadOutput loadPublicKeyFromKeystore(Path keystorePath, String keystorePassword, String keyEntryAlias) {
        CryptographySupportShared cryptoSupport = new CryptographySupportShared();
        PublicKey publicKey = null;
        try (InputStream keystoreFileInputStream = Files.newInputStream(keystorePath, new OpenOption[0]);){
            publicKey = cryptoSupport.readPublicKeyFromKeyStore(keystoreFileInputStream, keystorePassword, keyEntryAlias);
        }
        catch (IOException e) {
            return new KeyloadOutput(KeyloadResult.IO_ERROR, e);
        }
        catch (CryptoException e) {
            if (e.containsNamedError(CryptoErrorId.KEYSTORE_PASSWORD_WRONG)) {
                return new KeyloadOutput(KeyloadResult.KEYSTORE_PASSWORD_WRONG, e);
            }
            if (e.containsNamedError(CryptoErrorId.IO_READ_KEYSTORE)) {
                return new KeyloadOutput(KeyloadResult.INVALID_KEYSTORE, e);
            }
            return new KeyloadOutput(KeyloadResult.ERROR, e);
        }
        if (publicKey == null) {
            if (keystorePassword != null && !keystorePassword.isBlank()) {
                return new KeyloadOutput(KeyloadResult.KEYENTRY_NOT_FOUND, (Exception)null);
            }
            return new KeyloadOutput(KeyloadResult.ALIAS_OR_EMPTY_KEYSTORE_PW_WRONG, (Exception)null);
        }
        return new KeyloadOutput(KeyloadResult.OK, publicKey);
    }
}

