/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.commands;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.iqtig.tpacker.cli.Configuration;
import org.iqtig.tpacker.cli.commands.AbstractSubCommand;
import org.iqtig.tpacker.cli.impl.ParameterValidator;
import org.iqtig.tpacker.cli.impl.TPacker;
import org.iqtig.tpacker.cli.validation.XmlPreValidator;
import picocli.CommandLine;

public abstract class AbstractFileProcessingSubCommand
extends AbstractSubCommand
implements Callable<Integer> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-f", "--input_files"}, description={"Dateien die verschluesselt bzw. gezippt werden sollen."}, required=true)
    String files;
    @CommandLine.Option(names={"-o", "--output"}, description={"Pfad f\u00fcr den Output."}, required=false)
    Path output;

    protected void throwErrorOnEncryptionAndOccuranceOfVersichterenIdInXml(Configuration config) {
        if (config.isSafe() && (config.isEncypt() || config.isHybridEncrypt()) && config.getInFiles() != null) {
            for (String filePath : config.getInFiles()) {
                XmlPreValidator.throwErrorOnEncryptionAndOccuranceOfVersichterenIdInXml(filePath);
            }
        }
    }

    @Override
    void validateParameters() {
        ParameterValidator parameterValidator = new ParameterValidator(this.config);
        parameterValidator.validateInputFilesDoExist();
        parameterValidator.validateOutputDirIsPresent();
        parameterValidator.validateWhenKeyFileIsPresentItDoesExist();
        parameterValidator.validateWhenKeystoreFileIsPresentItDoesExist();
    }

    @Override
    public Integer call() throws Exception {
        this.config = this.mapOptionArgsToConfig();
        this.validateParameters();
        this.throwErrorOnEncryptionAndOccuranceOfVersichterenIdInXml(this.config);
        new TPacker().running(this.config);
        return 0;
    }

    protected abstract Configuration mapOptionArgsToConfig();
}

