/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.tpacker.cli.Configuration;
import org.iqtig.tpacker.cli.impl.ConfigHelper;
import org.iqtig.tpacker.cli.impl.Constants;
import org.iqtig.tpacker.cli.impl.EncTypePrinter;
import org.iqtig.tpacker.cli.impl.KeyProvider;
import org.iqtig.tpacker.cli.impl.TPackerUtil;
import org.iqtig.tpacker.cli.impl.ToFileWriter;
import org.iqtig.tpacker.core.impl.crypto.Crypt;
import org.iqtig.tpacker.core.impl.crypto.EncryptionTypeChecker;
import org.iqtig.tpacker.core.impl.crypto.HybridDecrypt;
import org.iqtig.tpacker.core.impl.crypto.HybridEncrypt;
import org.iqtig.tpacker.core.impl.io.FileInputStreamContainer;
import org.iqtig.tpacker.core.impl.io.InputIOProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPacker {
    private static final int ZIP_BUFFER_SIZE = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(TPacker.class);
    private static final String ENC_SUFF = ".aes";

    public void running(Configuration configuration) throws IOException {
        try (InputIOProvider input = new InputIOProvider(configuration.getInFiles());){
            if (!configuration.isDetermineEncryptionType()) {
                if (configuration.isEncypt() || configuration.isHybridEncrypt() || configuration.isZip()) {
                    this.zipEncypt(configuration, input);
                } else {
                    this.unzipDecrypt(configuration, input);
                }
            } else {
                EncryptionTypeChecker encTypeChecker = new EncryptionTypeChecker(input);
                new EncTypePrinter(encTypeChecker.checkEncryptionTypes()).printOutEncryptionTypes();
            }
        }
    }

    private void zipEncypt(Configuration config, InputIOProvider input) throws IOException {
        File tempFile = null;
        if (config.isZip()) {
            tempFile = this.zip(input);
            input.reset();
            input.addFileInputStreamContainer(config.getInFiles().get(0), new FileInputStream(tempFile));
        }
        if (config.isEncypt()) {
            new Crypt().encrypt(input.getFileInputStreamContainer(), config.getPassword());
        } else if (config.isHybridEncrypt()) {
            PublicKey publicKey = config.getPublicKey() != null ? config.getPublicKey() : new KeyProvider(config).providePublicKey();
            new HybridEncrypt(publicKey).encrypt(input.getFileInputStreamContainer());
            new ToFileWriter(config, input.getFileInputStreamContainer()).writeToFiles();
        }
        if (!config.isHybridEncrypt()) {
            this.fileInputStreamContainerPath(input.getFileInputStreamContainer(), config);
            this.fileInputStreamContainerOutFile(input);
            if (tempFile != null && !tempFile.delete()) {
                LOGGER.debug("zipEncypt: tempfile konnte nicht gel\u00f6scht werden ");
            }
        }
    }

    private void unzipDecrypt(Configuration config, InputIOProvider input) throws IOException {
        List<FileInputStreamContainer> fileInputStreamContainerTemp = input.getFileInputStreamContainer();
        new ConfigHelper(config).setTimeStamp(true);
        if (config.isDecrypt()) {
            new Crypt().decrypt(fileInputStreamContainerTemp, config.getPassword(), config.getCharacterSetPasswordDecrypt());
        } else if (config.isHybridDecrypt()) {
            PrivateKey privateKey = config.getPrivateKey() != null ? config.getPrivateKey() : new KeyProvider(config).providePrivateKey();
            new HybridDecrypt(privateKey).decrypt(fileInputStreamContainerTemp);
            this.removeAesFromFileName(fileInputStreamContainerTemp);
        }
        if (config.isUnzip()) {
            fileInputStreamContainerTemp = this.unzip(fileInputStreamContainerTemp, config.getOut());
        } else {
            this.fileInputStreamContainerPath(fileInputStreamContainerTemp, config);
            try {
                if (!this.fileInputStreamContainerOutFile(input)) {
                    throw Errors.DecryptionPasswordIsInvalid.createInstance();
                }
            }
            catch (IOException ex) {
                if (ex.getCause() instanceof BadPaddingException) {
                    throw Errors.DecryptionPasswordIsInvalid.createInstance();
                }
                throw ex;
            }
        }
    }

    private void fileInputStreamContainerPath(List<FileInputStreamContainer> fileInputStreamContainer, Configuration config) {
        ConfigHelper configHelper = new ConfigHelper(config);
        for (FileInputStreamContainer inputContainer : fileInputStreamContainer) {
            Object filename = config.getOut();
            File outputFile = new File((String)filename);
            if (fileInputStreamContainer.size() > 1 || ((String)filename).isEmpty() || ((String)filename).endsWith("/") || ((String)filename).endsWith("\\") || outputFile.isDirectory()) {
                if ((fileInputStreamContainer.size() > 1 || outputFile.isDirectory()) && !((String)filename).isEmpty()) {
                    filename = (String)filename + "/";
                }
                filename = (String)filename + configHelper.fileOnly(inputContainer.getName());
            }
            inputContainer.setName((String)filename + new ConfigHelper(config).generateFileSufix());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileInputStreamContainer> unzip(List<FileInputStreamContainer> fileInputStreamContainer, String path) throws IOException {
        Object pathTemp = path;
        if (!(((String)pathTemp).isEmpty() || ((String)pathTemp).endsWith("/") || ((String)pathTemp).endsWith("\\"))) {
            pathTemp = (String)pathTemp + "/";
        }
        if (!Files.exists(Paths.get((String)pathTemp, new String[0]), new LinkOption[0]) || !Files.isDirectory(Paths.get((String)pathTemp, new String[0]), new LinkOption[0])) {
            throw Errors.OutputDirectoryDoesNotExist.createInstance();
        }
        for (FileInputStreamContainer inputContainer : fileInputStreamContainer) {
            ZipInputStream zipInputStream = null;
            boolean written = false;
            try {
                ZipEntry zipEntry;
                zipInputStream = new ZipInputStream(inputContainer.getInputStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) {
                        if (new File((String)pathTemp + zipEntry.getName()).mkdirs()) continue;
                        LOGGER.debug("unzip konnte das Verzeichnis " + zipEntry.getName() + " nicht anlegen.");
                        continue;
                    }
                    written = this.unzipFile((String)pathTemp, zipInputStream, zipEntry);
                }
            }
            finally {
                if (zipInputStream != null) {
                    try {
                        InputStream inputStream = inputContainer.getInputStream();
                        while (inputStream.read() >= 0) {
                            while (inputStream.available() > 0) {
                                inputStream.skip(inputStream.available());
                            }
                        }
                        zipInputStream.close();
                    }
                    catch (IOException e) {
                        if (e.getCause() instanceof BadPaddingException && !written) {
                            throw Errors.DecryptionPasswordIsInvalid.createInstance();
                        }
                        throw Errors.DecryptionPasswordCouldBeInvalid.createInstance();
                    }
                }
            }
            if (written) continue;
            throw Errors.DecryptionPasswordIsInvalid.createInstance();
        }
        return fileInputStreamContainer;
    }

    private boolean unzipFile(String pathTemp, ZipInputStream zipInputStream, ZipEntry zipEntry) {
        boolean written = false;
        try (FileOutputStream outputStream = new FileOutputStream(pathTemp + zipEntry.getName());){
            int size;
            byte[] buffer = new byte[10000];
            while ((size = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, size);
                written = true;
            }
        }
        catch (Exception e) {
            LOGGER.debug("konnte zip OutputStream nicht schlie\u00dfen");
        }
        return written;
    }

    private boolean fileInputStreamContainerOutFile(InputIOProvider input) throws IOException {
        try (InputIOProvider inputIOProvider = input;){
            for (FileInputStreamContainer inputContainer : input.getFileInputStreamContainer()) {
                try (FileOutputStream out = new FileOutputStream(inputContainer.getName());){
                    if (TPackerUtil.writeDatas(inputContainer, out)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private File zip(InputIOProvider input) throws IOException {
        File zipFileTemp = File.createTempFile("zip", ".tmp");
        zipFileTemp.deleteOnExit();
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFileTemp));
             InputIOProvider inputIOProvider = input;){
            zipOut.setMethod(8);
            zipOut.setLevel(9);
            for (FileInputStreamContainer inputContainer : input.getFileInputStreamContainer()) {
                String filename = this.fileOnly(inputContainer.getName());
                ZipEntry entry = new ZipEntry(filename);
                zipOut.putNextEntry(entry);
                if (!TPackerUtil.writeDatas(inputContainer, zipOut)) {
                    throw Errors.InputFileIsEmpty.createInstance();
                }
                zipOut.closeEntry();
            }
        }
        catch (FileNotFoundException e) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(Constants.getArgsError() + "Outputzipfile not found.");
            fileNotFoundException.setStackTrace(e.getStackTrace());
            throw fileNotFoundException;
        }
        return zipFileTemp;
    }

    private String fileOnly(String name) {
        String newname = this.removePath(name, "/");
        newname = this.removePath(newname, "\\");
        return newname;
    }

    private String removePath(String name, String toTest) {
        String newname = name;
        if (name.contains(toTest)) {
            newname = newname.substring(name.lastIndexOf(toTest) + 1);
        }
        return newname;
    }

    private void removeAesFromFileName(List<FileInputStreamContainer> fileContainer) {
        for (FileInputStreamContainer fileCont : fileContainer) {
            String filePathWithoutAesAtTheEnd = fileCont.getName().replaceAll(".aes\\z", "");
            fileCont.setName(filePathWithoutAesAtTheEnd);
        }
    }
}

