/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.validation;

import java.io.File;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.packer.shared.error.ValidationErrorException;
import org.iqtig.tpacker.cli.validation.InsuranceIdFinder;

public final class XmlPreValidator {
    private XmlPreValidator() {
    }

    public static void throwErrorOnEncryptionAndOccuranceOfVersichterenIdInXml(String filePath) {
        try {
            if (XmlPreValidator.lookForInsuranceId(new File(filePath)).booleanValue()) {
                throw Errors.TPackerFileNotValid.createInstance();
            }
        }
        catch (ValidationErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw Errors.TPackerFileValidationFailed.createInstance();
        }
    }

    private static Boolean lookForInsuranceId(File xmlFile) {
        return InsuranceIdFinder.findInsuranceId(xmlFile);
    }
}

