/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.core.impl.crypto;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.tpacker.core.impl.io.FileInputStreamContainer;

public class Crypt {
    private static final String CRYPT_METHOD = "AES";
    private static final String CRYPT_DETAILS = "AES/ECB/PKCS5Padding";
    private static final String ALGORITHM = "MD5";
    private static final Charset DEFAULT_PASSWORD_ENCODING_CHARSET = StandardCharsets.UTF_8;
    private static final String PASSWORD_ENCRYPTION_CHARS = "[a-zA-Z0-9.,:;=+*#_!$%?@(){}|'^~]";
    private static final int PASSWORD_ENCRYPTION_LENGTH = 1;
    private static final Pattern PASSWORD_ENCRYPTION_PATTERN = Pattern.compile(String.format("%s{%s,}", "[a-zA-Z0-9.,:;=+*#_!$%?@(){}|'^~]", 1));

    private Cipher getCipher(String password, int mode, Charset charset) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        MessageDigest messDig = MessageDigest.getInstance(ALGORITHM);
        byte[] keyData = messDig.digest(password.getBytes(charset));
        SecretKeySpec key = new SecretKeySpec(keyData, CRYPT_METHOD);
        Cipher cipher = Cipher.getInstance(CRYPT_DETAILS);
        cipher.init(mode, key);
        return cipher;
    }

    private void crypt(List<FileInputStreamContainer> fileInputStreamContainer, String password, int mode, Charset charset) {
        try {
            Cipher cipher = this.getCipher(password, mode, charset);
            for (FileInputStreamContainer inputContainer : fileInputStreamContainer) {
                CipherInputStream inputStream = new CipherInputStream(inputContainer.getInputStream(), cipher);
                inputContainer.setInputStream(inputStream);
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw Errors.DecryptionPasswordIsInvalid.createInstance();
        }
    }

    public void decrypt(List<FileInputStreamContainer> fileInputStreamContainer, String password, Charset charsetOptional) {
        Charset charset = charsetOptional == null ? DEFAULT_PASSWORD_ENCODING_CHARSET : charsetOptional;
        for (FileInputStreamContainer inputContainer : fileInputStreamContainer) {
            inputContainer.setName(inputContainer.getName().replace(".aes", ""));
        }
        this.crypt(fileInputStreamContainer, password, 2, charset);
    }

    public void encrypt(List<FileInputStreamContainer> fileInputStreamContainer, String password) {
        if (password == null || !PASSWORD_ENCRYPTION_PATTERN.matcher(password).matches()) {
            throw Errors.EncryptionPasswordIsInsufficient.createInstance(PASSWORD_ENCRYPTION_CHARS, 1);
        }
        this.crypt(fileInputStreamContainer, password, 1, DEFAULT_PASSWORD_ENCODING_CHARSET);
    }
}

