/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.iqtig.utils.common_api.errors.ValidationErrorException;

public abstract class Logger {
    protected boolean silent = false;

    public abstract void out(String var1);

    public abstract void err(String var1);

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void outln() {
        this.out("\n");
    }

    public void outln(String out) {
        if (out != null) {
            this.out(out + '\n');
        }
    }

    public void outlnWithTimeStamp(String out) {
        this.outln(Logger.getTimeStamp() + " " + out);
    }

    public void errln(String out) {
        this.err(out + '\n');
    }

    public void printError(ValidationErrorException error) {
        this.outln();
        if (error != null) {
            this.outln("Fehler AQ" + error.getId() + ": " + error.getErrorMessage());
        } else {
            this.outln("Fehler: Unbekannter Fehler");
        }
        this.outln();
    }

    private static String getTimeStamp() {
        return new SimpleDateFormat("[HH:mm:ss]").format(new Date());
    }
}

