/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.sequence;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.iqtig.errors.ErrorsFromDB;
import org.iqtig.pruefprogramm.config.Provider;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.sequence.Sequence;
import org.iqtig.pruefprogramm.status.FileStatus;
import org.iqtig.pruefprogramm.xml.sax.HeaderReader;
import xh.XhCryptor;

public class XslSequence
implements Sequence {
    private static final AbstractMap<String, Templates> templateMap = new HashMap<String, Templates>();
    private static final byte[] password = new byte[]{97, 113, 117, 97, 97, 113, 117, 97, 43, 103, 111, 101, 116, 116, 105, 110, 103, 101, 110};

    public static ByteArrayOutputStream transform(File inputFile, Transformer transformer) throws InternalException {
        StreamSource source = new StreamSource(inputFile);
        return XslSequence.transform(source, transformer);
    }

    public static ByteArrayOutputStream transform(InputStream ins, Transformer transformer) throws InternalException {
        StreamSource source = new StreamSource(ins);
        return XslSequence.transform(source, transformer);
    }

    public static ByteArrayOutputStream transform(StreamSource source, Transformer transformer) throws InternalException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.XsltError.createInstance());
        }
        return outputStream;
    }

    public static void transform(File inputFile, File outputFile, Transformer transformer) throws InternalException {
        Object source = null;
        Object result = null;
        ByteArrayOutputStream bais = XslSequence.transform(inputFile, transformer);
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            bais.writeTo(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setTransformerParameters(Transformer transformer, SystemConfiguration sysConfig) {
        Provider provider = sysConfig.provider;
        transformer.setParameter("c_date", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()));
        transformer.setParameter("import_path", "file:///" + sysConfig.xslFile.getParentFile().getAbsolutePath().replace('\\', '/') + "/import");
        transformer.setParameter("provider_address", provider.address);
        transformer.setParameter("provider_email", provider.email);
        transformer.setParameter("provider_fax", provider.fax);
        transformer.setParameter("provider_function", provider.function);
        transformer.setParameter("provider_name", provider.name);
        transformer.setParameter("provider_phone", provider.phone);
        transformer.setParameter("provider_registration", provider.registration);
    }

    public static Transformer getTransformer(SystemConfiguration sysConfig) throws InternalException {
        Transformer transformer = null;
        try {
            if (templateMap.get(sysConfig.xslFile.getAbsolutePath()) != null) {
                transformer = templateMap.get(sysConfig.xslFile.getAbsolutePath()).newTransformer();
            } else {
                sysConfig.getLogger().outlnWithTimeStamp("XSL-Stylesheet wird verarbeitet...");
                Templates template = null;
                template = sysConfig.xslFile.getName().toLowerCase().endsWith(".aqxsl") ? XslSequence.getTemplateFromEncryptedStylesheet(sysConfig.xslFile) : XslSequence.getTemplateFromStylesheet(sysConfig.xslFile);
                templateMap.put(sysConfig.xslFile.getAbsolutePath(), template);
                transformer = template.newTransformer();
            }
            XslSequence.setTransformerParameters(transformer, sysConfig);
        }
        catch (Exception e) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.StylesheetProcessingFailed.createInstance());
        }
        return transformer;
    }

    private static Templates getTemplateFromStreamSource(StreamSource source) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        return TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null).newTemplates(source);
    }

    private static Templates getTemplateFromStylesheet(File xslFile) throws IOException, TransformerConfigurationException, TransformerFactoryConfigurationError {
        StreamSource source = new StreamSource(xslFile);
        Templates templates = XslSequence.getTemplateFromStreamSource(source);
        return templates;
    }

    private static Templates getTemplateFromEncryptedStylesheet(File encryptedXslFile) throws IOException, TransformerConfigurationException, TransformerFactoryConfigurationError {
        XhCryptor.setPassword(password);
        String stylesheet = XhCryptor.xhcrypt(encryptedXslFile);
        stylesheet = new String(stylesheet.getBytes(), "UTF-8");
        StreamSource source = new StreamSource(new StringReader(stylesheet));
        Templates templates = XslSequence.getTemplateFromStreamSource(source);
        return templates;
    }

    public static void resetTransformers() {
        templateMap.clear();
    }

    @Override
    public void run(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        if (!fileStatus.isCorrupted()) {
            sysConfig.getLogger().outlnWithTimeStamp("Pr\u00fcfe \"" + fileStatus.getFileConfig().inputFile.getAbsolutePath() + "\"...");
            Transformer mainTransformer = XslSequence.getTransformer(sysConfig);
            HeaderReader.HeaderInformation headerInformation = HeaderReader.getHeaderInformation(fileStatus.getCurrentLocation());
            int currentValId = headerInformation.highestValId + 1;
            fileStatus.addValidationId(Integer.toString(currentValId));
            mainTransformer.setParameter("validation_id", currentValId);
            if (sysConfig.doSchemaVal) {
                XslSequence.transform(fileStatus.getCurrentLocation(), fileStatus.getFileConfig().outputFile, mainTransformer);
            } else {
                try {
                    mainTransformer.transform(new StreamSource(fileStatus.getCurrentLocation()), new StreamResult(fileStatus.getFileConfig().outputFile));
                }
                catch (TransformerException e) {
                    throw new InternalException(ErrorsFromDB.Datenpruefprogramm.XsltError.createInstance());
                }
            }
            fileStatus.setCurrentLocation(fileStatus.getFileConfig().outputFile, this.getClass());
            sysConfig.getLogger().outlnWithTimeStamp("Schreibe Pr\u00fcfungsergebnis nach \"" + fileStatus.getFileConfig().outputFile.getAbsolutePath() + "\"...");
        }
    }

    @Override
    public void check(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        if (sysConfig.xslFile == null) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.XslFileNotFoundOrMultiple.createInstance());
        }
    }
}

