/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationErrorHandler
implements ErrorHandler {
    private List<String> fatalErrorMessages = new ArrayList<String>();
    private List<String> errorMessages = new ArrayList<String>();
    private boolean technicalErrors = false;

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.isFatalError(e)) {
            this.fatalErrorMessages.add(this.getError(e));
        } else {
            this.errorMessages.add(this.getError(e));
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.error(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.error(e);
    }

    private boolean isFatalError(SAXParseException e) {
        return true;
    }

    private String getError(SAXParseException e) {
        int line = e.getLineNumber();
        String message = e.getMessage().replace("\"urn:gba:sqg\":", "");
        return "Zeile " + line + ": " + message.replaceAll("[^ ]*\\:", "");
    }

    public boolean isProcessable() {
        return this.fatalErrorMessages.isEmpty();
    }

    public boolean hasTechnicalErrors() {
        return this.technicalErrors;
    }

    public boolean hasErrors() {
        return !this.fatalErrorMessages.isEmpty() || !this.errorMessages.isEmpty();
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getFatalErrorMessages() {
        return this.fatalErrorMessages;
    }

    public void addXmlError(Exception exception) {
        if (exception == null || exception.getMessage() == null) {
            this.addXmlError();
        } else {
            this.fatalErrorMessages.add("Die Datei konnte nicht gelesen werden: " + exception.getMessage());
        }
    }

    public void addXmlError() {
        this.fatalErrorMessages.add("Die Datei konnte nicht gelesen werden");
    }

    public void addXslError() {
        this.technicalErrors = true;
        this.fatalErrorMessages.add("Das Stylesheet konnte nicht gelesen werden");
    }

    public void addXsdError() {
        this.technicalErrors = true;
        this.fatalErrorMessages.add("Das XML-Schema konnte nicht gelesen werden");
    }

    public void addXsltError(String message) {
        this.technicalErrors = true;
        this.fatalErrorMessages.add("Unbekannter Fehler bei der XSL-Transformation: " + message);
    }
}

