<?xml version="1.0" encoding="UTF-8"?>
<!-- Version:2.0.0 -->
<!-- xslt 2.0 würde bei lokaler Verwendung nicht unterstützt werden --> 
	<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="http://www.w3.org/1999/xhtml" xmlns="http://www.w3.org/1999/xhtml" exclude-result-prefixes="html" xmlns:gba="urn:gba:sqg">
	<!-- bear in mind: no xsl:function in XSL version 1.0 -->
	<xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'"/>
	<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
	<xsl:variable name="isMiniprotocol" select="/gba:root/gba:protocol/gba:status_document/@V"/>	
	<xsl:variable name="hasERROR" select="/gba:root/gba:header/gba:protocol/gba:status_document/@V = 'ERROR' or //gba:status_case[./@V = 'ERROR']"/>	
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>Protokoll</title>
				<meta content="text/html;charset=utf-8" http-equiv="Content-Type"/>
				<meta http-equiv="X-UA-Compatible" content="IE=7"/>
				<style type="text/css"> body{font-family:sans-serif;font-size:13px}table{border-collapse:collapse;margin-top:24px;width:100%}table,#processable,#docStatus{border:1px solid #999}.hl_bg th:first-child,.hl_bg td:first-child{border-left:1px solid #999}.hl_bg th:last-child,.hl_bg td:last-child{border-right:1px solid #999}.hl_bg{background-color:#efefef}.hl_bg td{width:200px;border:1px solid #999;color:#000}td{padding:2px 10px 2px 10px}th{font-weight:normal;text-align:left;border:1px solid #999}th:first-child{border-right-style:dotted}th:last-child{border-left-style:dotted}#docStatus,th{background-color:#ddd}th{padding:8px 10px}.priority-1{font-weight:bold}.priority-2{font-weight:normal;font-style:italic}.headline{text-decoration:none}.no_decoration{font-weight:normal!important;text-decoration:none!important}.error td:last-child,.warning td:last-child,.ok td:last-child{color:#fff}.errorDoc,.error td:last-child{background-color:#ec3f3f}.warning td:last-child{background-color:#ff8d42}.warningDoc{background-color:#ff8d42}.okDoc,.ok td:last-child{background-color:#4bbc4b}.errorText{color:red}.warningText{color:orange}.okText{color:green}#content{display:inline-block;width:900px}table,#processable,#docStatus{box-shadow:2px 2px 4px #bbb}#processable{color:#fff}#processable,#docStatus{margin-bottom:15px;padding:6px}#processable span,#docStatus span{display:inline-block;width:120px}.clear{clear:both}hr{border:0;border-top:1px solid #bbb}#options{display:none;cursor:pointer;text-align:right;margin-top:15px;}div.detail{border:1px solid #bbb;background-color:#efefef;box-shadow:2px 2px 4px #ccc;padding:5px}div.detail,tr td hr{margin:15px 10px}ul li{padding-top:4px;padding-bottom:4px}div.detail p{margin:0;padding:0;background-color:inherit;border-bottom:1px solid #bbb;padding:4px}.regular{font-weight:normal}.notice{display:none;font-size:11px;color:#666}.error td,.warning td,.ok td{color:expression((this.parentNode.lastChild == this)? "#fff":"inherit")}.error td{background-color:expression((this.parentNode.lastChild == this)? "#EC3F3F":"inherit")}.warning td{background-color:expression((this.parentNode.lastChild == this)? "#FF8D42":"inherit")}.ok td{background-color:expression((this.parentNode.lastChild == this)? "#4BBC4B":"inherit")}tr td ul.document li{padding-top:expression((this.parentNode.firstChild == this)? "10px":"inherit")}tr td ul li{padding-bottom:expression((this.parentNode.lastChild == this)? "10px":"inherit")}th{border-right-style:expression((this.parentNode.firstChild == this) ? "dotted":"inherit"}th{border-right-style:expression((this.parentNode.lastChild == this) ? "dotted":"inherit"}.hg_grau{background-color:#efefef; border-bottom: 1px solid #bbb;}</style>
				<script>
					var allOpen=true;
					
					function init(){
						var c=document.querySelectorAll(".hl_bg.error,.hl_bg.warning")
						c=Array.prototype.slice.call(c);
						
						//validation_item s mit ERROR und WARNING sollen aufgeklappt gezeigt werden
						//WARNING sind auch aufgeklappt, damit die erzeugte Ansicht als Druckversion genutzt werden kann
						c.forEach(function(x){
							toggle(x)
						})
					
						if(c.some(function(x){return x.className.includes("error")})){
								sort_tables_by_relevance();
								sort_vali_items_by_relevance_in_each_table();
						}
						
						var a=document.getElementById("options");
						a.style.display="block";
						document.getElementById("notice").style.display="block";
						bindEvent(a,"click",function(){toggleAll()},false)
					}
					
					function toggle(b){
						var a=getSiblingRow(b);
						toggleContentRow(a)
					}
					
					function toggleAll(){
						var c=document.getElementsByClassName("hl_bg");
						c = Array.prototype.slice.call(c);
						c.forEach(function(x){
							var a=getSiblingRow(x);
							if(allOpen){
								a.style.display="none"
							}else{
								crossBrowser_showTableRow(a)
							}
						})
						allOpen=!allOpen
					}
					
					function bindEvent(c,a,b){
						if(c.addEventListener){
							c.addEventListener(a,b,false)
						}else{
							if(c.attachEvent){
								c.attachEvent("on"+a,b)
							}
						}
					}
					
					function getSiblingRow(b){
						var a=b.nextSibling;
						while(a){
							if(a.nodeType==1){
								return a;
								break
							}
							a=a.nextSibling
						}
						return null
					}
					
					function toggleContentRow(a){
						if(a.style.display!="none"){
							a.style.display="none"
						}else{
							crossBrowser_showTableRow(a)
						}
					}
					
					function crossBrowser_showTableRow(b){
						try{
							b.style.display="table-row"
						}catch(a){
							b.style.display=""
						}
					}
					
					function toggleTBody(){
						var a = document.getElementsByTagName("tbody");
						if(a[0].style.display!="none"){
							a[0].style.display="none"
						}else{
							a[0].style.display="table-row-group"
						}
					};
					
					
					var sort_by_class = function(a, b) {
								//class en:
									//hl_bg ok
									//hl_bg warning
									//hl_bg error
								
								a = a[0].className;
								b = b[0].className;
								
								var warning = "warning";
								
								//erzwingt Sortierung: error, warning, ok, da "f" vor "ok"
								if(a.includes(warning)){
									a = a.replace(warning,"f");
								};
								
								if(b.includes(warning)){
									b = b.replace(warning,"f");
								};
								
								return a.toLowerCase().localeCompare(b.toLowerCase());
					}
					
							
							
					function sort_tables_by_relevance(){
					
						var tables = document.getElementsByTagName("table");
						tables = Array.prototype.slice.call(tables);
						
						//Shift (remove) the first element of the array:
						var statistik_block = tables.shift();
						
						tables.sort(function tmp(a, b){ 
							if(a.querySelector(".hl_bg.error") !== null){
								//kleinere Tabellen mit ERROR sollen weiter oben stehen als große Tabellen mit ERROR (so kompaktere Darstellung)
								var rows_count = Array.prototype.slice.call(a.querySelectorAll("tr")).length;
								a = 1 - (1 / rows_count);
											
							}else if(a.querySelector(".hl_bg.warning") !== null){
								a = 2;
							}else{
								a = 3;
							};
						
							if(b.querySelector(".hl_bg.error") !== null){
								var rows_count = Array.prototype.slice.call(b.querySelectorAll("tr")).length;
								b = 1  - (1 / rows_count);
								
							}else if(b.querySelector(".hl_bg.warning") !== null){
								b = 2;
							}else{
								b = 3;
							};
							return a - b;
						});
						
						
						var children = Array.prototype.slice.call(document.getElementById("content").children);
						var anker_index = children.map(function tmp(x){return x.localName}).lastIndexOf("table") + 1; 
						
						//"it will automatically be removed from its existing parent before appending it to the specified new parent."
						tables.forEach(function(x){
							x.parentNode.insertBefore(x, children[anker_index]);
						})
					};
					
					function sort_vali_items_by_relevance_in_each_table(){
					
						let tables = document.getElementsByTagName("table");
						tables = Array.prototype.slice.call(tables);
						
						//Statistikblock auslassen
						tables.shift();
						
						tables.forEach(function(t){
							let rows = t.getElementsByTagName("tr");
							rows = Array.prototype.slice.call(rows);
						
							let validation_provider = rows.shift();
							
							let j = 0;
							let pairs = [];
							rows.forEach(function(x){
								//for in Syntax war unberechenbar; Ursache konnte nicht genau identifiziert werden; auf jeden Fall war das Ergebnis in pairs falsch
								//for(let j in rows){
								//klassisch for(var i = 0; i &lt; ...funzt nicht wegen &lt;
					
								if(j % 2 == 0){
									let chunk = rows.slice(j, j + 2);
									pairs.push(chunk);
								}
								j++;
							})
						
							pairs = pairs.sort(sort_by_class).flat();
							let rows_new_order = [validation_provider].concat(pairs);
						
							//"it will automatically be removed from its existing parent before appending it to the specified new parent."
							rows_new_order.forEach(function(x){
								x.parentNode.appendChild(x);
							})
						});
					};
				
				</script>
			</head>
			
			<xsl:choose>
			<xsl:when test = "not(//gba:validation_provider/@name)">
				<div><span style="color: red;">ERROR: </span>Die Eingabedatei ist kein Datenflussprotokoll. Das XML-Element validation_provider fehlt.
				</div>
			</xsl:when>
			<xsl:otherwise>
				<body onload="init()">
				<div id="content">
					<!-- status_document wird nicht angezeigt, da ein WARNING in status_document von Leistungserbringern zum Teil falsch interpretiert wird, wenn ERRORS auf Datensatzebene vorliegen -->
					<!--<xsl:apply-templates select="gba:root/gba:header/gba:protocol/gba:status_document"/>-->
					<xsl:choose>
						<xsl:when test="not($isMiniprotocol)">
							<table>
								<thead>
									<th colspan="6" onclick="toggleTBody()" style="cursor: pointer;">Verarbeitete Datensätze je Datencontainer</th>
								</thead>
								<tbody style="display:table-row-group; text-align:center; ">
									<tr style="background-color:#efefef; border-bottom: 1px solid #bbb; ">
										<td>Modul</td>
										<td>gesamt</td>
										<td>create</td>
										<td>update</td>
										<td>delete</td>
										<td>corrupted</td>
									</tr>
									<xsl:apply-templates select="gba:root/gba:body/gba:data_container/gba:cases"/>
								</tbody>
							</table>
							<!--bewusste Entscheidung: Button/Funktion ist bei Miniprotokollen überflüssig -->	
							<div id="options">Validierungsdetails ein/aus</div>
							<xsl:if test="$hasERROR">
								<br/>
								<p id="notice">Prüfergebnis <b>ERROR:</b> Auffälligkeiten bzw. Fehler, die eine Weiterverarbeitung ausschließen. Eine Korrektur und erneute Lieferung sind erforderlich. Die Anzahl der abgelehnten Datensätze kann der Spalte <b>corrupted</b> entnommen werden. // Prüfergebnis <b>WARNING:</b> Auffälligkeiten, die einer Weiterverarbeitung nicht im Weg stehen // Prüfergebnis <b>OK:</b> Keine Auffälligkeiten</p>
							</xsl:if>
							<xsl:apply-templates select="gba:root/gba:header/gba:protocol/gba:validation_provider"/>
							<br/>
							<p id="notice">Details einzelner Validation-Items können durch Klicken auf das jeweilige Element angezeigt oder ausgeblendet werden.</p>
						</xsl:when>
						<xsl:otherwise> <!-- $isMiniprotocol -->
								<xsl:apply-templates select="gba:root/gba:protocol/gba:validation_provider"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</body>
			</xsl:otherwise>
			</xsl:choose>
		</html>
	</xsl:template>

	<!--<xsl:template match="gba:status_document">
		<div class="{concat(translate(@V, $uppercase, $lowercase), 'Doc')}" id="processable">
			<span>Dokument-Status:</span>
			<xsl:value-of select="@V"/>
		</div>
	</xsl:template>-->
	
	<xsl:template match="gba:validation_provider">
		<table>
			<tr>
				<th colspan="2">
					<span class="priority-1">
						<xsl:choose>
							<xsl:when test="string-length(@function) &gt; 0">
								<xsl:value-of select="@function"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'Unbekannte Funktion'"/>
							</xsl:otherwise>
						</xsl:choose>
					</span>
					<br/>
					<span class="priority-1">
						<xsl:choose>
							<xsl:when test="string-length(@name) &gt; 0">
								<xsl:value-of select="@name"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'Unbekannter Provider'"/>
							</xsl:otherwise>
						</xsl:choose>
					</span>

					<xsl:choose>
						<xsl:when test="string-length(@function) &gt; 0">
					(<xsl:value-of select="@registration"/>)<br/>
						</xsl:when>
						<xsl:otherwise>
						</xsl:otherwise>
					</xsl:choose>

					<xsl:value-of select="@address"/>
				</th>
				<th colspan="2">tel: 
						<xsl:choose>
							<xsl:when test="string-length(@phone) &gt; 0">
								<xsl:value-of select="@phone"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'-'"/>
							</xsl:otherwise>
						</xsl:choose>
					<br/>fax: 
						<xsl:choose>
							<xsl:when test="string-length(@fax) &gt; 0">
								<xsl:value-of select="@fax"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'-'"/>
							</xsl:otherwise>
						</xsl:choose>
					<br/>
						<xsl:choose>
							<xsl:when test="string-length(@email) &gt; 0">
								<xsl:value-of select="@email"/>
							</xsl:when>
							<xsl:otherwise>
							</xsl:otherwise>
						</xsl:choose>
				</th>
			</tr>
			<xsl:apply-templates select="gba:validation_item"/>
		</table>
	</xsl:template>

	<xsl:template match="gba:validation_item">
		<xsl:variable name="id" select="@id"/>
		<xsl:variable name="cases_with_errors"       select="//gba:case/gba:case_admin/gba:protocol/gba:validation_item[@id = $id]/gba:status/gba:error/ancestor::gba:case"/>
		<xsl:variable name="cases_with_status_error" select="//gba:case/gba:case_admin/gba:protocol/gba:validation_item[@id = $id]/gba:status[@V='ERROR']"/>

		<xsl:variable name="state_le_view">
			<xsl:choose>
				<xsl:when test="$cases_with_status_error">
					<xsl:value-of select="'ERROR'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="gba:status/@V"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--überschreibe WARNING mit ERROR, wenn es Datensätze mit ERROR gibt-->
		<tr class="hl_bg {translate($state_le_view, $uppercase, $lowercase)}" style="cursor: pointer;" onclick="toggle(this)">
			<td>Validierung <xsl:value-of select="@id"/>
			</td>
			<td>
				<xsl:value-of select="@c_date"/>
			</td>
			<td>
				<xsl:value-of select="@V"/>
			</td>
			<td>
				<xsl:value-of select="$state_le_view"/>
			</td>
		</tr>
		<!--default: Detailansicht ist zugeklappt-->
		<tr style="display: none;">
			<td colspan="4">
				<xsl:choose>
					<xsl:when test="gba:status/gba:error or $cases_with_errors">
						<xsl:if test="gba:status/gba:error">
							<div class="detail">
								<ul class="document">
									<xsl:apply-templates select="gba:status/gba:error" mode="dokumentenebene"/>
								</ul>
							</div>
						</xsl:if>
						<xsl:if test="gba:status/gba:error and $cases_with_errors">
							<hr/>
						</xsl:if>
						<xsl:if test="$cases_with_errors">
							<xsl:apply-templates select="$cases_with_errors">
								<xsl:with-param name="id" select="$id"/>
							</xsl:apply-templates>
						</xsl:if>						
					</xsl:when>
					<xsl:otherwise>
						<div class="detail">Validierung erfolgreich</div>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="gba:error" mode="dokumentenebene">
		<li>
			<span class="bold">
				<xsl:value-of select="gba:error_message/@V"/>
			</span>
			<br/>
			<xsl:if test="gba:error_type">
				Art: <span class="bold">
					<xsl:value-of select="gba:error_type/@V"/>
				</span>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="gba:rule_id and gba:rule_type">
					 (Regel-ID: <span class="bold">
						<xsl:value-of select="gba:rule_id/@V"/>
					</span> | Regel-Typ: <span class="bold">
						<xsl:choose>
							<xsl:when test="gba:rule_type/@V = 'H'">
								<xsl:value-of select="'ERROR'"/> 
							</xsl:when>
							<xsl:when test="gba:rule_type/@V = 'W'">
								<xsl:value-of select="'WARNING'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="gba:rule_type/@V"/>
							</xsl:otherwise>
						</xsl:choose>
						<!--<xsl:value-of select="gba:rule_type/@V"/>-->
					</span>)
				</xsl:when>
				<xsl:when test="gba:rule_id and not(gba:rule_type)">
					 (Regel-ID: <span class="bold">
						<xsl:value-of select="gba:rule_id/@V"/>
					</span>)
				</xsl:when>
				<xsl:when test="not(gba:rule_id) and gba:rule_type">
					 (Regel-Typ: <span class="bold">
												<xsl:choose>
							<xsl:when test="gba:rule_type/@V = 'H'">
								<xsl:value-of select="'ERROR'"/>
							</xsl:when>
							<xsl:when test="gba:rule_type/@V = 'W'">
								<xsl:value-of select="'WARNING'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="gba:rule_type/@V"/>
							</xsl:otherwise>
						</xsl:choose>
						<!--<xsl:value-of select="gba:rule_type/@V"/>-->
					</span>)
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
		</li>
		<!-- zusätzlicher Hinweis in Miniprotokollen -->
		<xsl:if test="$isMiniprotocol">
			<li>
				<span class="bold">
					<xsl:value-of select="'Kein Datensatz aus dieser Exportdatei konnte aufgrund des genannten Fehlers weiter verarbeitet werden. Eine Korrektur und erneute Lieferung sind erforderlich.'"/>
				</span>
	
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="gba:error" mode="datensatz">
		<li>
			<span class="bold">
				<xsl:value-of select="gba:error_message/@V"/>
			</span>
			<br/>
			<xsl:if test="gba:error_type">
				Art: <span class="bold">
					<xsl:value-of select="gba:error_type/@V"/>
				</span>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="gba:rule_id and gba:rule_type">
					 (Regel-ID: <span class="bold">
						<xsl:value-of select="gba:rule_id/@V"/>
					</span> | Regel-Typ: <span class="bold">
						<!--<xsl:choose>
							<xsl:when test="gba:rule_type/@V = 'H'">
								<xsl:value-of select="'ERROR'"/> 
							</xsl:when>
							<xsl:when test="gba:rule_type/@V = 'W'">
								<xsl:value-of select="'WARNING'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="gba:rule_type/@V"/>
							</xsl:otherwise>
						</xsl:choose>-->
						<xsl:value-of select="gba:rule_type/@V"/>
					</span>)
				</xsl:when>
				<xsl:when test="gba:rule_id and not(gba:rule_type)">
					 (Regel-ID: <span class="bold">
						<xsl:value-of select="gba:rule_id/@V"/>
					</span>)
				</xsl:when>
				<xsl:when test="not(gba:rule_id) and gba:rule_type">
					 (Regel-Typ: <span class="bold">
						<!--<xsl:choose>
							<xsl:when test="gba:rule_type/@V = 'H'">
								<xsl:value-of select="'ERROR'"/>
							</xsl:when>
							<xsl:when test="gba:rule_type/@V = 'W'">
								<xsl:value-of select="'WARNING'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="gba:rule_type/@V"/>
							</xsl:otherwise>
						</xsl:choose>-->
						<xsl:value-of select="gba:rule_type/@V"/>
					</span>)
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
		</li>

	</xsl:template>


	<xsl:template match="gba:case">
		<xsl:param name="id"/>
		<xsl:if test="not(gba:case_admin/gba:protocol/gba:status_case/@V = 'OK')">
			<div class="detail">
				<p>Vorgang <span class="priority-1">
						<xsl:value-of select="gba:case_admin/gba:id/@V"/>
					</span> (Status: <span class="priority-2">
						<xsl:value-of select="gba:case_admin/gba:protocol/gba:status_case/@V"/>
					</span>)</p>
				<ul>
					<xsl:apply-templates select="gba:case_admin/gba:protocol/gba:validation_item[@id = $id]/gba:status/gba:error" mode="datensatz"/>
				</ul>
			</div>
		</xsl:if>
	</xsl:template>
	<!-- in Miniprotokollen gibt es KEIN cases -->
	<xsl:template match="gba:cases">
		<tr style="border-bottom: 1px solid #bbb; ">				
			<td><xsl:value-of select="@module"/></td>
			<xsl:choose>
				<!-- bei Fehlern auf Dokumentenebene kann der processed-Block ungeschrieben sein-->
				<xsl:when test="/gba:root//gba:status_document/@V = 'ERROR'">
					<xsl:variable name="processed_corrupted" select="count(gba:case)"/>
					<!-- gesamt (pro cases)-->
					<td><xsl:value-of select="$processed_corrupted"/></td>
					<!-- create-->
					<td><xsl:value-of select="0"/></td>
					<!-- update -->
					<td><xsl:value-of select="0"/></td>
					<!-- delete -->
					<td><xsl:value-of select="0"/></td>
					<td style="background-color:#ec3f3f; color:white; font-weight:bold; ">
						<xsl:value-of select="$processed_corrupted"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="processed_corrupted" select="gba:statistic/gba:processed/gba:corrupted/@V"/>
					<td><xsl:value-of select="gba:statistic/gba:processed/@count"/></td>
					<td><xsl:value-of select="gba:statistic/gba:processed/gba:create/@V"/></td>
					<td><xsl:value-of select="gba:statistic/gba:processed/gba:update/@V"/></td>
					<td><xsl:value-of select="gba:statistic/gba:processed/gba:delete/@V"/></td>
					<xsl:choose>
						<xsl:when test="$processed_corrupted > 0">
							<td style="background-color:#ec3f3f; color:white; font-weight:bold; ">
								<xsl:value-of select="$processed_corrupted"/>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td>
								<xsl:value-of select="$processed_corrupted"/>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>

</xsl:stylesheet>