/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml.sax;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.RuntimeErrorException;
import org.iqtig.pruefprogramm.config.Provider;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.xml.sax.XmlCopySaxParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementRemover
extends XmlCopySaxParser {
    private int irrelevantElements = 0;
    private BufferedWriter out;
    private String[] elementsToDelete;
    private final File inputFile;
    private final File outputFile;
    private boolean providerReplaced = false;
    private boolean isProvider = false;
    private final Provider provider;
    private String currentStartNodeName = "";
    private String currentEndNodeName = "";
    private boolean first_protocol_element = true;
    private boolean set_feedback_range;

    public ElementRemover(File inputFile, File outputFile, Provider provider) {
        this(inputFile, outputFile, provider, false);
    }

    public ElementRemover(File inputFile, File outputFile, Provider provider, boolean set_feedback_range) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.provider = provider;
        this.set_feedback_range = set_feedback_range;
    }

    public static void removeElements(File inputFile, File outputFile, String[] elementsToDelete) throws InternalException {
        try {
            new ElementRemover(inputFile, outputFile, null).removeElements(elementsToDelete);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public static void removeElements(File inputFile, File outputFile, Provider provider, String[] elementsToDelete) throws InternalException {
        try {
            new ElementRemover(inputFile, outputFile, provider).removeElements(elementsToDelete);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public static void removeElements(File inputFile, File outputFile, Provider provider, String[] elementsToDelete, boolean set_feedback_range) throws InternalException {
        try {
            new ElementRemover(inputFile, outputFile, provider, set_feedback_range).removeElements(elementsToDelete);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public void removeElements(String[] elementsToDelete) throws SAXException, IOException, RuntimeErrorException {
        this.elementsToDelete = elementsToDelete;
        this.outputFile.getParentFile().mkdirs();
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
        this.parse(this.inputFile);
    }

    @Override
    protected void write(String s) {
        if (this.provider != null && this.isProvider) {
            return;
        }
        if (this.irrelevantElements > 0) {
            return;
        }
        try {
            this.out.write(s);
        }
        catch (IOException e) {
            throw new RuntimeErrorException(new Error(e.getMessage()));
        }
    }

    @Override
    protected void write(char c) {
        if ((c == '\n' || c == '\t') && this.currentEndNodeName.equals(this.currentStartNodeName)) {
            return;
        }
        if (this.provider != null && this.isProvider) {
            return;
        }
        if (this.irrelevantElements > 0) {
            return;
        }
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            throw new RuntimeErrorException(new Error(e.getMessage()));
        }
    }

    @Override
    protected void init() {
    }

    @Override
    protected void exit() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeErrorException(new Error(e.getMessage()));
        }
    }

    @Override
    protected void startElement(String uri, String name, String qName, XmlCopySaxParser.XmlTagAttribute[] attributes) {
        if (this.provider != null && !this.providerReplaced && this.provider != null && qName.equals("provider")) {
            this.isProvider = true;
        } else if (qName.equals("modification_dttm")) {
            this.setAttValue(attributes, "V", ElementRemover.getDate());
        }
        for (String element : this.elementsToDelete) {
            if (!this.isSameElement(element, name, qName)) continue;
            ++this.irrelevantElements;
        }
        this.setCurrentStartNodeName(qName);
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.chars = false;
        ++this.indent;
        if (!this.tagClosed) {
            this.write('>');
        }
        XmlCopySaxParser.XmlTagAttribute[] xmlTagAttributes = XmlCopySaxParser.XmlTagAttribute.getAttributes(attributes);
        this.startElement(uri, name, qName, xmlTagAttributes);
        this.write('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write('\t');
        }
        if (this.set_feedback_range && qName.equals("protocol") && this.first_protocol_element) {
            this.write("<" + qName + " feedback_range=\"dataflow\"");
            this.first_protocol_element = false;
        } else {
            this.write("<" + qName);
        }
        for (XmlCopySaxParser.XmlTagAttribute attribute : xmlTagAttributes) {
            this.write(" " + attribute.getName() + "=\"" + ElementRemover.escapeEntity(attribute.getValue()) + "\"");
        }
        this.tagClosed = false;
        this.postStartElement(uri, name, qName, xmlTagAttributes);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.setCurrentEndNodeName(qName);
        super.endElement(uri, name, qName);
    }

    @Override
    protected void endElementImpl(String uri, String name, String qName) {
        if (this.provider != null && !this.providerReplaced && qName.equals("provider")) {
            this.isProvider = false;
            this.setCurrentEndNodeName("provider");
            this.write("\n");
            for (int i = 0; i <= this.indent; ++i) {
                this.write("\t");
            }
            this.write(this.provider.validationProviderToString(true).replace("></provider>", "/>"));
            this.providerReplaced = true;
        }
        for (String element : this.elementsToDelete) {
            if (!this.isSameElement(element, name, qName)) continue;
            --this.irrelevantElements;
        }
        this.setCurrentEndNodeName("");
    }

    private boolean isSameElement(String element, String name, String qName) {
        if (element == null) {
            return false;
        }
        if (element.startsWith("*:")) {
            return element.substring(2).equals(name);
        }
        return element.equals(qName);
    }

    private void setCurrentEndNodeName(String name) {
        this.currentEndNodeName = name;
    }

    private void setCurrentStartNodeName(String name) {
        if (this.irrelevantElements <= 0) {
            this.currentStartNodeName = name;
        }
    }

    @Override
    protected void preEndElement(String uri, String name, String qName) {
    }

    @Override
    protected void postStartElement(String uri, String name, String qName, XmlCopySaxParser.XmlTagAttribute[] attributes) {
    }

    public static String getDate() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
    }
}

