/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.errors;

import org.iqtig.errors.ValidationItem;
import org.iqtig.utils.common_api.EnInstitution;
import org.iqtig.utils.common_api.errors.EnDataStatus;
import org.iqtig.utils.common_api.errors.EnErrorScope;
import org.iqtig.utils.common_api.errors.EnErrorType;
import org.iqtig.utils.common_api.errors.EnValidationArea;
import org.iqtig.utils.common_api.errors.IOriginatorByInstitutionMapper;
import org.iqtig.utils.common_api.errors.IValidationItem;
import org.iqtig.utils.common_api.errors.ValidationErrorException;

public class ErrorMethodsHelper {
    private int id;
    private EnDataStatus status;
    private EnValidationArea area;
    private EnErrorType errorType;
    private EnErrorScope errorScope;
    private boolean isStandardized;
    private String errorMessage;
    private IOriginatorByInstitutionMapper originatorByInstitutionMapper;

    public EnInstitution getOriginator(EnInstitution institutionFunction) {
        if (this.originatorByInstitutionMapper == null || institutionFunction == null) {
            return null;
        }
        switch (institutionFunction) {
            case Datenannahmestelle: {
                return this.getOriginatorByInstitutionMapper().getOriginatorWhenDas();
            }
            case Vertrauensstelle: {
                return this.getOriginatorByInstitutionMapper().getOriginatorWhenVst();
            }
            case Bundesauswertungsstelle: {
                return this.getOriginatorByInstitutionMapper().getOriginatorWhenBas();
            }
        }
        throw new IllegalArgumentException(institutionFunction.name() + " kann niemals ein Verursacher zugeordnet werden. Erlaubt sind nur Datenannahmestelle, Vertrauensstelle und Bundesauswertungsstelle.");
    }

    public IValidationItem toValidationItem(ValidationErrorException error) {
        ValidationItem vi = new ValidationItem();
        vi.setId(error.getId());
        vi.setArea(this.area);
        vi.addError(error);
        return vi;
    }

    public EnDataStatus getStatus() {
        return this.status;
    }

    public void setStatus(EnDataStatus status) {
        if (status != null && status != EnDataStatus.WARNING && status != EnDataStatus.ERROR) {
            throw new IllegalArgumentException("Ein Fehler kann keinen Status " + status.name() + " annehmen. Nur " + EnDataStatus.WARNING.name() + " und " + (Object)((Object)EnDataStatus.ERROR) + " sind erlaubt.");
        }
        this.status = status;
    }

    public EnErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(EnErrorType errorType) {
        this.errorType = errorType;
    }

    public EnErrorScope getErrorScope() {
        return this.errorScope;
    }

    public void setErrorScope(EnErrorScope errorScope) {
        this.errorScope = errorScope;
    }

    public boolean isStandardized() {
        return this.isStandardized;
    }

    public void setStandardized(boolean isStandardized) {
        this.isStandardized = isStandardized;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public IOriginatorByInstitutionMapper getOriginatorByInstitutionMapper() {
        return this.originatorByInstitutionMapper;
    }

    public void setOriginatorByInstitutionMapper(IOriginatorByInstitutionMapper originatorByInstitutionMapper) {
        this.originatorByInstitutionMapper = originatorByInstitutionMapper;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public EnValidationArea getArea() {
        return this.area;
    }

    public void setArea(EnValidationArea area) {
        this.area = area;
    }
}

