/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.config;

import java.io.File;
import org.iqtig.errors.ErrorsFromDB;
import org.iqtig.param.StringParameter;
import org.iqtig.pruefprogramm.common.XmlFunctions;
import org.iqtig.pruefprogramm.config.Provider;
import org.iqtig.pruefprogramm.error.InternalException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Configuration {
    public static final String DEFAULT_XSL_PATH = "xsl";
    public static final String DEFAULT_XSD_PATH = "xsd/interface_LE";
    public static final String DEFAULT_INPUT_PATH = "input";
    public static final String DEFAULT_OUTPUT_PATH = "output";
    public static final String DEFAULT_CONFIG_PATH = "config.xml";
    public static final Boolean DEFAULT_RECURSIVE_VALUE = false;
    public static final Boolean DEFAULT_GUI_VALUE = false;
    private final String path = Configuration.getPath();
    public final String inputPath;
    public final String outputPath;
    public final String xsdPath;
    public final String xslPath;
    public final boolean recursive;
    public final boolean gui;
    public final Provider provider;

    public Configuration(String inputPath, String outputPath, String xsdPath, String xslPath, Boolean recursive, Boolean gui, Provider provider) {
        this.inputPath = inputPath != null && inputPath.length() > 0 ? inputPath : this.path + "/" + DEFAULT_INPUT_PATH;
        this.outputPath = outputPath != null && outputPath.length() > 0 ? outputPath : this.path + "/" + DEFAULT_OUTPUT_PATH;
        this.xsdPath = xsdPath != null && xsdPath.length() > 0 ? xsdPath : this.path + "/" + DEFAULT_XSD_PATH;
        this.xslPath = xslPath != null && xslPath.length() > 0 ? xslPath : this.path + "/" + DEFAULT_XSL_PATH;
        this.recursive = recursive != null ? recursive : false;
        this.gui = gui != null ? gui : false;
        this.provider = provider != null ? provider : new Provider();
    }

    public Configuration(Configuration config, String[] args) {
        String xsdPath = new StringParameter("--xsd-path").get(args);
        String xslPath = new StringParameter("--xsl-path").get(args);
        String inputPath = new StringParameter("--input").get(args);
        String outputPath = new StringParameter("--output").get(args);
        this.inputPath = inputPath != null ? inputPath : config.inputPath;
        this.outputPath = outputPath != null ? outputPath : config.outputPath;
        this.xsdPath = xsdPath != null ? xsdPath : config.xsdPath;
        this.xslPath = xslPath != null ? xslPath : config.xslPath;
        this.recursive = config.recursive;
        this.gui = config.gui;
        this.provider = config.provider;
    }

    public static Configuration getConfig(File configFile) throws InternalException {
        return Configuration.getConfig(configFile, false);
    }

    private static String getConfigPath(String configPath) {
        return configPath != null && configPath.length() > 0 ? configPath : Configuration.getPath() + "/" + DEFAULT_CONFIG_PATH;
    }

    public static Configuration getConfig(String configPath, boolean create) throws InternalException {
        return Configuration.getConfig(new File(Configuration.getConfigPath(configPath)), create);
    }

    public static Configuration getConfig(File configFile, boolean create) throws InternalException {
        if (!configFile.exists()) {
            if (create) {
                System.out.println("An der angegebenen Stelle konnte keine Konfigurationsdatei gefunden werden und wird daher neu erstellt.");
                Configuration.createConfig(configFile);
                System.out.println("Bitte ueberpruefen sie die Angaben in " + configFile.getAbsolutePath() + " und starten sie das Programm erneut.");
            }
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.ConfigFileNotFound.createInstance());
        }
        return Configuration.loadConfigurationFromFile(configFile);
    }

    private static Configuration loadConfigurationFromFile(File configFile) throws InternalException {
        return Configuration.loadConfigurationFromFile(configFile, null, null);
    }

    private static Configuration loadConfigurationFromFile(File configFile, File inputFile, File outputFile) throws InternalException {
        try {
            Document doc = XmlFunctions.getDocFromFile(configFile);
            String inputPath = inputFile == null ? XmlFunctions.getXPath(doc, "/config/input_path") : inputFile.getAbsolutePath();
            String outputPath = outputFile == null ? XmlFunctions.getXPath(doc, "/config/output_path") : outputFile.getAbsolutePath();
            String xsdPath = XmlFunctions.getXPath(doc, "/config/xsd_path");
            String xslPath = XmlFunctions.getXPath(doc, "/config/xsl_path");
            boolean recursive = false;
            boolean gui = false;
            if (XmlFunctions.getXPath(doc, "/config/input_path/@recursive").equals("true")) {
                recursive = true;
            }
            if (XmlFunctions.getXPath(doc, "/config/gui").equals("true")) {
                gui = true;
            }
            Provider provider = new Provider(XmlFunctions.getXPath(doc, "/config/provider/address"), XmlFunctions.getXPath(doc, "/config/provider/email"), XmlFunctions.getXPath(doc, "/config/provider/fax"), XmlFunctions.getXPath(doc, "/config/provider/function"), XmlFunctions.getXPath(doc, "/config/provider/name"), XmlFunctions.getXPath(doc, "/config/provider/phone"), XmlFunctions.getXPath(doc, "/config/provider/registration"));
            return new Configuration(inputPath, outputPath, xsdPath, xslPath, recursive, gui, provider);
        }
        catch (Exception e) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.ReadConfigFileFailed.createInstance());
        }
    }

    private static String getPath() {
        return new File(".").getAbsolutePath();
    }

    public static void createConfig(String configPath) throws InternalException {
        Configuration.createConfig(new File(Configuration.getConfigPath(configPath)));
    }

    public static void createConfig(File configFile) throws InternalException {
        try {
            Element configNode = XmlFunctions.addNode("config", XmlFunctions.getDocument());
            Element providerNode = XmlFunctions.addNode("provider", configNode);
            for (Provider.PropertyEnum property : Provider.PropertyEnum.values()) {
                XmlFunctions.addNode(property.name(), (Node)providerNode, property.defaultValue);
            }
            XmlFunctions.addNode("gui", (Node)configNode, DEFAULT_GUI_VALUE.toString());
            XmlFunctions.addNode("input_path", configNode, new String[]{"recursive==" + DEFAULT_RECURSIVE_VALUE.toString()}, DEFAULT_INPUT_PATH);
            XmlFunctions.addNode("output_path", (Node)configNode, DEFAULT_OUTPUT_PATH);
            XmlFunctions.addNode("xsd_path", (Node)configNode, DEFAULT_XSD_PATH);
            XmlFunctions.addNode("xsl_path", (Node)configNode, DEFAULT_XSL_PATH);
            XmlFunctions.serializeXML(configNode.getOwnerDocument(), configFile, false);
        }
        catch (Exception e) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.ConfigFileCreationFailed.createInstance());
        }
    }
}

