/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.sequence;

import javax.xml.validation.Validator;
import org.iqtig.errors.ErrorsFromDB;
import org.iqtig.pruefprogramm.common.XsdFunctions;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.sequence.Sequence;
import org.iqtig.pruefprogramm.status.FileStatus;
import org.iqtig.pruefprogramm.xml.ValidationErrorHandler;

public class XsdSequence
implements Sequence {
    @Override
    public void run(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        sysConfig.getLogger().outln();
        sysConfig.getLogger().outlnWithTimeStamp("Validiere \"" + fileStatus.getCurrentLocation().getAbsolutePath() + "\"...");
        Validator validator = XsdFunctions.getValidator(sysConfig.xsdFile);
        ValidationErrorHandler validationErrorHandler = XsdFunctions.validate(fileStatus.getCurrentLocation(), validator);
        fileStatus.addSchemaWarnings(validationErrorHandler.getErrorMessages());
        fileStatus.addSchemaErrors(validationErrorHandler.getFatalErrorMessages());
        if (!validationErrorHandler.isProcessable()) {
            fileStatus.setCorrupted(true);
        }
    }

    @Override
    public void check(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        if (sysConfig.xsdFile == null) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.XsdFileNotFoundOrMultiple.createInstance());
        }
    }
}

