/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml.sax;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.RuntimeErrorException;
import org.iqtig.pruefprogramm.config.Provider;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.xml.sax.XmlCopySaxParser;
import org.xml.sax.SAXException;

public class ValidationItemInserter
extends XmlCopySaxParser {
    private String[] valItems;
    private Provider provider;
    private boolean providerFound = false;
    private boolean valitemsEntered = false;
    private BufferedWriter out;
    private File inputFile;
    private InputStream ins;
    private final File outputFile;
    private ByteArrayOutputStream baos;

    public ValidationItemInserter(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    public ValidationItemInserter(InputStream ins, File outputFile) {
        this.ins = ins;
        this.outputFile = outputFile;
    }

    public static String getValItemString(String value, List<String> errorItems, String status, int valId, String cDate, String checkTool) {
        String valItemString = "<validation_item V=\"" + value + "\" c_date=\"" + (cDate != null ? cDate : ValidationItemInserter.getDate()) + "\" id=\"" + valId + "\"" + (checkTool != null ? " check_tool=\"" + checkTool + "\"" : "") + ">";
        valItemString = valItemString + "<status V=\"" + status + "\">";
        for (String errorItem : errorItems) {
            valItemString = valItemString + errorItem;
        }
        return valItemString + "</status></validation_item>";
    }

    public static List<String> getErrorItemStrings(List<String> errorMessages) {
        ArrayList<String> errorItemStrings = new ArrayList<String>();
        for (String errorMessage : errorMessages) {
            errorItemStrings.add(ValidationItemInserter.getErrorItemString(null, null, null, null, errorMessage));
        }
        return errorItemStrings;
    }

    public static String getErrorItemString(String errorType, String ruleId, String ruleType, String list, String errorMessage) {
        String errorItemString = "<error>";
        if (errorType != null) {
            errorItemString = errorItemString + "<error_type V=\"" + errorType + "\"/>";
        }
        if (ruleId != null) {
            errorItemString = errorItemString + "<rule_id V=\"" + ruleId + "\"/>";
        }
        if (ruleType != null) {
            errorItemString = errorItemString + "<rule_type V=\"" + ruleType + "\"/>";
        }
        if (list != null) {
            errorItemString = errorItemString + "<list V=\"" + list + "\"/>";
        }
        if (errorMessage != null) {
            errorItemString = errorItemString + "<error_message V=\"" + ValidationItemInserter.escapeEntity(errorMessage) + "\"/>";
        }
        errorItemString = errorItemString + "</error>";
        return errorItemString;
    }

    public static String getDate() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
    }

    public static void insertValidationItems(File inputFile, File outputFile, String[] valItems, Provider provider) throws InternalException {
        try {
            new ValidationItemInserter(inputFile, outputFile).insertValidationItems(valItems, provider);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public void insertValidationItems(String[] valItems, Provider provider) throws RuntimeErrorException, SAXException, IOException {
        this.valItems = valItems;
        this.provider = provider;
        this.outputFile.getParentFile().mkdirs();
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
        if (this.ins != null) {
            this.parse(this.ins);
        } else {
            this.parse(this.inputFile);
        }
    }

    public static ByteArrayOutputStream insertValidationItemsStream(File inputFile, String[] valItems, Provider provider) throws InternalException {
        try {
            return new ValidationItemInserter(inputFile, null).insertValidationItemsStream(valItems, provider);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public static ByteArrayOutputStream insertValidationItemsStream(InputStream ins, String[] valItems, Provider provider) throws InternalException {
        try {
            return new ValidationItemInserter(ins, null).insertValidationItemsStream(valItems, provider);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public ByteArrayOutputStream insertValidationItemsStream(String[] valItems, Provider provider) throws Exception {
        this.valItems = valItems;
        this.provider = provider;
        this.baos = new ByteArrayOutputStream();
        this.out = new BufferedWriter(new OutputStreamWriter(this.baos));
        if (this.ins != null) {
            this.parse(this.ins);
        } else {
            this.parse(this.inputFile);
        }
        return this.baos;
    }

    @Override
    protected void startElement(String uri, String name, String qName, XmlCopySaxParser.XmlTagAttribute[] attributes) {
        if (!this.providerFound && !this.valitemsEntered && qName.equals("validation_provider")) {
            String reg = this.getAttValue(attributes, "registration");
            if (reg != null && reg.equals(this.provider.registration)) {
                this.providerFound = true;
            }
        } else if (qName.equals("status_document")) {
            if (!this.providerFound) {
                String indentString = "";
                for (int i = 0; i < this.indent; ++i) {
                    indentString = indentString + '\t';
                }
                this.write('\n' + indentString + this.provider.validationProviderToString().replace("</validation_provider>", '\n' + this.getValItems() + '\n' + indentString + "</validation_provider>"));
            }
            this.setAttValue(attributes, "V", this.calcWorstStatus(this.getAttValue(attributes, "V")));
        } else if (qName.equals("modification_dttm")) {
            this.setAttValue(attributes, "V", ValidationItemInserter.getDate());
        }
    }

    @Override
    protected void preEndElement(String uri, String name, String qName) {
        if (qName.equals("validation_provider") && this.providerFound && !this.valitemsEntered) {
            this.write('\n' + this.getValItems());
            this.valitemsEntered = true;
        }
    }

    @Override
    protected void endElementImpl(String uri, String name, String qName) {
    }

    private String calcWorstStatus(String status_document) {
        ArrayList<String> valItemStatusList = new ArrayList<String>();
        for (String valItem : this.valItems) {
            valItemStatusList.add(this.getStatus(valItem));
        }
        if (status_document.equals("ERROR") || valItemStatusList.contains("ERROR")) {
            return "ERROR";
        }
        if (valItemStatusList.contains("WARNING") || status_document.equals("WARNING")) {
            return "WARNING";
        }
        return "OK";
    }

    private String getValItems() {
        String valitemsString = "";
        for (String valItem : this.valItems) {
            valitemsString = valitemsString + '\n';
            for (int i = 0; i < this.indent + 1; ++i) {
                valitemsString = valitemsString + '\t';
            }
            valitemsString = valitemsString + valItem;
        }
        return valitemsString.replaceFirst("\n", "");
    }

    private String getStatus(String valItem) {
        if (valItem.toLowerCase().contains("status v=\"error\"")) {
            return "ERROR";
        }
        if (valItem.toLowerCase().contains("status v=\"warning\"")) {
            return "WARNING";
        }
        return "OK";
    }

    @Override
    public void write(String s) {
        try {
            this.out.write(s);
        }
        catch (IOException e) {
            throw new RuntimeErrorException(new Error(e.getMessage()));
        }
    }

    @Override
    public void write(char c) {
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            throw new RuntimeErrorException(new Error(e.getMessage()));
        }
    }

    @Override
    protected void init() {
    }

    @Override
    protected void exit() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeErrorException(new Error(e.getMessage()));
        }
    }

    @Override
    protected void postStartElement(String uri, String name, String qName, XmlCopySaxParser.XmlTagAttribute[] attributes) {
    }
}

