/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.errors;

import java.text.StringCharacterIterator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.iqtig.errors.Error;
import org.iqtig.utils.common_api.EnInstitution;
import org.iqtig.utils.common_api.errors.EnDataStatus;
import org.iqtig.utils.common_api.errors.EnValidationArea;
import org.iqtig.utils.common_api.errors.IValidationItem;
import org.iqtig.utils.common_api.errors.ValidationErrorException;
import org.iqtig.utils.common_api.errors.ValidationException;

public class ValidationItem
extends ValidationException
implements IValidationItem {
    protected final int DEFAULT_ERROR_OUTPUT_LIMIT = 10;
    protected final int MAX_ERROR_OUTPUT_LIMIT = 100;
    private int id;
    private EnValidationArea area;
    private String checkTool;
    protected List<ValidationErrorException> errors = new LinkedList<ValidationErrorException>();
    private static final long serialVersionUID = 1L;
    protected LocalDateTime cDate = LocalDateTime.now();
    private boolean worstErrorStatusIsWarning;
    private boolean worstErrorStatusIsError;
    private String description;
    private EnInstitution validatingInstitution;

    public ValidationItem() {
    }

    public ValidationItem(EnValidationArea validationArea) {
        this.setArea(validationArea);
    }

    public ValidationItem(String description, EnValidationArea validationArea) {
        this(validationArea);
        this.setDescription(description);
    }

    @Deprecated
    public ValidationItem(EnValidationArea validationArea, String errorMessage) {
        this.setArea(validationArea);
        this.addError(new Error(errorMessage));
    }

    public ValidationItem(EnValidationArea validationArea, ValidationErrorException error) {
        this.setArea(validationArea);
        this.addError(error);
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public EnDataStatus getStatus() {
        if (this.worstErrorStatusIsError) {
            return EnDataStatus.ERROR;
        }
        if (this.worstErrorStatusIsWarning) {
            return EnDataStatus.WARNING;
        }
        return EnDataStatus.OK;
    }

    @Override
    public List<String> getErrorMessages() {
        return this.toStringMessages();
    }

    @Override
    public EnValidationArea getArea() {
        return this.area;
    }

    @Override
    public void setArea(EnValidationArea validationArea) {
        this.area = validationArea;
    }

    @Override
    public void addError(ValidationErrorException error) {
        this.errors.add(error);
        if (this.area == null) {
            this.area = error.getArea();
        }
        this.setStatusConsistency(error);
    }

    @Override
    public void addError(ValidationErrorException error, int index) {
        this.errors.add(index, error);
        this.setStatusConsistency(error);
    }

    private void setStatusConsistency(ValidationErrorException error) {
        if (!this.worstErrorStatusIsError && error.getStatus() == EnDataStatus.WARNING) {
            this.worstErrorStatusIsWarning = true;
        } else if (!this.worstErrorStatusIsError && error.getStatus() == EnDataStatus.ERROR) {
            this.worstErrorStatusIsError = true;
        }
    }

    @Override
    public String toXml() {
        return this.toXml(10, true);
    }

    @Override
    public String toXml(boolean addCdate) {
        return this.toXml(10, addCdate);
    }

    @Override
    public String toXml(int messageCount, boolean addCdate) {
        return this.toXml(messageCount, addCdate, null);
    }

    @Override
    public String toXml(int messageCount, boolean addCdate, EnInstitution institutionFunction) {
        String idPart = "";
        String cdatePart = "";
        String checkToolPart = "";
        String descriptionPart = "";
        if (addCdate) {
            cdatePart = "c_date=\"" + this.cDate.format(DateTimeFormatter.ISO_LOCAL_DATE) + "\" ";
        }
        if (this.getId() != -1) {
            idPart = " id=\"" + this.getId() + "\" ";
        }
        if (this.checkTool != null) {
            checkToolPart = " check_tool=\"" + this.checkTool + "\" ";
        }
        if (messageCount < 1) {
            messageCount = 100;
        }
        if (this.description != null && !this.description.equals("")) {
            descriptionPart = " description=\"" + this.description + "\" ";
        }
        if (this.getArea() == null || this.getArea() == EnValidationArea.other) {
            this.setArea(EnValidationArea.Spezifikation);
        }
        String strVItem = "<validation_item V=\"" + (this.getArea().toString() + "\" " + cdatePart + idPart + checkToolPart + descriptionPart).trim() + ">\n";
        strVItem = this.errors.size() > 0 ? strVItem + "<status V=\"" + this.getStatus().name() + "\">\n" + this.getErrors(messageCount) + "\n</status>\n" : strVItem + "<status V=\"" + this.getStatus().name() + "\"/>\n";
        strVItem = strVItem + "</validation_item>\n";
        return strVItem;
    }

    @Override
    public String getLocalizedMessage() {
        return String.join((CharSequence)"\n", this.toStringMessages());
    }

    private String getErrors(Integer messageCount) {
        int index = 0;
        StringBuilder sb = new StringBuilder("");
        for (ValidationErrorException error : this.errors) {
            if (++index <= messageCount) {
                sb.append("<error" + this.addOriginator(error) + ">\n");
                if (error.getErrorType() != null) {
                    sb.append("\t<error_type V=\"" + error.getErrorType().toString() + "\" />\n");
                }
                if (error.getId() > 0) {
                    sb.append("\t<rule_id V=\"" + error.getId() + "\" />\n");
                }
                sb.append("\t<error_message V=\"" + ValidationItem.convertToXML(error.getErrorMessage()) + "\" />\n");
                sb.append("</error>\n");
                continue;
            }
            sb.append("<error>\n\t<error_message V=\"Die Ausgabe wurde nach " + messageCount.toString() + " von " + Integer.valueOf(this.errors.size()).toString() + " Nachrichten abgeschnitten. Wenn sie das gesamte Fehlerprotokoll einsehen m\u00f6chten, kontaktieren Sie bitte den Provider.\" />\n</error>\n");
            break;
        }
        return sb.toString();
    }

    private String addOriginator(ValidationErrorException error) {
        String emptyResult = "";
        if (this.validatingInstitution == null) {
            return emptyResult;
        }
        EnInstitution originator = error.getOriginator(this.validatingInstitution);
        return originator != null ? " originator=\"" + originator.toString() + "\"" : emptyResult;
    }

    private List<String> toStringMessages() {
        ArrayList<String> messages = new ArrayList<String>(this.errors.size());
        for (ValidationErrorException error : this.errors) {
            messages.add(error.getErrorMessage());
        }
        return messages;
    }

    @Override
    public ValidationException toValidationException() {
        return this;
    }

    @Override
    public void setCheckTool(String checkTool) {
        this.checkTool = checkTool;
    }

    @Override
    public String getCheckTool() {
        return this.checkTool;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<ValidationErrorException> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public void setValidatingInstitution(EnInstitution institution) {
        this.validatingInstitution = institution;
    }

    public static synchronized String convertToXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText.replace("&amp;", "&"));
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&#34;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '\n') {
                result.append("&#10;");
            } else if (character == '\r') {
                result.append("&#13;");
            } else if (character == '\t') {
                result.append("&#09;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

