/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.errors.ErrorsFromDB;
import org.iqtig.pruefprogramm.error.InternalException;

public abstract class FileFunctions {
    public static void writeToFile(File file, String text) throws InternalException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && file.isDirectory()) {
            throw new InternalException();
        }
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            out.write(text);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static File getHtmlProtocolLocation(File topOutputFolder) {
        if (topOutputFolder == null) {
            return new File("html").getAbsoluteFile();
        }
        return new File(topOutputFolder, "html");
    }

    public static String getRelativePath(File baseDir, File file) {
        String[] relativeDirectories;
        StringBuilder relativePath = null;
        String basePath = baseDir.getAbsolutePath().replace('\\', '/');
        String filePath = file.getAbsolutePath().replace('\\', '/');
        if (filePath.contains(basePath)) {
            return filePath.replace(basePath, "").replaceAll("^/", "");
        }
        String[] absoluteDirectories = basePath.split("/");
        int length = absoluteDirectories.length < (relativeDirectories = filePath.split("/")).length ? absoluteDirectories.length : relativeDirectories.length;
        int lastCommonRoot = -1;
        int index = 0;
        while (index < length && absoluteDirectories[index].equals(relativeDirectories[index])) {
            lastCommonRoot = index++;
        }
        if (lastCommonRoot != -1) {
            relativePath = new StringBuilder();
            for (index = lastCommonRoot + 1; index < absoluteDirectories.length; ++index) {
                if (absoluteDirectories[index].length() <= 0) continue;
                relativePath.append("../");
            }
            for (index = lastCommonRoot + 1; index < relativeDirectories.length - 1; ++index) {
                relativePath.append(relativeDirectories[index] + "/");
            }
            relativePath.append(relativeDirectories[relativeDirectories.length - 1]);
        }
        return relativePath == null ? filePath : relativePath.toString();
    }

    public static List<File> getInputFiles(File inputFile, boolean recursive) throws InternalException {
        List<File> inputFiles = FileFunctions.getFiles(inputFile, recursive, "xml");
        if (inputFiles.isEmpty()) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.InputFilesNotFound.createInstance());
        }
        return inputFiles;
    }

    public static List<File> getFiles(File dir, boolean recursive, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        if (dir.isFile()) {
            files.add(dir);
        } else if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isFile() && (extension == null || file.getName().toLowerCase().endsWith("." + extension.toLowerCase()))) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory() || !recursive) continue;
                files.addAll(FileFunctions.getFiles(file, recursive, extension));
            }
        }
        return files;
    }
}

