/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml.html;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.iqtig.pruefprogramm.common.FileFunctions;
import org.iqtig.pruefprogramm.common.XmlFunctions;
import org.iqtig.pruefprogramm.config.Provider;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.xml.ValidationErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProtocolWriter {
    public static String getHtml(String fileName, File htmlFile, ValidationErrorHandler errorHandler, File indexFile) {
        return ProtocolWriter.getHtml(fileName, htmlFile, errorHandler.getFatalErrorMessages(), errorHandler.getErrorMessages(), indexFile);
    }

    public static String getHtml(String fileName, File htmlFile, List<String> fatalErrorMessages, List<String> errorMessages, File indexFile) {
        String html = ProtocolWriter.getHtmlDocType() + "\n<html xmlns=\"http://www.w3.org/1999/xhtml\">";
        html = html + ProtocolWriter.getHtmlHead("Schema-Fehler" + (fileName != null ? " fuer " + fileName : ""));
        html = html + "\n\t<body>";
        if (indexFile != null) {
            html = html + "\n\t\t<p><a href=\"" + FileFunctions.getRelativePath(htmlFile.getParentFile(), indexFile) + "\">Zum Index</a></p>";
        }
        html = html + "\n\t\t<p class=\"bold headline\">Beim Einlesen" + (fileName != null ? " von " + fileName : "") + " sind folgende Fehler aufgetreten:</p>";
        if (!fatalErrorMessages.isEmpty()) {
            html = html + "\n\t\t\t<p class=\"bold\">Kritische Fehler:</p>";
            html = html + ProtocolWriter.getHtmlErrorMessages(fatalErrorMessages);
        }
        if (!errorMessages.isEmpty()) {
            html = html + "\n\t\t\t<p class=\"bold\">Fehler:</p>";
            html = html + ProtocolWriter.getHtmlErrorMessages(errorMessages);
        }
        html = html + "\n\t</body>\n</html>";
        return html;
    }

    public static String getHtmlHead(String title) {
        String style = "\n\t\t<style type=\"text/css\">\n\t\t\tth{padding-right:10px;}\n\t\t\t.bold{font-weight: bold;}\n\t\t\t.headline{text-decoration: underline;}\n\t\t\t.no_decoration{font-weight: normal !important;text-decoration: none !important;}\n\t\t</style>";
        return "\n\t<head>\n\t\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" /> \n\t\t<title>" + title + "</title>" + style + "\n\t</head>";
    }

    public static String getHtmlDocType() {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    }

    public static String getHtmlErrorMessages(List<String> errorMessages) {
        String html = "\n\t\t<ul>";
        for (String errorMessage : errorMessages) {
            html = html + "\n\t\t\t<li>" + errorMessage.replace("\u00fc", "ue").replace("\u00e4", "ae").replace("\u00f6", "oe").replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#039;").replace("\\", "&#092;") + "</li>";
        }
        html = html + "\n\t\t</ul>";
        return html;
    }

    public static void writeMiniProtocol(String valType, List<String> errorMessages, int validationId, String guid, File outputFile, Provider provider, String feedbackRange) throws InternalException {
        XmlFunctions.serializeXML(ProtocolWriter.getMiniProtocol(valType, errorMessages, validationId, guid, feedbackRange, provider), outputFile, false);
    }

    public static Document getMiniProtocol(String valType, List<String> errorMessages, int validationId, String guid, String feedbackRange, Provider provider) throws InternalException {
        Document doc = XmlFunctions.getDocument();
        Element rootNode = doc.createElement("root");
        rootNode.setAttribute("xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        rootNode.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        rootNode.setAttribute("xmlns", "urn:gba:sqg");
        rootNode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootNode.setAttribute("container_version", "2.0");
        rootNode.setAttribute("content_version", "1.0");
        doc.appendChild(rootNode);
        Element protocolNode = doc.createElement("protocol");
        protocolNode.setAttribute("xmlns", "urn:gba:sqg");
        if (feedbackRange != null) {
            protocolNode.setAttribute("feedback_range", feedbackRange);
        }
        if (guid != null) {
            protocolNode.setAttribute("document_id", guid);
        }
        rootNode.appendChild(protocolNode);
        protocolNode.appendChild(ProtocolWriter.getValidationProviverNode(valType, errorMessages, validationId, doc, provider));
        Element statusDocumentNode = doc.createElement("status_document");
        statusDocumentNode.setAttribute("xmlns", "urn:gba:sqg");
        statusDocumentNode.setAttribute("V", "ERROR");
        protocolNode.appendChild(statusDocumentNode);
        return doc;
    }

    private static Element getValidationProviverNode(String valType, List<String> errorMessages, int id, Document doc, Provider provider) {
        Element valProviderNode = doc.createElement("validation_provider");
        valProviderNode.setAttribute("xmlns", "urn:gba:sqg");
        valProviderNode.setAttribute("name", provider.name);
        valProviderNode.setAttribute("email", provider.email);
        valProviderNode.setAttribute("fax", provider.fax);
        valProviderNode.setAttribute("phone", provider.phone);
        valProviderNode.setAttribute("address", provider.address);
        valProviderNode.setAttribute("function", provider.function);
        valProviderNode.setAttribute("registration", provider.registration);
        Element valItemNode = doc.createElement("validation_item");
        valItemNode.setAttribute("xmlns", "urn:gba:sqg");
        valProviderNode.appendChild(valItemNode);
        valItemNode.setAttribute("id", Integer.toString(id));
        valItemNode.setAttribute("V", valType);
        valItemNode.setAttribute("c_date", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()));
        Element statusNode = doc.createElement("status");
        statusNode.setAttribute("xmlns", "urn:gba:sqg");
        valItemNode.appendChild(statusNode);
        statusNode.setAttribute("V", "ERROR");
        for (String errorMessage : errorMessages) {
            Element errorNode = doc.createElement("error");
            errorNode.setAttribute("xmlns", "urn:gba:sqg");
            statusNode.appendChild(errorNode);
            Element errorMessageNode = doc.createElement("error_message");
            errorMessageNode.setAttribute("xmlns", "urn:gba:sqg");
            errorNode.appendChild(errorMessageNode);
            errorMessageNode.setAttribute("V", errorMessage);
        }
        return valProviderNode;
    }
}

