/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml.sax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class SaxCopyParser
extends DefaultHandler
implements LexicalHandler {
    private boolean tagClosed = true;
    protected int indent = -1;
    private boolean chars = false;

    protected abstract void write(String var1);

    protected abstract void write(char var1);

    protected abstract void init();

    protected abstract void exit();

    protected abstract void startElementImpl(String var1, String var2, String var3, Attributes var4);

    protected abstract void endElementImpl(String var1, String var2, String var3);

    public synchronized void parse(InputStream inputStream) throws SAXException, IOException {
        try {
            this.init();
            this.parseImpl(inputStream);
        }
        finally {
            this.exit();
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public synchronized void parse(File inputFile) throws SAXException, IOException {
        FileInputStream fis = null;
        try {
            this.init();
            fis = new FileInputStream(inputFile);
            this.parseImpl(fis);
        }
        finally {
            this.exit();
            if (fis != null) {
                fis.close();
            }
        }
    }

    private synchronized void parseImpl(InputStream inputStream) throws SAXException, IOException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setContentHandler(this);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        reader.setErrorHandler(this);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        InputSource is = new InputSource(inputStream);
        is.setEncoding("UTF-8");
        reader.parse(is);
    }

    protected String getAttValue(Attributes attributes, String attName) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).equals(attName)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    @Override
    public void startDocument() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        int i;
        this.chars = false;
        ++this.indent;
        if (!this.tagClosed) {
            this.write('>');
        }
        this.startElementImpl(uri, name, qName, attributes);
        this.write('\n');
        for (i = 0; i < this.indent; ++i) {
            this.write('\t');
        }
        this.write("<" + qName);
        for (i = 0; i < attributes.getLength(); ++i) {
            this.write(" " + attributes.getQName(i) + "=\"" + SaxCopyParser.escapeEntity(attributes.getValue(i)) + "\"");
        }
        this.tagClosed = false;
    }

    protected static String escapeEntity(String entity) {
        return entity.replace("&", "&amp;").replace("\"", "&#34;").replace("<", "&lt;").replace(">", "&gt;");
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (!this.tagClosed) {
            this.write("/>");
        } else {
            if (!this.chars) {
                this.write('\n');
                for (int i = 0; i < this.indent; ++i) {
                    this.write('\t');
                }
            }
            this.write("</");
            this.write(qName);
            this.write(">");
        }
        --this.indent;
        this.tagClosed = true;
        this.chars = false;
        this.endElementImpl(uri, name, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        block6: for (int i = start; i < start + length; ++i) {
            if (this.chars) {
                this.write(ch[i]);
                continue;
            }
            switch (ch[i]) {
                case '\n': {
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case ' ': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    if (!this.tagClosed) {
                        this.write('>');
                        this.tagClosed = true;
                    }
                    this.write(ch[i]);
                    this.chars = true;
                }
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.tagClosed) {
            this.write('>');
            this.tagClosed = true;
        }
        this.write("<!--");
        for (int i = start; i < start + length; ++i) {
            this.write(ch[i]);
        }
        this.write("-->");
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }
}

