/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.common;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.iqtig.pruefprogramm.error.InternalException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlFunctions {
    public static Document getDocument() throws InternalException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", ClassLoader.getSystemClassLoader());
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new InternalException(e);
        }
    }

    public static Element addNode(String name, Node root) {
        return XmlFunctions.addNode(name, root, new String[0]);
    }

    public static Text addTextNode(String text, Node root) {
        Text node = root.getOwnerDocument().createTextNode(text);
        root.appendChild(node);
        return node;
    }

    public static Element addNode(String name, Node root, String[] attributes) {
        Element node;
        Element element = node = root instanceof Document ? ((Document)root).createElement(name) : root.getOwnerDocument().createElement(name);
        if (root instanceof Element && ((Element)root).hasAttribute("xmlns")) {
            node.setAttribute("xmlns", ((Element)root).getAttribute("xmlns"));
        }
        root.appendChild(node);
        for (String att : attributes) {
            node.setAttribute(att.split("==")[0], att.split("==")[1]);
        }
        return node;
    }

    public static Element addNode(String name, Node root, String[] attributes, String textContent) {
        Element node = XmlFunctions.addNode(name, root, attributes);
        node.setTextContent(textContent);
        return node;
    }

    public static Element addNode(String name, Node root, String textContent) {
        return XmlFunctions.addNode(name, root, new String[0], textContent);
    }

    public static void serializeXML(Document document, File file, boolean consoleOutput) throws InternalException {
        try {
            if (file != null) {
                file.getAbsoluteFile().getParentFile().mkdirs();
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DocumentType doctype = document.getDoctype();
            if (doctype != null) {
                transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                transformer.setOutputProperty("doctype-system", doctype.getSystemId());
            }
            DOMSource source = new DOMSource(document);
            if (consoleOutput) {
                StreamResult result = new StreamResult(System.out);
                transformer.transform(source, result);
            }
            if (file != null) {
                StreamResult resultFile = new StreamResult(file);
                transformer.transform(source, resultFile);
            }
        }
        catch (TransformerException e) {
            throw new InternalException(e);
        }
    }

    public static String getXPath(Document doc, String xPath) throws XPathExpressionException, XPathFactoryConfigurationException {
        XPathExpression expr = XPathFactory.newInstance().newXPath().compile(xPath);
        return expr.evaluate(doc);
    }

    public static Document getDocFromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", ClassLoader.getSystemClassLoader());
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        return factory.newDocumentBuilder().parse(file);
    }
}

