/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.sequence;

import java.util.ArrayList;
import java.util.List;
import org.iqtig.pruefprogramm.config.FileConfiguration;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.sequence.HeaderInfoSequence;
import org.iqtig.pruefprogramm.sequence.HtmlSequence;
import org.iqtig.pruefprogramm.sequence.ProtocolSequence;
import org.iqtig.pruefprogramm.sequence.Sequence;
import org.iqtig.pruefprogramm.sequence.XsdSequence;
import org.iqtig.pruefprogramm.sequence.XsdWriteSequence;
import org.iqtig.pruefprogramm.sequence.XslSequence;
import org.iqtig.pruefprogramm.status.FileStatus;

public enum SequenceEnum {
    HTML(new HtmlSequence()),
    XSD(new XsdSequence()),
    XSD_WRITE_VALITEM(new XsdWriteSequence()),
    READ_INFO(new HeaderInfoSequence()),
    SPEZVAL(new XslSequence()),
    PROTOCOL(new ProtocolSequence());

    private final Sequence sequence;

    private SequenceEnum(Sequence sequence) {
        this.sequence = sequence;
    }

    public static SequenceEnum[] getFullSequence() {
        return new SequenceEnum[]{XSD, READ_INFO, XSD_WRITE_VALITEM, SPEZVAL, PROTOCOL, HTML};
    }

    public static SequenceEnum[] getCustomSequence(boolean schemaVal, boolean spezVal) {
        return SequenceEnum.getCustomSequence(schemaVal, schemaVal, spezVal, true, true);
    }

    public static SequenceEnum[] getCustomSequence(boolean schemaVal, boolean writeSchemaVal, boolean spezVal, boolean protocol, boolean htmlProtocol) {
        ArrayList<SequenceEnum> sequenceList = new ArrayList<SequenceEnum>();
        if (schemaVal) {
            sequenceList.add(XSD);
        }
        sequenceList.add(READ_INFO);
        if (schemaVal && writeSchemaVal) {
            sequenceList.add(XSD_WRITE_VALITEM);
        }
        if (spezVal) {
            sequenceList.add(SPEZVAL);
        }
        if (protocol) {
            sequenceList.add(PROTOCOL);
        }
        if (htmlProtocol) {
            sequenceList.add(HTML);
        }
        return sequenceList.toArray(new SequenceEnum[0]);
    }

    private void check(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        this.sequence.check(fileStatus, sysConfig);
    }

    private void run(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        this.sequence.run(fileStatus, sysConfig);
    }

    public static List<FileStatus> run(SequenceEnum[] sequences, List<FileConfiguration> fileConfigs, SystemConfiguration sysConfig) throws InternalException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        for (FileConfiguration fileConfig : fileConfigs) {
            fileStatuses.add(SequenceEnum.run(sequences, fileConfig, sysConfig));
        }
        return fileStatuses;
    }

    public static FileStatus run(SequenceEnum[] sequences, FileConfiguration fileConfig, SystemConfiguration sysConfig) throws InternalException {
        FileStatus fileStatus = new FileStatus(fileConfig);
        for (SequenceEnum sequence : sequences) {
            sequence.check(fileStatus, sysConfig);
        }
        for (SequenceEnum sequence : sequences) {
            sequence.run(fileStatus, sysConfig);
        }
        return fileStatus;
    }
}

