/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.xml.protocol.Case;
import org.iqtig.pruefprogramm.xml.protocol.Error;
import org.iqtig.pruefprogramm.xml.protocol.HeaderProtocol;
import org.iqtig.pruefprogramm.xml.protocol.Protocol;
import org.iqtig.pruefprogramm.xml.protocol.ProtocolInformation;
import org.iqtig.pruefprogramm.xml.protocol.ValidationItem;
import org.iqtig.pruefprogramm.xml.protocol.ValidationProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ProtocolReader
extends DefaultHandler {
    private List<Case> cases = new ArrayList<Case>();
    private HeaderProtocol headerProtocol = new HeaderProtocol();
    private Case currentCase = null;
    private Protocol currentProtocol;
    private Error currentError = null;
    private ValidationItem currentValItem = null;
    private ValidationProvider currentValProv = null;
    private String statusDocument = null;
    private String guid = null;

    private ProtocolReader() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        if (name.equals("status_document")) {
            this.statusDocument = this.getAttValue(attributes, "V");
        } else if (this.currentCase == null && this.guid == null && name.equals("id")) {
            this.guid = this.getAttValue(attributes, "V");
        } else if (!name.equals("protocol")) {
            if (name.equals("case")) {
                this.currentCase = new Case();
            } else if (name.equals("patient")) {
                this.currentCase.setHasPatientTag(true);
            } else if (name.equals("error")) {
                this.currentError = new Error();
            } else if (name.equals("validation_item")) {
                this.currentProtocol = this.currentCase != null ? this.currentCase.getProtocol() : this.currentValProv;
                this.currentValItem = new ValidationItem(this.getAttValue(attributes, "id"), this.getAttValue(attributes, "c_date"), this.getAttValue(attributes, "V"), this.getAttValue(attributes, "check_tool"));
            } else if (name.equals("validation_provider")) {
                String address = this.getAttValue(attributes, "address");
                String email = this.getAttValue(attributes, "email");
                String fax = this.getAttValue(attributes, "fax");
                String function = this.getAttValue(attributes, "function");
                String valProvName = this.getAttValue(attributes, "name");
                String phone = this.getAttValue(attributes, "phone");
                String registration = this.getAttValue(attributes, "registration");
                this.currentValProv = new ValidationProvider(address, email, fax, function, valProvName, phone, registration);
            }
        }
        if (this.currentError != null) {
            if (name.equals("error_type")) {
                this.currentError.setErrorType(this.getAttValue(attributes, "V"));
            } else if (name.equals("rule_id")) {
                this.currentError.setRuleId(this.getAttValue(attributes, "V"));
            } else if (name.equals("rule_type")) {
                this.currentError.setRuleType(this.getAttValue(attributes, "V"));
            } else if (name.equals("list")) {
                this.currentError.setList(this.getAttValue(attributes, "V"));
            } else if (name.equals("error_message")) {
                this.currentError.setErrorMessage(this.getAttValue(attributes, "V"));
            }
        }
        if (this.currentCase != null) {
            if (name.equals("case_admin")) {
                this.currentCase.setCaseAdminOpen(true);
            } else if (name.equals("status_case")) {
                this.currentCase.setStatus(this.getAttValue(attributes, "V"));
            }
            if (this.currentCase.isCaseAdminOpen()) {
                if (name.equals("id")) {
                    this.currentCase.setId(this.getAttValue(attributes, "V"));
                } else if (name.equals("version")) {
                    this.currentCase.setVersion(this.getAttValue(attributes, "V"));
                } else if (name.equals("action")) {
                    this.currentCase.setAction(this.getAttValue(attributes, "V"));
                } else if (name.equals("module")) {
                    this.currentCase.setModule(this.getAttValue(attributes, "V"));
                }
            }
        }
        if (this.currentValItem != null && name.equals("status")) {
            this.currentValItem.setStatus(this.getAttValue(attributes, "V"));
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXTerminatorException {
        if (name.equals("protocol")) {
            this.currentProtocol = null;
        } else if (name.equals("case")) {
            this.cases.add(this.currentCase);
            this.currentCase = null;
        } else if (name.equals("validation_item")) {
            this.currentProtocol.addValItem(this.currentValItem);
            this.currentValItem = null;
        } else if (name.equals("error")) {
            this.currentValItem.addError(this.currentError);
            this.currentError = null;
        } else if (name.equals("validation_provider")) {
            this.headerProtocol.addvalProv(this.currentValProv);
            this.currentValProv = null;
        }
        if (this.currentError != null) {
            // empty if block
        }
        if (this.currentValItem != null) {
            // empty if block
        }
        if (this.currentCase != null && name.equals("case_admin")) {
            this.currentCase.setCaseAdminOpen(false);
        }
    }

    public static ProtocolInformation getProtocolInformation(File file) throws InternalException {
        try {
            return new ProtocolReader().parse(file);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ProtocolInformation parse(File inputFile) throws IOException, SAXException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(inputFile);
            ProtocolInformation protocolInformation = this.parse(fis);
            return protocolInformation;
        }
    }

    private synchronized ProtocolInformation parse(InputStream inputStream) throws IOException, SAXException {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xr.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xr.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xr.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xr.parse(new InputSource(inputStream));
        }
        catch (SAXTerminatorException sAXTerminatorException) {
        }
        finally {
            inputStream.close();
        }
        return new ProtocolInformation(this.statusDocument, this.guid, this.headerProtocol.getValProvs(), this.cases);
    }

    private String getAttValue(Attributes attributes, String attName) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).equals(attName)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    public static class SAXTerminatorException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        @Override
        public void printStackTrace() {
        }
    }
}

