/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml.sax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.iqtig.pruefprogramm.error.InternalException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HeaderReader
extends DefaultHandler {
    private String id = null;
    private String setId = null;
    private String originationDttm = null;
    private String modificationDttm = null;
    private String specification = null;
    private String dataFlow = null;
    private String dataTarget = null;
    private String statusDocument = null;
    private int highestValId = 0;
    private Map<Integer, String> checkToolMap = new HashMap<Integer, String>();

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        if (name.equals("specifikation")) {
            this.specification = this.getAttValue(attributes, "V");
        } else if (name.equals("specification")) {
            this.specification = this.getAttValue(attributes, "V");
        } else if (name.equals("data_flow")) {
            this.dataFlow = this.getAttValue(attributes, "V");
        } else if (name.equals("data_target")) {
            this.dataTarget = this.getAttValue(attributes, "V");
        } else if (name.equals("id")) {
            this.id = this.getAttValue(attributes, "V");
        } else if (name.equals("set_id")) {
            this.setId = this.getAttValue(attributes, "V");
        } else if (name.equals("origination_dttm")) {
            this.originationDttm = this.getAttValue(attributes, "V");
        } else if (name.equals("modification_dttm")) {
            this.modificationDttm = this.getAttValue(attributes, "V");
        } else if (name.equals("status_document")) {
            this.statusDocument = this.getAttValue(attributes, "V");
        } else if (name.equals("validation_item")) {
            try {
                int currValId = new Integer(this.getAttValue(attributes, "id"));
                if (currValId > this.highestValId) {
                    this.highestValId = currValId;
                }
                this.checkToolMap.put(currValId, this.getAttValue(attributes, "check_tool"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXTerminatorException {
        if (name.equals("header")) {
            throw new SAXTerminatorException();
        }
    }

    public static HeaderInformation getHeaderInformation(File inputfile) throws InternalException {
        try {
            return new HeaderReader().parse(inputfile);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public static HeaderInformation getHeaderInformation(InputStream ins) throws InternalException {
        try {
            return new HeaderReader().parse(ins);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    private synchronized HeaderInformation parse(File inputFile) throws IOException {
        FileInputStream ins = new FileInputStream(inputFile);
        return this.parse(ins);
    }

    private synchronized HeaderInformation parse(InputStream inputStream) throws IOException {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xr.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xr.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xr.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xr.parse(new InputSource(inputStream));
        }
        catch (SAXTerminatorException sAXTerminatorException) {
        }
        catch (SAXException sAXException) {
        }
        finally {
            inputStream.close();
        }
        return new HeaderInformation(this.specification, this.dataFlow, this.dataTarget, this.id, this.setId, this.originationDttm, this.modificationDttm, this.statusDocument, this.highestValId, this.checkToolMap);
    }

    private String getAttValue(Attributes attributes, String attName) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).equals(attName)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    public static class SAXTerminatorException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        @Override
        public void printStackTrace() {
        }
    }

    public static class HeaderInformation {
        public final String id;
        public final String setId;
        public final String originationDttm;
        public final String modificationDttm;
        public final String specification;
        public final String dataFlow;
        public final String dataTarget;
        public final String statusDocument;
        public final int highestValId;
        public final Map<Integer, String> checkToolMap;

        public HeaderInformation(String specification, String dataFlow, String dataTarget, String id, String setId, String originationDttm, String modificationDttm, String statusDocument, int highestValId, Map<Integer, String> checkToolMap) {
            this.specification = specification;
            this.dataFlow = dataFlow;
            this.dataTarget = dataTarget;
            this.id = id;
            this.setId = setId;
            this.originationDttm = originationDttm;
            this.modificationDttm = modificationDttm;
            this.statusDocument = statusDocument;
            this.highestValId = highestValId;
            this.checkToolMap = checkToolMap;
        }
    }
}

