/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.iqtig.pruefprogramm.logging.Logger;

public class GUI
extends Logger {
    private final JTextArea textArea = new JTextArea();

    public void start(final Runnable runnable, final String name, final String version) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.textArea.setEditable(false);
                JFrame frame = new JFrame(name + " v" + version);
                frame.setSize(800, 600);
                frame.setLayout(new BoxLayout(frame.getContentPane(), 1));
                URL image = GUI.class.getClassLoader().getResource("logo/IQTIG_Logo_48.png");
                frame.setIconImage(Toolkit.getDefaultToolkit().getImage(image));
                JButton button = new JButton("Pruefvorgang starten");
                button.setAlignmentX(0.5f);
                button.addActionListener(new ButtonListener(button, runnable));
                frame.add(button);
                JScrollPane scrollPane = new JScrollPane(GUI.this.textArea);
                frame.add(scrollPane);
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    @Override
    public void out(String out) {
        this.textArea.append(out);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    @Override
    public void err(String out) {
        this.out(out);
    }

    public static class ButtonListener
    implements ActionListener {
        private final Runnable runnable;
        private final JButton button;

        ButtonListener(JButton button, Runnable runnable) {
            this.button = button;
            this.runnable = runnable;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.button.setEnabled(false);
            new Thread(){

                @Override
                public void run() {
                    runnable.run();
                    button.setEnabled(true);
                }
            }.start();
        }
    }
}

