/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.common;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.pruefprogramm.common.FileFunctions;
import org.iqtig.pruefprogramm.common.XmlFunctions;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.status.FileStatus;
import org.iqtig.pruefprogramm.xml.protocol.Case;
import org.iqtig.pruefprogramm.xml.protocol.Error;
import org.iqtig.pruefprogramm.xml.protocol.ProtocolInformation;
import org.iqtig.pruefprogramm.xml.protocol.ProtocolReader;
import org.iqtig.pruefprogramm.xml.protocol.ValidationItem;
import org.iqtig.pruefprogramm.xml.protocol.ValidationProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlFunctions {
    public static void printSpezValProtocol(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        Document doc = XmlFunctions.getDocument();
        doc.appendChild(doc.getImplementation().createDocumentType("html", "-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"));
        Element htmlElement = doc.createElement("html");
        htmlElement.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        doc.appendChild(htmlElement);
        HtmlFunctions.addHtmlHead(htmlElement, "Validationsprotokoll: " + (fileStatus.getGuid() != null ? "GUID " + fileStatus.getGuid().replaceAll("^\\{|\\}$", "") : "Datei " + fileStatus.getOriginalLocation().getName()), true, true);
        File inputFile = fileStatus.getFileConfig().protocolFile;
        if (inputFile == null || !inputFile.isFile()) {
            inputFile = fileStatus.getCurrentLocation();
        }
        ProtocolInformation protocolInformation = ProtocolReader.getProtocolInformation(inputFile);
        Element bodyElement = XmlFunctions.addNode("body", (Node)htmlElement, new String[]{"onload==init()"});
        Element divElement = XmlFunctions.addNode("div", (Node)bodyElement, new String[]{"id==content"});
        Element statusDiv = XmlFunctions.addNode("div", (Node)divElement, new String[]{"id==processable", "class==" + HtmlFunctions.getDocStatusClass(protocolInformation)});
        XmlFunctions.addNode("span", (Node)statusDiv, "Dokument-Status:");
        XmlFunctions.addTextNode(" " + protocolInformation.getStatusDocument(), statusDiv);
        XmlFunctions.addNode("div", divElement, new String[]{"id==options"}, "\u00bb Details ein/aus");
        for (ValidationProvider valProv : HtmlFunctions.sortByRelevance(protocolInformation.getValProvs(), sysConfig)) {
            HtmlFunctions.addValProvider(valProv, protocolInformation, fileStatus, divElement);
        }
        XmlFunctions.addNode("br", divElement);
        XmlFunctions.addNode("span", divElement, new String[]{"id==notice"}, "Details einzelner Validation-Items k\u00f6nnen duch Klicken auf das jeweilige Element angezeigt oder ausgeblendet werden.");
        XmlFunctions.serializeXML(doc, fileStatus.getFileConfig().htmlFile, false);
    }

    private static String getDocStatusClass(ProtocolInformation protocolInformation) {
        return protocolInformation.getStatusDocument().toLowerCase() + "Doc";
    }

    public static List<ValidationItem> sortByRelevance(List<ValidationItem> valItems, List<String> currentValidationIds) {
        ArrayList<ValidationItem> valItemsSorted = new ArrayList<ValidationItem>();
        for (ValidationItem valItem : valItems) {
            if (currentValidationIds.contains(valItem.id)) {
                valItemsSorted.add(0, valItem);
                continue;
            }
            valItemsSorted.add(valItem);
        }
        return valItemsSorted;
    }

    public static List<ValidationProvider> sortByRelevance(List<ValidationProvider> valProvs, SystemConfiguration sysConfig) {
        ArrayList<ValidationProvider> valProvsSorted = new ArrayList<ValidationProvider>();
        for (ValidationProvider valProv : valProvs) {
            if (valProv.registration != null && valProv.registration.equals(sysConfig.provider.registration)) {
                valProvsSorted.add(0, valProv);
                continue;
            }
            valProvsSorted.add(valProv);
        }
        return valProvsSorted;
    }

    public static void addValItem(ValidationItem valItem, List<Case> cases, Element root, boolean highlight) {
        boolean hasGlobalErrors;
        Element trElement = XmlFunctions.addNode("tr", (Node)root, new String[]{"onclick==toggle(this)", highlight ? "class==hl_bg " + valItem.getStatus().toLowerCase() : "class==hl_bg " + valItem.getStatus().toLowerCase()});
        XmlFunctions.addNode("td", (Node)trElement, "Validierung " + valItem.id);
        XmlFunctions.addNode("td", (Node)trElement, valItem.date);
        XmlFunctions.addNode("td", (Node)trElement, valItem.value);
        XmlFunctions.addNode("td", (Node)trElement, valItem.getStatus());
        boolean hasErrors = hasGlobalErrors = !valItem.getErrors().isEmpty();
        Element trElement2 = XmlFunctions.addNode("tr", root);
        Element tdElement = XmlFunctions.addNode("td", (Node)trElement2, new String[]{"colspan==4"});
        if (!valItem.getErrors().isEmpty()) {
            Element divElement = XmlFunctions.addNode("div", (Node)tdElement, new String[]{"class==detail"});
            Element ulElement = XmlFunctions.addNode("ul", (Node)divElement, new String[]{"class==document"});
            for (Error error : valItem.getErrors()) {
                HtmlFunctions.addError(error, ulElement);
            }
        }
        Element hrElement = null;
        for (Case c : cases) {
            for (ValidationItem localValItem : c.getValItems()) {
                if (!localValItem.id.equals(valItem.id) || localValItem.getErrors().isEmpty()) continue;
                if (hasGlobalErrors && hrElement == null) {
                    hrElement = XmlFunctions.addNode("hr", tdElement);
                }
                Element divElement = XmlFunctions.addNode("div", (Node)tdElement, new String[]{"class==detail"});
                Element pElement = XmlFunctions.addNode("p", divElement);
                XmlFunctions.addTextNode("Vorgang ", pElement);
                XmlFunctions.addNode("span", pElement, new String[]{"class==priority-1"}, c.getId());
                XmlFunctions.addTextNode(" (Status: ", pElement);
                XmlFunctions.addNode("span", pElement, new String[]{"class==priority-2"}, c.getStatus());
                XmlFunctions.addTextNode(")", pElement);
                Element ulElement = XmlFunctions.addNode("ul", divElement);
                for (Error error : localValItem.getErrors()) {
                    HtmlFunctions.addError(error, ulElement);
                }
                if (hasErrors) continue;
                hasErrors = true;
            }
        }
        if (!hasErrors) {
            XmlFunctions.addNode("div", tdElement, new String[]{"class==detail"}, "Validierung erfolgreich");
        }
    }

    public static void addError(Error error, Element root) {
        Element liElement = XmlFunctions.addNode("li", root);
        XmlFunctions.addNode("span", liElement, new String[]{"class==bold"}, error.getErrorMessage());
        XmlFunctions.addNode("br", liElement);
        if (error.getErrorType() != null) {
            XmlFunctions.addTextNode("Art: ", liElement);
            XmlFunctions.addNode("span", liElement, new String[]{"class==bold"}, error.getErrorType());
        }
        if (error.getRuleId() != null || error.getRuleType() != null) {
            XmlFunctions.addTextNode(" (", liElement);
        }
        if (error.getRuleId() != null) {
            XmlFunctions.addTextNode("Regel-ID: ", liElement);
            XmlFunctions.addNode("span", liElement, new String[]{"class==bold"}, error.getRuleId());
            if (error.getRuleType() != null) {
                XmlFunctions.addTextNode(" | ", liElement);
            }
        }
        if (error.getRuleType() != null) {
            XmlFunctions.addTextNode("Regel-Typ: ", liElement);
            XmlFunctions.addNode("span", liElement, new String[]{"class==bold"}, error.getRuleType());
        }
        if (error.getRuleId() != null || error.getRuleType() != null) {
            XmlFunctions.addTextNode(")", liElement);
        }
    }

    public static void addValProvider(ValidationProvider valProv, ProtocolInformation protocolInformation, FileStatus fileStatus, Element root) {
        Element tableElement = XmlFunctions.addNode("table", root);
        Element trElement = XmlFunctions.addNode("tr", tableElement);
        Element thElement = XmlFunctions.addNode("th", (Node)trElement, new String[]{"colspan==2"});
        XmlFunctions.addNode("span", thElement, new String[]{"class==priority-1"}, valProv.function != null ? valProv.function : "Unbekannte Funktion");
        XmlFunctions.addNode("br", thElement);
        XmlFunctions.addNode("span", thElement, new String[]{"class==priority-1"}, valProv.name != null ? valProv.name : "Unbekannter Provider");
        if (valProv.registration != null) {
            XmlFunctions.addTextNode(" (" + valProv.registration + ')', thElement);
        }
        XmlFunctions.addNode("br", thElement);
        XmlFunctions.addTextNode(valProv.address, thElement);
        thElement = XmlFunctions.addNode("th", (Node)trElement, new String[]{"colspan==2"});
        XmlFunctions.addTextNode("tel: " + (valProv.phone != null ? valProv.phone : "-"), thElement);
        XmlFunctions.addNode("br", thElement);
        XmlFunctions.addTextNode("fax: " + (valProv.fax != null ? valProv.fax : "-"), thElement);
        XmlFunctions.addNode("br", thElement);
        XmlFunctions.addTextNode("e-mail: " + (valProv.email != null ? valProv.email : "-"), thElement);
        for (ValidationItem valItem : HtmlFunctions.sortByRelevance(valProv.getValItems(), fileStatus.getCurrentValidationIds())) {
            HtmlFunctions.addValItem(valItem, protocolInformation.getCases(), tableElement, fileStatus.getCurrentValidationIds().contains(valItem.id));
        }
    }

    private static void addHtmlHead(Element root, String title, boolean css, boolean javascript) {
        Element headElement = XmlFunctions.addNode("head", root);
        XmlFunctions.addNode("title", (Node)headElement, title);
        XmlFunctions.addNode("meta", (Node)headElement, new String[]{"http-equiv==Content-Type", "content==text/html;charset=utf-8"});
        XmlFunctions.addNode("meta", (Node)headElement, new String[]{"http-equiv==X-UA-Compatible", "content==IE=7"});
        if (css) {
            XmlFunctions.addNode("style", headElement, new String[]{"type==text/css"}, " body{font-family:sans-serif;font-size:13px}table{border-collapse:collapse;margin-top:24px;width:100%}table,#processable,#docStatus{border:1px solid #999}.hl_bg th:first-child,.hl_bg td:first-child{border-left:1px solid #999}.hl_bg th:last-child,.hl_bg td:last-child{border-right:1px solid #999}.hl_bg{background-color:#efefef}.hl_bg td{width:200px;border:1px solid #999;color:#000}td{padding:2px 10px 2px 10px}th{font-weight:normal;text-align:left;border:1px solid #999}th:first-child{border-right-style:dotted}th:last-child{border-left-style:dotted}#docStatus,th{background-color:#ddd}th{padding:8px 10px}.priority-1{font-weight:bold}.priority-2{font-weight:normal;font-style:italic}.headline{text-decoration:none}.no_decoration{font-weight:normal!important;text-decoration:none!important}.error td:last-child,.warning td:last-child,.ok td:last-child{color:#fff}.errorDoc,.error td:last-child{background-color:#ec3f3f}.warning td:last-child{background-color:#ff8d42}.warningDoc{background-color:#ff8d42}.okDoc,.ok td:last-child{background-color:#4bbc4b}.errorText{color:red}.warningText{color:orange}.okText{color:green}#content{display:inline-block;width:900px}table,#processable,#docStatus{box-shadow:2px 2px 4px #bbb}#processable{color:#fff}#processable,#docStatus{margin-bottom:15px;padding:6px}#processable span,#docStatus span{display:inline-block;width:120px}.clear{clear:both}hr{border:0;border-top:1px solid #bbb}#options{display:none;cursor:pointer;text-align:right}div.detail{border:1px solid #bbb;background-color:#efefef;box-shadow:2px 2px 4px #ccc;padding:5px}div.detail,tr td hr{margin:15px 10px}ul li{padding-top:4px;padding-bottom:4px}div.detail p{margin:0;padding:0;background-color:inherit;border-bottom:1px solid #bbb;padding:4px}.regular{font-weight:normal}#notice{display:none;font-size:11px;color:#666}.error td,.warning td,.ok td{color:expression((this.parentNode.lastChild == this)? \"#fff\":\"inherit\")}.error td{background-color:expression((this.parentNode.lastChild == this)? \"#EC3F3F\":\"inherit\")}.warning td{background-color:expression((this.parentNode.lastChild == this)? \"#FF8D42\":\"inherit\")}.ok td{background-color:expression((this.parentNode.lastChild == this)? \"#4BBC4B\":\"inherit\")}tr td ul.document li{padding-top:expression((this.parentNode.firstChild == this)? \"10px\":\"inherit\")}tr td ul li{padding-bottom:expression((this.parentNode.lastChild == this)? \"10px\":\"inherit\")}th{border-right-style:expression((this.parentNode.firstChild == this) ? \"dotted\":\"inherit\"}th{border-right-style:expression((this.parentNode.lastChild == this) ? \"dotted\":\"inherit\"}");
        }
        if (javascript) {
            XmlFunctions.addNode("script", headElement, new String[]{"type==text/javascript"}, "var allOpen=false;document.getElementsByClassName=function(e){var a=this.all||this.getElementsByTagName(\"*\");var d=new Array();var c=new RegExp(\"(?:^|\\\\s)\"+e+\"(?:\\\\s|$)\");for(b in a){if(c.test(a[b].className)){d[d.length]=a[b]}}return d};function init(){var c=document.getElementsByClassName(\"hl_bg\");for(b in c){var d=c[b];d.style.cursor=\"pointer\";toggle(d)}var a=document.getElementById(\"options\");a.style.display=\"block\";document.getElementById(\"notice\").style.display=\"block\";bindEvent(a,\"click\",function(){toggleAll()},false)}function toggle(b){var a=getSiblingRow(b);toggleContentRow(a)}function toggleAll(){var c=document.getElementsByClassName(\"hl_bg\");for(b in c){var a=getSiblingRow(c[b]);if(allOpen){a.style.display=\"none\"}else{crossBrowser_showTableRow(a)}}allOpen=!allOpen}function bindEvent(c,a,b){if(c.addEventListener){c.addEventListener(a,b,false)}else{if(c.attachEvent){c.attachEvent(\"on\"+a,b)}}}function getSiblingRow(b){var a=b.nextSibling;while(a){if(a.nodeType==1){return a;break}a=a.nextSibling}return null}function toggleContentRow(a){if(a.style.display!=\"none\"){a.style.display=\"none\"}else{crossBrowser_showTableRow(a)}}function crossBrowser_showTableRow(b){try{b.style.display=\"table-row\"}catch(a){b.style.display=\"\"}};");
        }
    }

    public static void printIndexHtml(List<FileStatus> files, File htmlProtocolLocation) throws InternalException {
        Document doc = XmlFunctions.getDocument();
        doc.appendChild(doc.getImplementation().createDocumentType("html", "-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"));
        Element htmlElement = XmlFunctions.addNode("html", (Node)doc, new String[]{"xmlns==http://www.w3.org/1999/xhtml"});
        HtmlFunctions.addHtmlHead(htmlElement, "Index validierter Dateien", true, false);
        Element bodyElement = XmlFunctions.addNode("body", htmlElement);
        Element divElement = XmlFunctions.addNode("div", (Node)bodyElement, new String[]{"id==content"});
        Element tableElement = XmlFunctions.addNode("table", divElement);
        for (FileStatus fileStatus : files) {
            File inputFile = fileStatus.getFileConfig().protocolFile;
            if (inputFile == null || !inputFile.isFile()) {
                inputFile = fileStatus.getCurrentLocation();
            }
            ProtocolInformation protocolInformation = ProtocolReader.getProtocolInformation(inputFile);
            Element trElement = XmlFunctions.addNode("tr", (Node)tableElement, new String[]{"class==hl_bg " + protocolInformation.getStatusDocument().toLowerCase()});
            Element tdElement = XmlFunctions.addNode("td", (Node)trElement, new String[]{"class==filename"});
            HtmlFunctions.appendAssociatedFileLink(htmlProtocolLocation, fileStatus.getOriginalLocation().getName(), fileStatus.getFileConfig().htmlFile, tdElement);
            XmlFunctions.addNode("td", (Node)trElement, fileStatus.getGuid() != null ? fileStatus.getGuid().replaceAll("^\\{|\\}$", "") : "");
            XmlFunctions.addNode("td", (Node)trElement, protocolInformation.getStatusDocument());
        }
        XmlFunctions.serializeXML(doc, new File(htmlProtocolLocation, "index.html"), false);
    }

    public static void appendAssociatedFileLink(File errorProtocolLocation, String title, File file, Element root) {
        if (file == null) {
            return;
        }
        String relativeFilePath = FileFunctions.getRelativePath(errorProtocolLocation, file);
        if (relativeFilePath.matches("^[^\\/\\\\]\\:.*$")) {
            relativeFilePath = "file:///" + relativeFilePath;
        }
        XmlFunctions.addNode("a", root, new String[]{"href==" + relativeFilePath}, title);
    }
}

