/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.pruefprogramm.common.FileFunctions;

public class FileConfiguration {
    public final File inputFile;
    public final File outputFile;
    public final File protocolFile;
    public final File htmlFile;

    public FileConfiguration(File inputFile, File outputFile, File protocolFile, File htmlFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.protocolFile = protocolFile;
        this.htmlFile = htmlFile;
    }

    public FileConfiguration(File inputFile, String outputPath, String inputPath) {
        File inputFolder = this.getInputFolder(inputPath).getAbsoluteFile();
        File outputFolder = new File(outputPath).getAbsoluteFile();
        String relOutputPath = FileFunctions.getRelativePath(inputFolder, inputFile.getAbsoluteFile().getParentFile());
        this.inputFile = inputFile;
        this.outputFile = new File(new File(new File(outputFolder, "files"), relOutputPath), inputFile.getName());
        this.protocolFile = new File(new File(new File(outputFolder, "protocol"), relOutputPath), inputFile.getName());
        this.htmlFile = new File(new File(new File(FileFunctions.getHtmlProtocolLocation(outputFolder), "files"), relOutputPath), inputFile.getName() + ".html");
    }

    public static List<FileConfiguration> getFileConfigs(List<File> inputFiles, String outputPath, String inputPath) {
        ArrayList<FileConfiguration> fileConfigs = new ArrayList<FileConfiguration>();
        for (File file : inputFiles) {
            fileConfigs.add(new FileConfiguration(file, outputPath, inputPath));
        }
        return fileConfigs;
    }

    private File getInputFolder(String inputPath) {
        File inputFile = new File(inputPath);
        if (inputFile.isFile()) {
            return inputFile.getParentFile();
        }
        return inputFile;
    }
}

