/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.config;

import java.io.File;
import java.util.ArrayList;
import org.iqtig.pruefprogramm.common.FileFunctions;
import org.iqtig.pruefprogramm.config.Provider;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.logging.ConsoleLogger;
import org.iqtig.pruefprogramm.logging.Logger;

public class SystemConfiguration {
    public final File xslFile;
    public final File xsdFile;
    public final Provider provider;
    private Logger logger;
    public final boolean gui;
    public final boolean doSpezVal;
    public final boolean doSchemaVal;
    private File htmlProtocolLocation = null;

    public SystemConfiguration(String xslPath, String xsdPath, Provider provider, Boolean gui, boolean doSpezVal, boolean doSchemaVal) throws InternalException {
        this(SystemConfiguration.getXslFile(xslPath), SystemConfiguration.getXsdFile(xsdPath), provider, gui, doSpezVal, doSchemaVal);
    }

    public SystemConfiguration(File xslFile, File xsdFile, Provider provider, Boolean gui, boolean doSpezVal, boolean doSchemaVal) throws InternalException {
        this.xslFile = xslFile;
        this.xsdFile = xsdFile;
        this.provider = provider != null ? provider : new Provider();
        this.setLogger(new ConsoleLogger());
        this.gui = gui != null ? gui : false;
        this.doSpezVal = doSpezVal;
        this.doSchemaVal = doSchemaVal;
    }

    public SystemConfiguration(File xslFile, File xsdFile, Provider provider) throws InternalException {
        this(xslFile, xsdFile, provider, (Boolean)false, true, true);
    }

    private static File getSingeFileOrNull(String path, String ... extensions) {
        if (path == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String extension : extensions) {
            for (File file : FileFunctions.getFiles(new File(path), false, extension)) {
                if (files.contains(file)) continue;
                files.add(file);
            }
        }
        if (files.size() != 1) {
            return null;
        }
        return (File)files.get(0);
    }

    public static File getXslFile(String xslPath) {
        return SystemConfiguration.getSingeFileOrNull(xslPath, "aqxsl", "xsl");
    }

    public static File getXsdFile(String xsdPath) {
        return SystemConfiguration.getSingeFileOrNull(xsdPath, "xsd");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getHtmlProtocolLocation() {
        return this.htmlProtocolLocation;
    }

    public void setHtmlProtocolLocation(File htmlProtocolLocation) {
        this.htmlProtocolLocation = htmlProtocolLocation;
    }
}

