/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.pruefprogramm.config.FileConfiguration;
import org.iqtig.pruefprogramm.xml.sax.HeaderReader;

public class FileStatus {
    private File currentLocation;
    private Class lastSequence;
    private boolean corrupted = false;
    private final List<String> schemaWarnings;
    private final List<String> headerSchemaErrors;
    private final List<String> schemaErrors;
    private HeaderReader.HeaderInformation headerInformation = null;
    private final List<String> currentValidationIds;
    final FileConfiguration fileConfig;

    public FileStatus(FileConfiguration fileConfig) {
        this.currentLocation = fileConfig.inputFile;
        this.schemaWarnings = new ArrayList<String>();
        this.schemaErrors = new ArrayList<String>();
        this.headerSchemaErrors = new ArrayList<String>();
        this.lastSequence = null;
        this.currentValidationIds = new ArrayList<String>();
        this.fileConfig = fileConfig;
    }

    public void setCurrentLocation(File currentFile, Class module) {
        this.currentLocation = currentFile;
        this.lastSequence = module;
    }

    public File getCurrentLocation() {
        return this.currentLocation;
    }

    public File getOriginalLocation() {
        return this.fileConfig.inputFile;
    }

    public void addSchemaWarnings(List<String> warnings) {
        for (String warning : warnings) {
            this.addSchemaWarning(warning);
        }
    }

    public void addSchemaWarning(String warning) {
        this.schemaWarnings.add(warning);
    }

    public void addSchemaError(String error) {
        this.schemaErrors.add(error);
    }

    public void addHeaderSchemaError(String error) {
        this.headerSchemaErrors.add(error);
    }

    public void addSchemaErrors(List<String> errors) {
        for (String error : errors) {
            this.addSchemaError(error);
        }
    }

    public void addHeaderSchemaErrors(List<String> errors) {
        for (String error : errors) {
            this.addHeaderSchemaError(error);
        }
    }

    public List<String> getHeaderSchemaErrors() {
        return this.headerSchemaErrors;
    }

    public boolean hasHeaderSchemaErrors() {
        return !this.headerSchemaErrors.isEmpty();
    }

    public List<String> getSchemaErrors() {
        return this.schemaErrors;
    }

    public List<String> getSchemaWarnings() {
        return this.schemaWarnings;
    }

    private List<List<String>> getSortedMessages(List<String> messages) {
        ArrayList<List<String>> sortedMessages = new ArrayList<List<String>>();
        for (String error : messages) {
            boolean isNew = true;
            for (List list : sortedMessages) {
                if (!((String)list.get(0)).replaceFirst("^Zeile \\d+:", "").equals(error.replaceFirst("^Zeile \\d+:", ""))) continue;
                list.add(error);
                isNew = false;
            }
            if (!isNew) continue;
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(error);
            sortedMessages.add(errorList);
        }
        return sortedMessages;
    }

    public List<String> getSchemaWarnings(int limit) {
        return this.getSortedMessages(this.getSortedMessages(this.schemaWarnings), limit);
    }

    public List<String> getSchemaErrors(int limit) {
        return this.getSortedMessages(this.getSortedMessages(this.schemaErrors), limit);
    }

    private List<String> getSortedMessages(List<List<String>> sortedMessages, int limit) {
        ArrayList<String> messageArray = new ArrayList<String>();
        for (List<String> messages : sortedMessages) {
            for (int i = 0; i < limit && i < messages.size(); ++i) {
                messageArray.add(messages.get(i));
            }
            if (messages.size() <= limit) continue;
            messageArray.add(messages.get(0).replaceFirst("^Zeile \\d+", messages.size() - limit + "x"));
        }
        return messageArray;
    }

    public static String getOutputDirStructure(File originalFile, File inputFolder) {
        if (inputFolder.isFile()) {
            return "";
        }
        String outputPath = originalFile.getParentFile().getAbsolutePath().replace(inputFolder.getAbsolutePath(), "");
        return outputPath;
    }

    public void setCorrupted(boolean corrupted) {
        this.corrupted = corrupted;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public static boolean areAllCorrupted(List<FileStatus> files) {
        for (FileStatus file : files) {
            if (file.isCorrupted()) continue;
            return false;
        }
        return true;
    }

    public List<String> getCurrentValidationIds() {
        return this.currentValidationIds;
    }

    public void addValidationId(String valId) {
        this.currentValidationIds.add(valId);
    }

    public void setHeaderInformation(HeaderReader.HeaderInformation headInformation) {
        this.headerInformation = headInformation;
    }

    public HeaderReader.HeaderInformation getHeaderInformation() {
        return this.headerInformation;
    }

    public String getGuid() {
        return this.headerInformation != null ? this.headerInformation.id : null;
    }

    public FileConfiguration getFileConfig() {
        return this.fileConfig;
    }
}

